CK_Loot = {};

function Ck_ProcessLoot() 
    if (IsFishingLoot()) then
        return;
    end
    if (Ck_IsMob()) then
        local zone = GetRealZoneText();
        local unit = {killed=1, name="", level=0, subzone="", money="", item="", elite=0};
        unit.name = UnitName("target");
        unit.level = UnitLevel("target");
        unit.subzone = GetSubZoneText();
        unit.money = "";
        unit.item = "";
        unit.elite = UnitIsPlusMob("target");
        local numItems = GetNumLootItems();
        for i=1, numItems do 
            if (LootSlotIsCoin(i)) then
                local _, coins = GetLootSlotInfo(i);
                unit.money = string.gsub(coins,"\n"," ");
            elseif (LootSlotIsItem(i)) then
                local itemLink = GetLootSlotLink(i);
                local itemId = Ck_getItemIdByLink(itemLink);
                Ck_SaveItem(itemLink);
                if (unit.item ~= "") then
                    unit.item = unit.item .. ",";
                end
                unit.item = unit.item .. itemId;
            end
        end -- end for
        Ck_SaveLoot(zone, unit);
    end
end

--[[
zone
    mobName
        level
        killed 
        subzone
        money
        items = itemid,itemid,...
]]
function Ck_SaveLoot(zone, mob)
    local localDate = CensusPlus_DetermineServerDate();
    local realm = GetRealmName();
    local char = UnitName("player");

    local mobDB;
    if (CK_Loot[realm] == nil) then
        CK_Loot[realm] = {};
    end
    if (CK_Loot[realm][char] == nil) then
        CK_Loot[realm][char] = {};
    end
    if (CK_Loot[realm][char][zone] == nil) then
        --CensusKr_Print("New Zone: " .. zone);
        CK_Loot[realm][char][zone] = {};
    end
    if (CK_Loot[realm][char][zone][mob.name] == nil) then
        CK_Loot[realm][char][zone][mob.name] = {level="", killed=0, subzone="", money="", items="", cdate=localDate, elite=0};
        --CensusKr_Print("New Mob: " .. mob.name);
    end
    mobDB = CK_Loot[realm][char][zone][mob.name];
    mobDB.elite = mob.elite;
    if (string.find(mobDB.level, mob.level) == nil) then
        if (mobDB.level ~= "") then
            mobDB.level = mobDB.level .. ",";
        end
        mobDB.level = mobDB.level .. mob.level;
    end
    mobDB.killed = mobDB.killed + mob.killed;
    if (string.find(mobDB.subzone, mob.subzone) == nil) then
        if (mobDB.subzone ~= "") then
            mobDB.subzone = mobDB.subzone .. ",";
        end
        mobDB.subzone = mobDB.subzone .. mob.subzone;
    end
    if (mobDB.money ~= "") then
        mobDB.money = mobDB.money .. ",";
    end
    mobDB.money = mobDB.money .. mob.money;
    if (mobDB.items ~= "") then
        mobDB.items = mobDB.items .. ",";
    end
    mobDB.items = mobDB.items .. mob.item;
end

function Ck_IsMob()
    if (not UnitName("target")) then
        return nil;
    end
    if (UnitIsPlayer("target")) then
        return nil;
    end
    if (UnitIsFriend("player", "target")) then
        return nil;
    end
    --[[
    if (not UnitIsEnemy("player", "target")) then
        return nil;
    end
    ]]
    --[[
    if (not UnitIsCorpse("target")) then
        return nil;
    end
    ]]
    if (not UnitIsDead("target")) then
        return nil;
    end
    return true;
end