/*
 * Created on 2004. 2. 18.
 *
 * To change the template for this generated file go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
package net.narusas.daap.server;

import junit.framework.TestCase;
import java.io.*;


/**
 * @author Administrator
 * 
 */
public class DaapRequestTest extends TestCase {

    static final String CRLF = "\r\n";

    public void testParsingServerInfo() throws Exception {
        String src = "GET /server-info HTTP/1.1" + CRLF
                + "Host: 192.168.1.100:3699" + CRLF + "Accept: */*" + CRLF
                + "User-Agent: iTunes/4.2 (Windows; N)" + CRLF
                + "Client-DAAP-Version: 2.0" + CRLF
                + "Client-DAAP-Access-Index: 1" + CRLF 
				+ CRLF;
        InputStream in = new BufferedInputStream(new ByteArrayInputStream(src.getBytes()));
        DaapRequest req = new DaapRequest(in);
        assertEquals("MSRV",req.getResponse());
    }
    
    public void testParsingContentCodes() throws Exception {
        String src = "GET /content-codes HTTP/1.1"+ CRLF+
						"Host: 192.168.1.100"+ CRLF+
						"Client-DAAP-Version: 2.0"+ CRLF+
						"User-Agent: iTunes/4.2 (Windows; N)"+ CRLF+
						"Accept-Language: ko-kr, ko;q=0.75, en-us;q=0.50, en;q=0.25"+ CRLF+
						"Client-DAAP-Access-Index: 1" + CRLF + CRLF;
        InputStream in = new BufferedInputStream(new ByteArrayInputStream(src.getBytes()));
        DaapRequest req = new DaapRequest(in);
        assertEquals("MCCR",req.getResponse());
        
    }
    
    public void testLogin() throws Exception {
        String src = "GET /login HTTP/1.1"+CRLF+
						"Host: 192.168.1.100"+CRLF+
						"Client-DAAP-Version: 2.0"+CRLF+
						"User-Agent: iTunes/4.2 (Windows; N)"+CRLF+
						"Accept-Language: ko-kr, ko;q=0.75, en-us;q=0.50, en;q=0.25"+CRLF+
						"Client-DAAP-Access-Index: 1"+CRLF+
						CRLF;
        InputStream in = new BufferedInputStream(new ByteArrayInputStream(src.getBytes()));
        DaapRequest req = new DaapRequest(in);
        assertEquals("MLOG",req.getResponse());
        
    }
    
    public void testUpdate() throws Exception {
        String src = "GET /update?session-id=1517514686&revision-number=1 HTTP/1.1"+CRLF+
						"Host: 192.168.1.100"+CRLF+
						"Client-DAAP-Version: 2.0"+CRLF+
						"User-Agent: iTunes/4.2 (Windows; N)"+CRLF+
						"Accept-Language: ko-kr, ko;q=0.75, en-us;q=0.50, en;q=0.25"+CRLF+
						"Client-DAAP-Validation: E6E20DE3EA343C37CF99A2AB9233069E"+CRLF+
						"Client-DAAP-Access-Index: 1"+CRLF+
						CRLF;
        InputStream in = new BufferedInputStream(new ByteArrayInputStream(src.getBytes()));
        DaapRequest req = new DaapRequest(in);
        assertEquals("MUPD",req.getResponse());
        assertEquals("1517514686",req.getSessionId());
        assertEquals(1,req.getRevision());
        
    }
    
    public void testDatabase() throws Exception {
        String src = "GET /databases?session-id=1517514686&revision-number=10 HTTP/1.1"+CRLF+
						"Host: 192.168.1.100"+CRLF+
						"Client-DAAP-Version: 2.0"+CRLF+
						"User-Agent: iTunes/4.2 (Windows; N)"+CRLF+
						"Accept-Language: ko-kr, ko;q=0.75, en-us;q=0.50, en;q=0.25"+CRLF+
						"Client-DAAP-Validation: 94B9251C51D34E6D177B0BB8324CF7C8"+CRLF+
						"Client-DAAP-Access-Index: 1"+CRLF+
						CRLF;
        InputStream in = new BufferedInputStream(new ByteArrayInputStream(src.getBytes()));
        DaapRequest req = new DaapRequest(in);
        assertEquals("AVDB",req.getResponse());
        assertEquals("1517514686",req.getSessionId());
        assertEquals(10,req.getRevision());
        
    }
    
    public void testDatabases() throws Exception {
        String src = "GET /databases/32/items?type=music&meta=dmap.itemid,dmap.itemname,dmap.itemkind,dmap.persistentid,daap.songalbum,daap.songgrouping,daap.songartist,daap.songbitrate,daap.songbeatsperminute,daap.songcomment,daap.songcompilation,daap.songcomposer,daap.songdateadded,daap.songdatemodified,daap.songdisccount,daap.songdiscnumber,daap.songdisabled,daap.songeqpreset,daap.songformat,daap.songgenre,daap.songdescription,daap.songrelativevolume,daap.songsamplerate,daap.songsize,daap.songstarttime,daap.songstoptime,daap.songtime,daap.songtrackcount,daap.songtracknumber,daap.songuserrating,daap.songyear,daap.songdatakind,daap.songdataurl,com.apple.itunes.norm-volume&session-id=1517514686&revision-number=10 HTTP/1.1"+CRLF+
						"Host: 192.168.1.100"+CRLF+
						"Client-DAAP-Version: 2.0"+CRLF+
						"User-Agent: iTunes/4.2 (Windows; N)"+CRLF+
						"Accept-Language: ko-kr, ko;q=0.75, en-us;q=0.50, en;q=0.25"+CRLF+
						"Client-DAAP-Validation: 574AC394232266DFDCB9A6F9F347851B"+CRLF+
						"Client-DAAP-Access-Index: 1"+CRLF+
						CRLF;
        InputStream in = new BufferedInputStream(new ByteArrayInputStream(src.getBytes()));
        DaapRequest req = new DaapRequest(in);
        
        assertEquals("ADBS",req.getResponse());
        assertEquals("1517514686",req.getSessionId());
        assertEquals(10,req.getRevision());
        assertEquals("32",req.getDatabase());
        
        assertTrue(req.containMeta("dmap.itemid"));
        assertTrue(req.containMeta("dmap.itemname"));
        assertTrue(req.containMeta("dmap.itemkind"));
        assertTrue(req.containMeta("com.apple.itunes.norm-volume"));
        assertFalse(req.containMeta("ddd.ddd"));
                
    }
    
    public void testContainers() throws Exception {
        String src = "GET /databases/32/containers?meta=dmap.itemid,dmap.itemname,dmap.persistentid,com.apple.itunes.smart-playlist&session-id=1517514686&revision-number=10 HTTP/1.1"+CRLF+
						"Host: 192.168.1.100"+CRLF+
						"Client-DAAP-Version: 2.0"+CRLF+
						"User-Agent: iTunes/4.2 (Windows; N)"+CRLF+
						"Accept-Language: ko-kr, ko;q=0.75, en-us;q=0.50, en;q=0.25"+CRLF+
						"Client-DAAP-Validation: 39530328BDE52F77692355F80AE64A69"+CRLF+
						"Client-DAAP-Access-Index: 1"+CRLF+
						CRLF;
        InputStream in = new BufferedInputStream(new ByteArrayInputStream(src.getBytes()));
        DaapRequest req = new DaapRequest(in);
        
        assertEquals("APLY",req.getResponse());
        assertEquals("1517514686",req.getSessionId());
        assertEquals(10,req.getRevision());
        assertEquals("32",req.getDatabase());
        
        assertTrue(req.containMeta("dmap.itemid"));
        assertTrue(req.containMeta("com.apple.itunes.smart-playlist"));
        assertFalse(req.containMeta("ddd.ddd"));
                
    }
    
    public void testContainer() throws Exception {
        String src = "GET /databases/32/containers/36/items?type=music&meta=dmap.itemkind,dmap.itemid,dmap.containeritemid&session-id=1517514686&revision-number=10 HTTP/1.1"+CRLF+
						"Host: 192.168.1.100"+CRLF+
						"Client-DAAP-Version: 2.0"+CRLF+
						"User-Agent: iTunes/4.2 (Windows; N)"+CRLF+
						"Accept-Language: ko-kr, ko;q=0.75, en-us;q=0.50, en;q=0.25"+CRLF+
						"Client-DAAP-Validation: AD2EA6ED8B2C9A940EF29AA62BC12B0C"+CRLF+
						"Client-DAAP-Access-Index: 1"+CRLF+
						CRLF;
        InputStream in = new BufferedInputStream(new ByteArrayInputStream(src.getBytes()));
        DaapRequest req = new DaapRequest(in);
        
        assertEquals("APSO",req.getResponse());
        assertEquals("1517514686",req.getSessionId());
        assertEquals(10,req.getRevision());
        assertEquals("32",req.getDatabase());
        assertEquals("36",req.getPlaylist());
        
        assertTrue(req.containMeta("dmap.itemid"));
        assertTrue(req.containMeta("dmap.containeritemid"));
        assertFalse(req.containMeta("ddd.ddd"));                
    }
    
    public void testMP3() throws Exception {
        String src = "GET /databases/31/items/21.mp3?session-id=462121433 HTTP/1.1"+CRLF+
						"Host: 192.168.1.100:3699"+CRLF+
						"Cache-Control: no-cache"+CRLF+
						"Accept: */*"+CRLF+
						"x-audiocast-udpport:1230"+CRLF+
						"icy-metadata:1"+CRLF+
						"User-Agent: iTunes/4.2 (Windows; N)"+CRLF+
						"Connection: close"+CRLF+
						"Client-DAAP-Access-Index: 1"+CRLF+
						"Client-DAAP-Validation: 082AC24D0100A60352256DAD7B571575"+CRLF+
						CRLF;
        InputStream in = new BufferedInputStream(new ByteArrayInputStream(src.getBytes()));
        DaapRequest req = new DaapRequest(in);
        
        assertEquals("MP3D",req.getResponse());
        assertEquals("462121433",req.getSessionId());        
        assertEquals("31",req.getDatabase());
        assertEquals("21.mp3",req.getMP3());
    }   
    
}
