/*
 * Created on 2004. 2. 19.
 */

package net.narusas.daap.server.response;

import net.narusas.daap.server.*;
import net.narusas.daap.server.api.*;
import net.narusas.daap.server.tag.*;

/**
 * @author Jisung, Ahn
 */
public class DatabasesResponse implements DaapResponse {

	ListTag avdb;

	public DatabasesResponse(DaapRequest req, Database _db) {
		Playlist[] playlists = _db.getPlaylists();
		avdb = Tag.listTag("avdb");
		avdb.addTag(Tag.integerTag("mstt", 200));
		avdb.addTag(Tag.byteTag("muty", 0));
		avdb.addTag(Tag.integerTag("mtco", playlists.length));
		avdb.addTag(Tag.integerTag("mrco", playlists.length));
		ListTag mdcl = Tag.listTag("mlcl");
		avdb.addTag(mdcl);
		for (int i = 0; i < playlists.length; i++) {
			Playlist playlist = playlists[i];
			ListTag mlit = Tag.listTag("mlit");
			mdcl.addTag(mlit);
			mlit.addTag(Tag.integerTag("miid", playlist.getUID()));
			mlit.addTag(Tag.stringTag("minm", playlist.getName()));
			mlit.addTag(Tag.integerTag("mimc", playlist.getAllSongs().length));
			mlit.addTag(Tag.integerTag("mctc", playlist.getUID()));
		}
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see net.narusas.daap.server.api.DaapResponse#getResponse()
	 */
	public ListTag getResponse() {
		return avdb;
	}
}
