/*
 * Created on 2004. 2. 18.
 *
 */
package net.narusas.daap.server.tag;


/**
 * @author Administrator
 *
 */
public class LongTag extends Tag {

    protected long _data;

    public LongTag(String name) {
        _name = name;
        _type = Tag.TYPE_SIGNED_LONG;
    }


    public void setData(long data) {
        _data = data;
    }

    public byte[] getData() {   
        byte[] b = new byte[8];
        b[7] = (byte) (_data & 0xFF);
        b[6] = (byte) ( (_data >>> 8) & 0xFF);
        b[5] = (byte) ( (_data >>> 16) & 0xFF);
        b[4] = (byte) ( (_data >>> 24) & 0xFF);
        b[3] = (byte) ( (_data >>> 32) & 0xFF);
        b[2] = (byte) ( (_data >>> 40) & 0xFF);
        b[1] = (byte) ( (_data >>> 48) & 0xFF);
        b[0] = (byte) ( (_data >>> 56) & 0xFF);        
        return b;
    }    
    
    public int getDataLength() {
        return 8;
    }

}
