/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import net.sf.l2j.gameserver.model.L2PcInstance;

public final class Config {
    public static final boolean DEBUG;
    public static final boolean ASSERT;
    public static final boolean DEVELOPER;
    public static final int PORT_GAME;
    public static final int PORT_LOGIN;
    public static final int LOGIN_TRY_BEFORE_BAN;
    public static final String DEFAULT_GLOBAL_CHAT;
    public static final boolean EVERYBODY_HAS_ADMIN_RIGHTS;
    public static final boolean ALT_GAME_CREATION;
    public static final boolean ALT_GAME_SKILL_LEARN;
    public static final boolean ALT_GAME_CANCEL_ALL;
    public static final boolean ALT_GAME_CANCEL_BOW;
    public static final boolean ALT_GAME_CANCEL_CAST;
    public static final boolean ALT_GAME_TIREDNESS;
    public static final boolean ALT_GAME_SHIELD_BLOCKS;
    public static final boolean ALT_GAME_MOB_ATTACK_AI;
    public static final boolean ALT_GAME_DELEVEL;
    public static final boolean SP_BOOK_NEEDED;
    public static final boolean LOG_CHAT;
    public static final int GM_ACCESSLEVEL;
    public static final int GM_MIN;
    public static final int GM_ANNOUNCE;
    public static final int GM_BAN;
    public static final int GM_CREATE_ITEM;
    public static final int GM_DELETE;
    public static final int GM_KICK;
    public static final int GM_MENU;
    public static final int GM_GODMODE;
    public static final int GM_CHAR_EDIT;
    public static final int GM_NPC_EDIT;
    public static final int GM_TELEPORT;
    public static final int GM_RESTART;
    public static final int GM_MONSTERRACE;
    public static final int GM_RIDER;
    public static final int GM_ESCAPE;
    public static final int GM_FIXED;
    public static final int GM_USE_FORTH;
    public static final int GM_CREATE_NODES;
    public static final int GM_DOOR;
    public static final int CG_HIREPRICE;
    public static final int CG_HIRE;
    public static final int CG_KILL;
    public static final int CG_MAXHIREDGUARDS;
    public static final int CG_VIEWSTATS;
    public static final int CG_STATUPPROB;
    public static final int CG_STATUPGAIN;
    public static final int CG_MOVEMENT;
    public static final int CG_SET;
    public static final int CG_CASTLE;
    public static final boolean CG_SPAWNSIEGEGUARDS;
    public static final float RATE_XP;
    public static final float RATE_SP;
    public static final float RATE_QUESTS_REWARD;
    public static final float RATE_DROP_ADENA;
    public static final float RATE_DROP_ITEMS;
    public static final float RATE_DROP_SPOIL;
    public static final float RATE_DROP_EQUIPMENT;
    public static final float ALT_GAME_EXPONENT_XP;
    public static final float ALT_GAME_EXPONENT_SP;
    public static final File DATAPACK_ROOT;
    public static final int MAX_DRIFT_RANGE;
    public static final L2WalkerAllowed ALLOW_L2WALKER_CLIENT;
    public static final int L2WALKER_REVISION;
    public static final boolean ALLOW_WAREHOUSE;
    public static final int WYVERN_SPEED;
    public static final int STRIDER_SPEED;
    public static final int MIN_PROTOCOL_REVISION;
    public static final int MAX_PROTOCOL_REVISION;
    public static final int MIN_NPC_ANIMATION;
    public static final int MAX_NPC_ANIMATION;
    public static final boolean ACTIVATE_POSITION_RECORDER;
    public static final boolean USE_3D_MAP;
    public static final boolean SHOW_LEVEL_COMMUNITYBOARD;
    public static final String CONFIGURATION_FILE = "/config/server.properties";
    public static final String VERSION_FILE = "/config/l2j-version.properties";
    public static final String SIEGE_CONFIGURATION_FILE = "/config/siege.properties";
    public static final String BANNED_IP_XML = "/config/banned.xml";
    public static final int GAME_SERVER_LOGIN_PORT = 9013;
    public static final String INTERNAL_HOSTNAME;
    public static final String EXTERNAL_HOSTNAME;
    public static final int PATH_NODE_RADIUS;
    public static int NEW_NODE_ID;
    public static int SELECTED_NODE_ID;
    public static int LINKED_NODE_ID;
    public static String NEW_NODE_TYPE;
    public static final boolean SERVER_SIDE_NPC_NAME;
    public static final boolean SERVER_SIDE_NPC_NAME_WITH_LVL;
    public static final boolean ALLOW_GUARDS;
    public static final boolean ALLOW_CLASS_MASTERS;
    public static String SERVER_VERSION;
    public static String SERVER_BUILD_DATE;
    public static final boolean IS_CRAFTING_ENABLED;
    public static final int INVENTORY_MAXIMUM_CHAR;
    public static final int INVENTORY_MAXIMUM_GM;
    public static final boolean CAN_SPOIL_LOWER_LEVEL_MOBS;
    public static final boolean CAN_DELEVEL_AND_SPOIL_MOBS;
    public static final float MAXIMUM_PLAYER_AND_MOB_LEVEL_DIFFERENCE;
    public static final float BASE_SPOIL_RATE;
    public static final float MINIMUM_SPOIL_RATE;
    public static final float SPOIL_LEVEL_DIFFERENCE_LIMIT;
    public static final float SPOIL_LEVEL_DIFFERENCE_MULTIPLIER;
    public static final int LAST_LEVEL_SPOIL_IS_LEARNED;
    public static final int KARMA_MIN_KARMA;
    public static final int KARMA_MAX_KARMA;
    public static final int KARMA_XP_DIVIDER;
    public static final int KARMA_LOST_BASE;
    public static final boolean KARMA_DROP_EQUIPPED_ITEMS;
    public static final boolean KARMA_DROP_EQUIPPED_WEAPONS;
    public static final boolean KARMA_DROP_INVENTORY_PETS;
    public static final boolean KARMA_DROP_GM;
    public static final boolean KARMA_AWARD_PK_KILL;
    public static final int KARMA_DROP_CONSTANT;
    public static final int KARMA_PK_LIMIT;
    public static final int KARMA_DROP_ITEM_LIMIT;
    public static final int KARMA_RANDOM_DROP_LOCATION_LIMIT;
    public static final float KARMA_DROPCHANCE_MINIMUM;
    public static final float KARMA_DROPCHANCE_INITIAL_CHECK;
    public static final float KARMA_DROPCHANCE_EQUIPMENT;
    public static final float KARMA_DROPCHANCE_EQUIPPED_WEAPON;
    public static final float KARMA_DROPCHANCE_EQUIPPED_OTHER;
    public static final float KARMA_DROPCHANCE_UNEQUIPPED_ITEMS;
    public static final String KARMA_NONDROPPABLE_PET_ITEMS;
    public static final String KARMA_NONDROPPABLE_ITEMS;
    public static ArrayList<Integer> KARMA_LIST_NONDROPPABLE_PET_ITEMS;
    public static ArrayList<Integer> KARMA_LIST_NONDROPPABLE_ITEMS;
    public static final int PVP_TIME;
    public static final ObjectMapType MAP_TYPE;
    public static final ObjectSetType SET_TYPE;
    public static final int ADMIN_TEST;
    public static final boolean COMPACTION;
    public static final boolean EFFECT_CANCELING;
    public static final int ENCHANT_CHANCE;

    public static boolean allowL2Walker(L2PcInstance player) {
        return ALLOW_L2WALKER_CLIENT == L2WalkerAllowed.True || ALLOW_L2WALKER_CLIENT == L2WalkerAllowed.GM && player != null && player.isGM();
    }

    private Config() {
    }

    static {
        KARMA_LIST_NONDROPPABLE_PET_ITEMS = new ArrayList();
        KARMA_LIST_NONDROPPABLE_ITEMS = new ArrayList();
        try {
            Properties serverSettings = new Properties();
            InputStream is = Config.class.getResourceAsStream(CONFIGURATION_FILE);
            serverSettings.load(is);
            is.close();
            DEBUG = Boolean.parseBoolean(serverSettings.getProperty("Debug", "false"));
            DEVELOPER = Boolean.parseBoolean(serverSettings.getProperty("Developer", "false"));
            ASSERT = Boolean.parseBoolean(serverSettings.getProperty("Assert", "false"));
            PORT_GAME = Integer.parseInt(serverSettings.getProperty("GameserverPort", "7777"));
            PORT_LOGIN = Integer.parseInt(serverSettings.getProperty("LoginserverPort", "2106"));
            LOGIN_TRY_BEFORE_BAN = Integer.parseInt(serverSettings.getProperty("LoginTryBeforeBan", "10"));
            DEFAULT_GLOBAL_CHAT = serverSettings.getProperty("GlobalChat", "ON");
            ALT_GAME_TIREDNESS = Boolean.parseBoolean(serverSettings.getProperty("AltGameTiredness", "false"));
            ALT_GAME_CREATION = Boolean.parseBoolean(serverSettings.getProperty("AltGameCreation", "false"));
            ALT_GAME_SKILL_LEARN = Boolean.parseBoolean(serverSettings.getProperty("AltGameSkillLearn", "false"));
            ALT_GAME_CANCEL_ALL = serverSettings.getProperty("AltGameCancelByHit", "").indexOf("all") >= 0;
            ALT_GAME_CANCEL_BOW = serverSettings.getProperty("AltGameCancelByHit", "").indexOf("bow") >= 0;
            ALT_GAME_CANCEL_CAST = serverSettings.getProperty("AltGameCancelByHit", "").indexOf("cast") >= 0;
            ALT_GAME_SHIELD_BLOCKS = Boolean.parseBoolean(serverSettings.getProperty("AltShieldBlocks", "true"));
            ALT_GAME_DELEVEL = Boolean.parseBoolean(serverSettings.getProperty("Delevel", "true"));
            ALT_GAME_MOB_ATTACK_AI = Boolean.parseBoolean(serverSettings.getProperty("AltGameMobAttackAI", "false"));
            SP_BOOK_NEEDED = Boolean.parseBoolean(serverSettings.getProperty("SpBookNeeded", "true"));
            EVERYBODY_HAS_ADMIN_RIGHTS = Boolean.parseBoolean(serverSettings.getProperty("EverybodyHasAdminRights", "false"));
            LOG_CHAT = Boolean.valueOf(serverSettings.getProperty("LogChat", "false"));
            GM_ACCESSLEVEL = Integer.parseInt(serverSettings.getProperty("GMAccessLevel", "100"));
            GM_MIN = Integer.parseInt(serverSettings.getProperty("GMMinLevel", "100"));
            GM_ANNOUNCE = Integer.parseInt(serverSettings.getProperty("GMCanAnnounce", "100"));
            GM_BAN = Integer.parseInt(serverSettings.getProperty("GMCanBan", "100"));
            GM_CREATE_ITEM = Integer.parseInt(serverSettings.getProperty("GMCanShop", "100"));
            GM_DELETE = Integer.parseInt(serverSettings.getProperty("GMCanDelete", "100"));
            GM_KICK = Integer.parseInt(serverSettings.getProperty("GMCanKick", "100"));
            GM_MENU = Integer.parseInt(serverSettings.getProperty("GMMenu", "100"));
            GM_GODMODE = Integer.parseInt(serverSettings.getProperty("GMGodMode", "100"));
            GM_CHAR_EDIT = Integer.parseInt(serverSettings.getProperty("GMCanEditChar", "100"));
            GM_NPC_EDIT = Integer.parseInt(serverSettings.getProperty("GMCanEditNPC", "100"));
            GM_TELEPORT = Integer.parseInt(serverSettings.getProperty("GMCanTeleport", "100"));
            GM_RESTART = Integer.parseInt(serverSettings.getProperty("GMCanRestart", "100"));
            GM_MONSTERRACE = Integer.parseInt(serverSettings.getProperty("GMMonsterRace", "100"));
            GM_RIDER = Integer.parseInt(serverSettings.getProperty("GMRider", "100"));
            GM_ESCAPE = Integer.parseInt(serverSettings.getProperty("GMFastUnstuck", "100"));
            GM_FIXED = Integer.parseInt(serverSettings.getProperty("GMResurectFixed", "100"));
            GM_USE_FORTH = Integer.parseInt(serverSettings.getProperty("GMUseForth", "100"));
            GM_CREATE_NODES = Integer.parseInt(serverSettings.getProperty("GMCreateNodes", "100"));
            GM_DOOR = Integer.parseInt(serverSettings.getProperty("GMDoor", "100"));
            CG_HIREPRICE = Integer.parseInt(serverSettings.getProperty("AncientAdena", "100"));
            CG_HIRE = Integer.parseInt(serverSettings.getProperty("CGHire", "110"));
            CG_MAXHIREDGUARDS = Integer.parseInt(serverSettings.getProperty("CGMaxHiredGuards", "50"));
            CG_KILL = Integer.parseInt(serverSettings.getProperty("CGKill", "70"));
            CG_VIEWSTATS = Integer.parseInt(serverSettings.getProperty("CGViewStats", "80"));
            CG_STATUPGAIN = Integer.parseInt(serverSettings.getProperty("CGStatUpGain", "1"));
            CG_STATUPPROB = Integer.parseInt(serverSettings.getProperty("CGStatUpProb", "1"));
            CG_MOVEMENT = Integer.parseInt(serverSettings.getProperty("CGMovement", "40"));
            CG_CASTLE = Integer.parseInt(serverSettings.getProperty("CGCastle", "120"));
            CG_SET = Integer.parseInt(serverSettings.getProperty("CGSet", "100"));
            CG_SPAWNSIEGEGUARDS = Boolean.parseBoolean(serverSettings.getProperty("CGSpawnSiegeGuards", "false"));
            ADMIN_TEST = Integer.parseInt(serverSettings.getProperty("ADMINTest", "100"));
            RATE_XP = Float.parseFloat(serverSettings.getProperty("RateXp", "1."));
            RATE_SP = Float.parseFloat(serverSettings.getProperty("RateSp", "1."));
            RATE_QUESTS_REWARD = Float.parseFloat(serverSettings.getProperty("RateQuestsReward", "1."));
            RATE_DROP_ADENA = Float.parseFloat(serverSettings.getProperty("RateDropAdena", "1."));
            RATE_DROP_ITEMS = Float.parseFloat(serverSettings.getProperty("RateDropItems", "1."));
            RATE_DROP_SPOIL = Float.parseFloat(serverSettings.getProperty("RateDropSpoil", "1."));
            RATE_DROP_EQUIPMENT = Float.parseFloat(serverSettings.getProperty("RateDropEquipment", "1."));
            ALT_GAME_EXPONENT_XP = Float.parseFloat(serverSettings.getProperty("AltGameExponentXp", "0."));
            ALT_GAME_EXPONENT_SP = Float.parseFloat(serverSettings.getProperty("AltGameExponentSp", "0."));
            DATAPACK_ROOT = new File(serverSettings.getProperty("DatapackRoot", ".")).getCanonicalFile();
            MAX_DRIFT_RANGE = Integer.parseInt(serverSettings.getProperty("MaxDriftRange", "300"));
            ALLOW_L2WALKER_CLIENT = L2WalkerAllowed.valueOf(serverSettings.getProperty("AllowL2Walker", "False"));
            L2WALKER_REVISION = Integer.parseInt(serverSettings.getProperty("L2WalkerRevision", "537"));
            ALLOW_WAREHOUSE = Boolean.valueOf(serverSettings.getProperty("AllowWarehouse", "False"));
            WYVERN_SPEED = Integer.parseInt(serverSettings.getProperty("WyvernSpeed", "100"));
            STRIDER_SPEED = Integer.parseInt(serverSettings.getProperty("StriderSpeed", "80"));
            MIN_PROTOCOL_REVISION = Integer.parseInt(serverSettings.getProperty("MinProtocolRevision", "551"));
            MAX_PROTOCOL_REVISION = Integer.parseInt(serverSettings.getProperty("MaxProtocolRevision", "553"));
            if (MIN_PROTOCOL_REVISION > MAX_PROTOCOL_REVISION) {
                throw new Error("MinProtocolRevision is bigger than MaxProtocolRevision in server configuration file.");
            }
            ACTIVATE_POSITION_RECORDER = Boolean.valueOf(serverSettings.getProperty("ActivatePositionRecorder", "False"));
            USE_3D_MAP = Boolean.valueOf(serverSettings.getProperty("Use3DMap", "False"));
            SHOW_LEVEL_COMMUNITYBOARD = Boolean.valueOf(serverSettings.getProperty("ShowLevelOnCommunityBoard", "False"));
            MIN_NPC_ANIMATION = Integer.parseInt(serverSettings.getProperty("MinNPCAnimation", "0"));
            MAX_NPC_ANIMATION = Integer.parseInt(serverSettings.getProperty("MaxNPCAnimation", "0"));
            INTERNAL_HOSTNAME = serverSettings.getProperty("ExternalHostname", "localhost");
            EXTERNAL_HOSTNAME = serverSettings.getProperty("ExternalHostname", "localhost");
            PATH_NODE_RADIUS = Integer.parseInt(serverSettings.getProperty("PathNodeRadius", "50"));
            NEW_NODE_ID = Integer.parseInt(serverSettings.getProperty("NewNodeId", "7952"));
            SELECTED_NODE_ID = Integer.parseInt(serverSettings.getProperty("NewNodeId", "7952"));
            LINKED_NODE_ID = Integer.parseInt(serverSettings.getProperty("NewNodeId", "7952"));
            NEW_NODE_TYPE = serverSettings.getProperty("NewNodeType", "npc");
            SERVER_SIDE_NPC_NAME = Boolean.valueOf(serverSettings.getProperty("ServerSideNpcName", "False"));
            SERVER_SIDE_NPC_NAME_WITH_LVL = Boolean.valueOf(serverSettings.getProperty("ServerSideNpcNameWithLvl", "False"));
            ALLOW_GUARDS = Boolean.valueOf(serverSettings.getProperty("AllowGuards", "False"));
            ALLOW_CLASS_MASTERS = Boolean.valueOf(serverSettings.getProperty("AllowClassMasters", "False"));
            MAP_TYPE = ObjectMapType.valueOf(serverSettings.getProperty("L2Map", "L2ObjectHashMap"));
            SET_TYPE = ObjectSetType.valueOf(serverSettings.getProperty("L2Set", "L2ObjectHashSet"));
            COMPACTION = Boolean.valueOf(serverSettings.getProperty("DatabaseCompaction", "True"));
            EFFECT_CANCELING = Boolean.valueOf(serverSettings.getProperty("CancelLesserEffect", "True"));
            KARMA_MIN_KARMA = Integer.parseInt(serverSettings.getProperty("MinKarma", "240"));
            KARMA_MAX_KARMA = Integer.parseInt(serverSettings.getProperty("MaxKarma", "10000"));
            KARMA_XP_DIVIDER = Integer.parseInt(serverSettings.getProperty("XPDivider", "72"));
            KARMA_LOST_BASE = Integer.parseInt(serverSettings.getProperty("BaseKarmaLost", "240"));
            String DroppableEquipment = serverSettings.getProperty("DroppableEquipment", "true");
            KARMA_DROP_EQUIPPED_ITEMS = Boolean.parseBoolean(DroppableEquipment);
            String DroppableWeapon = serverSettings.getProperty("DroppableWeapon", "true");
            KARMA_DROP_EQUIPPED_WEAPONS = Boolean.parseBoolean(DroppableWeapon);
            String DroppablePets = serverSettings.getProperty("DroppablePets", "true");
            KARMA_DROP_INVENTORY_PETS = Boolean.parseBoolean(DroppablePets);
            String CanGMDropEquipment = serverSettings.getProperty("CanGMDropEquipment", "false");
            KARMA_DROP_GM = Boolean.parseBoolean(CanGMDropEquipment);
            String AwardPKKillPVPPoint = serverSettings.getProperty("AwardPKKillPVPPoint", "true");
            KARMA_AWARD_PK_KILL = Boolean.parseBoolean(AwardPKKillPVPPoint);
            KARMA_DROP_CONSTANT = Integer.parseInt(serverSettings.getProperty("DropConstant", "10000"));
            KARMA_PK_LIMIT = Integer.parseInt(serverSettings.getProperty("MinimumPKRequiredToDrop", "5"));
            KARMA_DROP_ITEM_LIMIT = Integer.parseInt(serverSettings.getProperty("MaxItemsDroppable", "10"));
            KARMA_RANDOM_DROP_LOCATION_LIMIT = Integer.parseInt(serverSettings.getProperty("MaxDropThrowDistance", "70"));
            KARMA_DROPCHANCE_MINIMUM = Float.parseFloat(serverSettings.getProperty("ChanceOfDropMinimum", "1."));
            KARMA_DROPCHANCE_INITIAL_CHECK = Float.parseFloat(serverSettings.getProperty("ChanceOfDropInitial", "40."));
            KARMA_DROPCHANCE_EQUIPMENT = Float.parseFloat(serverSettings.getProperty("ChanceOfDropEquipped", "10."));
            KARMA_DROPCHANCE_EQUIPPED_WEAPON = Float.parseFloat(serverSettings.getProperty("ChanceOfDropEquippedWeapon", "10."));
            KARMA_DROPCHANCE_EQUIPPED_OTHER = Float.parseFloat(serverSettings.getProperty("ChanceOfDropEquippedItem", "80."));
            KARMA_DROPCHANCE_UNEQUIPPED_ITEMS = Float.parseFloat(serverSettings.getProperty("ChanceOfDropUnequipped", "70."));
            KARMA_NONDROPPABLE_PET_ITEMS = serverSettings.getProperty("ListOfPetItems", "3500,3501,3502,4422,4423,4424,2375");
            KARMA_NONDROPPABLE_ITEMS = serverSettings.getProperty("ListOfNonDroppableItems", "57,1147,425,1146,461,10,2368,7,6,2370,2369");
            ArrayList<Integer> KARMA_LIST_NONDROPPABLE_PET_ITEMS = new ArrayList<Integer>();
            for (String id : KARMA_NONDROPPABLE_PET_ITEMS.split(",")) {
                KARMA_LIST_NONDROPPABLE_PET_ITEMS.add(Integer.parseInt(id));
            }
            ArrayList<Integer> KARMA_LIST_NONDROPPABLE_ITEMS = new ArrayList<Integer>();
            for (String id : KARMA_NONDROPPABLE_ITEMS.split(",")) {
                KARMA_LIST_NONDROPPABLE_ITEMS.add(Integer.parseInt(id));
            }
            PVP_TIME = Integer.parseInt(serverSettings.getProperty("PvPTime", "15000"));
            String CraftingEnabled = serverSettings.getProperty("CraftingEnabled", "true");
            IS_CRAFTING_ENABLED = Boolean.parseBoolean(CraftingEnabled);
            String CanSpoilLowerLevelMobs = serverSettings.getProperty("CanSpoilLowerLevelMobs", "false");
            CAN_SPOIL_LOWER_LEVEL_MOBS = Boolean.parseBoolean(CanSpoilLowerLevelMobs);
            String CanDelevelToSpoil = serverSettings.getProperty("CanDelevelToSpoil", "true");
            CAN_DELEVEL_AND_SPOIL_MOBS = Boolean.parseBoolean(CanDelevelToSpoil);
            MAXIMUM_PLAYER_AND_MOB_LEVEL_DIFFERENCE = Float.parseFloat(serverSettings.getProperty("MaximumPlayerAndMobLevelDifference", "9."));
            BASE_SPOIL_RATE = Float.parseFloat(serverSettings.getProperty("BasePercentChanceOfSpoilSuccess", "40."));
            MINIMUM_SPOIL_RATE = Float.parseFloat(serverSettings.getProperty("MinimumPercentChanceOfSpoilSuccess", "3."));
            SPOIL_LEVEL_DIFFERENCE_LIMIT = Float.parseFloat(serverSettings.getProperty("SpoilLevelDifferenceLimit", "5."));
            SPOIL_LEVEL_DIFFERENCE_MULTIPLIER = Float.parseFloat(serverSettings.getProperty("SpoilLevelMultiplier", "7."));
            LAST_LEVEL_SPOIL_IS_LEARNED = Integer.parseInt(serverSettings.getProperty("LastLevelSpoilIsLearned", "72"));
            INVENTORY_MAXIMUM_CHAR = Integer.parseInt(serverSettings.getProperty("MaximumSlotsForNormalPlayer", "80"));
            INVENTORY_MAXIMUM_GM = Integer.parseInt(serverSettings.getProperty("MaximumSlotsForGMPlayer", "250"));
            ENCHANT_CHANCE = Integer.parseInt(serverSettings.getProperty("EnchantChance", "65"));
            try {
                Properties serverVersion = new Properties();
                is = Config.class.getResourceAsStream(VERSION_FILE);
                serverVersion.load(is);
                is.close();
                SERVER_VERSION = serverVersion.getProperty("version", "Unsupported Custom Version.");
                SERVER_BUILD_DATE = serverVersion.getProperty("builddate", "Undefined Date.");
            }
            catch (Exception e) {
                SERVER_VERSION = "Unsupported Custom Version.";
                SERVER_BUILD_DATE = "Undefined Date.";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Error("Failed to load configuration");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ObjectSetType {
        L2ObjectHashSet,
        WorldObjectSet;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ObjectMapType {
        L2ObjectHashMap,
        WorldObjectMap;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum L2WalkerAllowed {
        True,
        False,
        GM;

    }
}

