/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.accountmanager;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.sf.l2j.Base64;
import net.sf.l2j.L2DatabaseFactory;

public class SQLAccountManager {
    private static String _uname = "";
    private static String _pass = "";
    private static String _level = "";
    private static String _mode = "";

    public static void main(String[] args) throws SQLException, IOException, NoSuchAlgorithmException {
        System.out.println("Welcome to l2jRU account manager.");
        System.out.println("THIS ONLY WORKS ON SQL SERVER BUILDS");
        System.out.println("Please choose one:");
        System.out.println("1 - Create new account or update existing one (change pass and access level)");
        System.out.println("2 - Change access level");
        System.out.println("3 - Delete existing account");
        System.out.println("4 - List accounts & access levels");
        System.out.println("5 - exit");
        LineNumberReader _in = new LineNumberReader(new InputStreamReader(System.in));
        while (!(_mode.equals("1") || _mode.equals("2") || _mode.equals("3") || _mode.equals("4") || _mode.equals("5"))) {
            System.out.print("Your choice: ");
            _mode = _in.readLine();
        }
        if (_mode.equals("1") || _mode.equals("2") || _mode.equals("3")) {
            if (_mode.equals("1") || _mode.equals("2") || _mode.equals("3")) {
                while (_uname.length() == 0) {
                    System.out.print("username: ");
                    _uname = _in.readLine();
                }
            }
            if (_mode.equals("1")) {
                while (_pass.length() == 0) {
                    System.out.print("password: ");
                    _pass = _in.readLine();
                }
            }
            if (_mode.equals("1") || _mode.equals("2")) {
                while (_level.length() == 0) {
                    System.out.print("access level: ");
                    _level = _in.readLine();
                }
            }
        }
        if (_mode.equals("1")) {
            SQLAccountManager.AddOrUpdateAccount(_uname, _pass, _level);
        } else if (_mode.equals("2")) {
            SQLAccountManager.ChangeAccountLevel(_uname, _level);
        } else if (_mode.equals("3")) {
            System.out.print("Do you really want to delete this account ? Y/N : ");
            String yesno = _in.readLine();
            if (yesno.equals("Y")) {
                SQLAccountManager.DeleteAccount(_uname);
            }
        } else if (_mode.equals("4")) {
            SQLAccountManager.printAccInfo();
        }
        System.out.println("Brought to you by l2jRU dev team ;)");
        System.out.println("Have fun playing lineage2");
    }

    private static void printAccInfo() throws IOException, SQLException {
        int count = 0;
        Connection con = null;
        con = L2DatabaseFactory.getInstance().getConnection();
        PreparedStatement statement = con.prepareStatement("SELECT login, access_level FROM accounts ORDER BY login ASC");
        ResultSet rset = statement.executeQuery();
        while (rset.next()) {
            System.out.println(rset.getString("login") + " -> " + rset.getInt("access_level"));
            ++count;
        }
        rset.close();
        statement.close();
        System.out.println("Number of accounts: " + count);
    }

    private static void AddOrUpdateAccount(String account, String password, String level) throws IOException, SQLException, NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA");
        byte[] newpass = password.getBytes("UTF-8");
        newpass = md.digest(newpass);
        Connection con = null;
        con = L2DatabaseFactory.getInstance().getConnection();
        PreparedStatement statement = con.prepareStatement("REPLACE\taccounts (login, password, access_level) VALUES (?,?,?)");
        statement.setString(1, account);
        statement.setString(2, Base64.encodeBytes(newpass));
        statement.setString(3, level);
        statement.executeUpdate();
        statement.close();
    }

    private static void ChangeAccountLevel(String account, String level) throws IOException, SQLException {
        Connection con = null;
        con = L2DatabaseFactory.getInstance().getConnection();
        PreparedStatement statement = con.prepareStatement("SELECT COUNT(*) FROM accounts WHERE login=?;");
        statement.setString(1, account);
        ResultSet rset = statement.executeQuery();
        if (!rset.next()) {
            System.out.println("False");
        } else if (rset.getInt(1) > 0) {
            statement = con.prepareStatement("UPDATE accounts SET access_level=? WHERE login=?;");
            statement.setEscapeProcessing(true);
            statement.setString(1, level);
            statement.setString(2, account);
            statement.executeUpdate();
            System.out.println("Account \"" + account + "\" Updated\n");
        } else {
            System.out.println("Account \"" + account + "\" Not Exist\n");
        }
        rset.close();
        statement.close();
    }

    private static void DeleteAccount(String account) throws SQLException {
        Connection con = null;
        con = L2DatabaseFactory.getInstance().getConnection();
        PreparedStatement statement = con.prepareStatement("SELECT COUNT(*) FROM accounts WHERE login=?;");
        statement.setString(1, account);
        ResultSet rset = statement.executeQuery();
        if (!rset.next()) {
            System.out.println("False");
            rset.close();
        } else if (rset.getInt(1) > 0) {
            rset.close();
            statement = con.prepareStatement("SELECT obj_Id, char_name, clanid FROM characters WHERE account_name=?;");
            statement.setEscapeProcessing(true);
            statement.setString(1, account);
            rset = statement.executeQuery();
            while (rset.next()) {
                System.out.println("Deleting character \"" + rset.getString("char_name") + "\"\n");
                statement = con.prepareStatement("SELECT COUNT(*) FROM clan_data WHERE leader_id=?;");
                statement.setString(1, rset.getString("clanid"));
                ResultSet rcln = statement.executeQuery();
                rcln.next();
                if (rcln.getInt(1) > 0) {
                    rcln.close();
                    statement = con.prepareStatement("SELECT clan_name FROM clan_data WHERE leader_id=?;");
                    statement.setString(1, rset.getString("clanid"));
                    rcln = statement.executeQuery();
                    rcln.next();
                    System.out.println("Deleting clan \"" + rcln.getString("clan_name") + "\"\n");
                    statement = con.prepareStatement("DELETE FROM clan_wars WHERE clan1=? OR clan2=?;");
                    statement.setEscapeProcessing(true);
                    statement.setString(1, rcln.getString("clan_name"));
                    statement.setString(2, rcln.getString("clan_name"));
                    statement.executeUpdate();
                    rcln.close();
                    statement = con.prepareStatement("UPDATE characters SET clanid=0 WHERE clanid=?;");
                    statement.setString(1, rset.getString("clanid"));
                    statement.executeUpdate();
                    statement = con.prepareStatement("DELETE FROM clan_data WHERE clan_id=?;");
                    statement.setString(1, rset.getString("clanid"));
                    statement.executeUpdate();
                } else {
                    rcln.close();
                }
                statement = con.prepareStatement("DELETE FROM character_skills WHERE char_obj_id=?;");
                statement.setString(1, rset.getString("obj_Id"));
                statement.executeUpdate();
                statement = con.prepareStatement("DELETE FROM character_shortcuts WHERE char_obj_id=?;");
                statement.setString(1, rset.getString("obj_Id"));
                statement.executeUpdate();
                statement = con.prepareStatement("DELETE FROM items WHERE owner_id=?;");
                statement.setString(1, rset.getString("obj_Id"));
                statement.executeUpdate();
                statement = con.prepareStatement("DELETE FROM character_recipebook WHERE char_id=?;");
                statement.setString(1, rset.getString("obj_Id"));
                statement.executeUpdate();
                statement = con.prepareStatement("DELETE FROM character_quests WHERE char_id=?;");
                statement.setString(1, rset.getString("obj_Id"));
                statement.executeUpdate();
                statement = con.prepareStatement("DELETE FROM character_macroses WHERE char_obj_id=?;");
                statement.setString(1, rset.getString("obj_Id"));
                statement.executeUpdate();
                statement = con.prepareStatement("DELETE FROM character_friends WHERE char_id=?;");
                statement.setString(1, rset.getString("obj_Id"));
                statement.executeUpdate();
                statement = con.prepareStatement("DELETE FROM merchant_lease WHERE player_id=?;");
                statement.setString(1, rset.getString("obj_Id"));
                statement.executeUpdate();
                statement = con.prepareStatement("DELETE FROM boxaccess WHERE charname=?;");
                statement.setString(1, rset.getString("char_name"));
                statement.executeUpdate();
                statement = con.prepareStatement("DELETE FROM characters WHERE obj_Id=?;");
                statement.setString(1, rset.getString("obj_Id"));
                statement.executeUpdate();
            }
            statement = con.prepareStatement("DELETE FROM accounts WHERE login=?;");
            statement.setEscapeProcessing(true);
            statement.setString(1, account);
            statement.executeUpdate();
            System.out.println("Account \"" + account + "\" Deleted\n\n");
        } else {
            System.out.println("Account \"" + account + "\" Not Exist\n");
        }
        statement.close();
    }
}

