/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.L2World;
import net.sf.l2j.gameserver.script.DateRange;
import net.sf.l2j.gameserver.serverpackets.CreatureSay;
import net.sf.l2j.gameserver.serverpackets.NpcHtmlMessage;
import net.sf.l2j.gameserver.serverpackets.SystemMessage;

public class Announcements {
    private static Logger _log = Logger.getLogger(Announcements.class.getName());
    private static Announcements _instance;
    private ArrayList<String> _announcements = new ArrayList();
    private ArrayList<ArrayList<Object>> eventAnnouncements = new ArrayList();

    public Announcements() {
        this.loadAnnouncements();
    }

    public static Announcements getInstance() {
        if (_instance == null) {
            _instance = new Announcements();
        }
        return _instance;
    }

    public void loadAnnouncements() {
        this._announcements.clear();
        File file = new File(Config.DATAPACK_ROOT, "data/announcements.txt");
        if (file.exists()) {
            this.readFromDisk(file);
        } else {
            _log.config("data/announcements.txt doesn't exist");
        }
    }

    public void showAnnouncements(L2PcInstance activeChar) {
        int i;
        for (i = 0; i < this._announcements.size(); ++i) {
            CreatureSay cs = new CreatureSay(0, 10, activeChar.getName(), this._announcements.get(i).toString());
            activeChar.sendPacket(cs);
        }
        for (i = 0; i < this.eventAnnouncements.size(); ++i) {
            ArrayList<Object> entry = this.eventAnnouncements.get(i);
            DateRange validDateRange = (DateRange)entry.get(0);
            String[] msg = (String[])entry.get(1);
            Date currentDate = new Date();
            if (validDateRange.isValid() && !validDateRange.isWithinRange(currentDate)) continue;
            SystemMessage sm = new SystemMessage(614);
            for (int j = 0; j < msg.length; ++j) {
                sm.addString(msg[j]);
            }
            activeChar.sendPacket(sm);
        }
    }

    public void addEventAnnouncement(DateRange validDateRange, String[] msg) {
        ArrayList<Object> entry = new ArrayList<Object>();
        entry.add(validDateRange);
        entry.add(msg);
        this.eventAnnouncements.add(entry);
    }

    public void listAnnouncements(L2PcInstance activeChar) {
        NpcHtmlMessage adminReply = new NpcHtmlMessage(5);
        StringBuffer replyMSG = new StringBuffer("<html><body>");
        replyMSG.append("<table width=260><tr>");
        replyMSG.append("<td width=40><button value=\"Main\" action=\"bypass -h admin_admin\" width=40 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\"></td>");
        replyMSG.append("<td width=180><center>Announcement Menu</center></td>");
        replyMSG.append("<td width=40><button value=\"Back\" action=\"bypass -h admin_admin\" width=40 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\"></td>");
        replyMSG.append("</tr></table>");
        replyMSG.append("<br><br>");
        replyMSG.append("<center>Add or announce a new announcement:</center>");
        replyMSG.append("<center><multiedit var=\"new_announcement\" width=240 height=30></center><br>");
        replyMSG.append("<center><table><tr><td>");
        replyMSG.append("<button value=\"Add\" action=\"bypass -h admin_add_announcement $new_announcement\" width=60 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\"></td><td>");
        replyMSG.append("<button value=\"Announce\" action=\"bypass -h admin_announce_menu $new_announcement\" width=60 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\"></td><td>");
        replyMSG.append("<button value=\"Reload\" action=\"bypass -h admin_announce_announcements\" width=60 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\">");
        replyMSG.append("</td></tr></table></center>");
        replyMSG.append("<br>");
        for (int i = 0; i < this._announcements.size(); ++i) {
            replyMSG.append("<table width=260><tr><td width=220>" + this._announcements.get(i).toString() + "</td><td width=40>");
            replyMSG.append("<button value=\"Delete\" action=\"bypass -h admin_del_announcement " + i + "\" width=60 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\"></td></tr></table>");
        }
        replyMSG.append("</body></html>");
        adminReply.setHtml(replyMSG.toString());
        activeChar.sendPacket(adminReply);
    }

    public void addAnnouncement(String text) {
        this._announcements.add(text);
        this.saveToDisk();
    }

    public void delAnnouncement(int line) {
        this._announcements.remove(line);
        this.saveToDisk();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readFromDisk(File file) {
        BufferedReader lnr = null;
        try {
            int i = 0;
            String line = null;
            lnr = new LineNumberReader(new FileReader(file));
            while ((line = ((LineNumberReader)lnr).readLine()) != null) {
                StringTokenizer st = new StringTokenizer(line, "\n\r");
                if (!st.hasMoreTokens()) continue;
                String announcement = st.nextToken();
                this._announcements.add(announcement);
                ++i;
            }
            _log.config("Announcements: Loaded " + i + " Announcements.");
        }
        catch (IOException e1) {
            _log.log(Level.SEVERE, "Error reading announcements", e1);
        }
        finally {
            try {
                lnr.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveToDisk() {
        File file = new File("data/announcements.txt");
        FileWriter save = null;
        try {
            save = new FileWriter(file);
            for (int i = 0; i < this._announcements.size(); ++i) {
                save.write(this._announcements.get(i).toString());
                save.write("\r\n");
            }
        }
        catch (IOException e) {
            _log.warning("saving the announcements file has failed: " + e);
        }
        finally {
            try {
                save.close();
            }
            catch (Exception exception) {}
        }
    }

    public void announceToAll(String text) {
        CreatureSay cs = new CreatureSay(0, 10, "", text);
        for (L2PcInstance player : L2World.getInstance().getAllPlayers()) {
            player.sendPacket(cs);
        }
    }

    public void handleAnnounce(String command, L2PcInstance activeChar, int lengthToTrim) {
        try {
            String text = command.substring(lengthToTrim);
            Announcements.getInstance().announceToAll(text);
        }
        catch (StringIndexOutOfBoundsException e) {
            // empty catch block
        }
    }
}

