/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver;

import java.nio.ByteBuffer;
import net.sf.l2j.gameserver.BasePacketQueue;
import net.sf.l2j.gameserver.ClientThread;
import net.sf.l2j.gameserver.Connection;

public abstract class BasePacket
implements Cloneable {
    Connection _connection;
    ClientThread _client;
    BasePacket _prev;
    BasePacket _next;
    BasePacketQueue _queue;
    protected ByteBuffer _buf;

    protected BasePacket() {
    }

    protected BasePacket(Connection con) {
        this._connection = con;
        this._client = con.getClient();
    }

    protected BasePacket(ClientThread client) {
        this._connection = client.getConnection();
        this._client = client;
    }

    public BasePacket setConnection(Connection con) {
        if (this._connection == null) {
            this._connection = con;
            this._client = this._connection.getClient();
            return this;
        }
        return this.duplicate(con);
    }

    public final Connection getConnection() {
        return this._connection;
    }

    public final ClientThread getClient() {
        return this._client;
    }

    public BasePacket duplicate(Connection con) {
        try {
            BasePacket bp = (BasePacket)super.clone();
            bp._connection = con;
            bp._client = con.getClient();
            bp._prev = null;
            bp._next = null;
            bp._queue = null;
            return bp;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public abstract String getType();
}

