/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.logging.Logger;
import net.sf.l2j.L2DatabaseFactory;
import net.sf.l2j.gameserver.model.ClassId;
import net.sf.l2j.gameserver.templates.L2PcTemplate;
import net.sf.l2j.gameserver.templates.StatsSet;

public class CharTemplateTable {
    private static Logger _log = Logger.getLogger(CharTemplateTable.class.getName());
    private static CharTemplateTable _instance;
    private HashMap<Integer, L2PcTemplate> _templates = new HashMap();

    public static CharTemplateTable getInstance() {
        if (_instance == null) {
            _instance = new CharTemplateTable();
        }
        return _instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CharTemplateTable() {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT * FROM class_list, char_templates, lvlupgain WHERE class_list.id = char_templates.classId AND class_list.id = lvlupgain.classId ORDER BY class_list.id");
            ResultSet rset = statement.executeQuery();
            while (rset.next()) {
                int x;
                StatsSet set2 = new StatsSet();
                ClassId classId = ClassId.values()[rset.getInt("class_list.id")];
                set2.set("classId", rset.getInt("class_list.id"));
                set2.set("className", rset.getString("char_templates.className"));
                set2.set("raceId", rset.getInt("char_templates.raceId"));
                set2.set("baseSTR", rset.getInt("char_templates.STR"));
                set2.set("baseCON", rset.getInt("char_templates.CON"));
                set2.set("baseDEX", rset.getInt("char_templates.DEX"));
                set2.set("baseINT", rset.getInt("char_templates._INT"));
                set2.set("baseWIT", rset.getInt("char_templates.WIT"));
                set2.set("baseMEN", rset.getInt("char_templates.MEN"));
                set2.set("baseHpMax", rset.getFloat("lvlupgain.defaultHpBase"));
                set2.set("lvlHpAdd", rset.getFloat("lvlupgain.defaultHpAdd"));
                set2.set("lvlHpMod", rset.getFloat("lvlupgain.defaultHpMod"));
                set2.set("baseMpMax", rset.getFloat("lvlupgain.defaultMpBase"));
                set2.set("lvlMpAdd", rset.getFloat("lvlupgain.defaultMpAdd"));
                set2.set("lvlMpMod", rset.getFloat("lvlupgain.defaultMpMod"));
                set2.set("baseHpReg", 0.01);
                set2.set("baseMpReg", 0.01);
                set2.set("basePAtk", rset.getInt("char_templates.p_atk"));
                set2.set("basePDef", rset.getInt("char_templates.p_def"));
                set2.set("baseMAtk", rset.getInt("char_templates.m_atk"));
                set2.set("baseMDef", 41);
                set2.set("classBaseLevel", rset.getInt("lvlupgain.class_lvl"));
                set2.set("basePAtkSpd", rset.getInt("char_templates.p_spd"));
                set2.set("baseMAtkSpd", classId.isMage() ? 166 : 333);
                set2.set("baseCritRate", 0);
                set2.set("baseRunSpd", rset.getInt("char_templates.move_spd"));
                set2.set("baseLoad", rset.getInt("char_templates._load"));
                set2.set("baseShldDef", 0);
                set2.set("baseShldRate", 0);
                set2.set("baseAtkRange", 40);
                set2.set("spawnX", rset.getInt("char_templates.x"));
                set2.set("spawnY", rset.getInt("char_templates.y"));
                set2.set("spawnZ", rset.getInt("char_templates.z"));
                set2.set("isMale", true);
                set2.set("collision_radius", rset.getDouble("char_templates.m_col_r"));
                set2.set("collision_height", rset.getDouble("char_templates.m_col_h"));
                L2PcTemplate ct = new L2PcTemplate(set2);
                for (x = 1; x < 6; ++x) {
                    if (rset.getInt(34 + x) == 0) continue;
                    ct.addItem(rset.getInt("char_templates.items" + x));
                }
                this._templates.put(ct.classId.getId(), ct);
                set2.set("isMale", false);
                set2.set("collision_radius", rset.getDouble("char_templates.f_col_r"));
                set2.set("collision_height", rset.getDouble("char_templates.f_col_h"));
                ct = new L2PcTemplate(set2);
                for (x = 1; x < 6; ++x) {
                    if (rset.getInt(34 + x) == 0) continue;
                    ct.addItem(rset.getInt("char_templates.items" + x));
                }
                this._templates.put(ct.classId.getId() | 0x100, ct);
            }
            rset.close();
            statement.close();
        }
        catch (SQLException e) {
            _log.warning("error while loading char templates " + e.getMessage());
        }
        finally {
            try {
                con.close();
            }
            catch (Exception exception) {}
        }
        _log.config("CharTemplateTable: Loaded " + this._templates.size() + " Character Templates.");
    }

    public L2PcTemplate getTemplate(ClassId classId, boolean female) {
        return this.getTemplate(classId.getId(), female);
    }

    public L2PcTemplate getTemplate(int classId, boolean female) {
        int key = classId;
        if (female) {
            key |= 0x100;
        }
        return this._templates.get(key);
    }
}

