/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver;

import java.net.Socket;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.concurrent.ScheduledFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.l2j.Config;
import net.sf.l2j.L2DatabaseFactory;
import net.sf.l2j.gameserver.ClientScheduler;
import net.sf.l2j.gameserver.Connection;
import net.sf.l2j.gameserver.RecipeController;
import net.sf.l2j.gameserver.model.CharSelectInfoPackage;
import net.sf.l2j.gameserver.model.L2Clan;
import net.sf.l2j.gameserver.model.L2MerchantInstance;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.L2RecipeList;
import net.sf.l2j.gameserver.model.L2World;
import net.sf.l2j.loginserver.LoginController;

public final class ClientThread {
    protected static Logger _log = Logger.getLogger(ClientThread.class.getName());
    public static int devCharId;
    private String _loginName;
    private L2PcInstance _activeChar;
    private int _sessionId = 305419896;
    private final Connection _connection;
    final ScheduledFuture _autoSaveInDB;
    private final byte[] _cryptkey = new byte[]{-108, 53, 0, 0, -95, 108, 84, -121};
    private int revision = 0;
    private ArrayList<Integer> _charSlotMapping = new ArrayList();

    public static ClientThread create(Socket socket) {
        ClientThread client = new ClientThread(socket);
        return client;
    }

    public ClientThread(Socket socket) {
        this._connection = new Connection(this, socket, this._cryptkey);
        this._autoSaveInDB = ClientScheduler.getInstance().scheduleLowAtFixedRate(new AutoSaveTask(), 300000L, 900000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onDisconnect() {
        try {
            this._autoSaveInDB.cancel(false);
            if (this._activeChar != null) {
                L2PcInstance player = this._activeChar;
                this._activeChar = null;
                player.deleteMe();
                try {
                    ClientThread.saveCharToDisk(player);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this._connection.close();
        }
        catch (Exception e1) {
            _log.log(Level.WARNING, "error while disconnecting client", e1);
        }
        finally {
            LoginController.getInstance().removeGameServerLogin(this.getLoginName());
        }
    }

    public static void saveCharToDisk(L2PcInstance cha) {
        cha.store();
        ClientThread.storeRecipeBook(cha);
    }

    public void deleteFromClan(L2PcInstance cha) {
        L2Clan clan = cha.getClan();
        if (clan != null) {
            clan.removeClanMember(cha.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteChar(int charslot) throws Exception {
        if (this.getActiveChar() != null) {
            ClientThread.saveCharToDisk(this.getActiveChar());
            if (Config.DEBUG) {
                _log.fine("active Char saved");
            }
            this._activeChar = null;
        }
        int objid = this.getObjectIdForSlot(charslot);
        L2PcInstance character = L2PcInstance.load(objid);
        this.deleteFromClan(character);
        java.sql.Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("DELETE FROM characters WHERE obj_Id=?");
            statement.setInt(1, objid);
            statement.execute();
            statement.close();
            statement = con.prepareStatement("DELETE FROM character_shortcuts WHERE char_obj_id=?");
            statement.setInt(1, objid);
            statement.execute();
            statement.close();
            statement = con.prepareStatement("DELETE FROM character_macroses WHERE char_obj_id=?");
            statement.setInt(1, objid);
            statement.execute();
            statement.close();
            statement = con.prepareStatement("DELETE FROM pets USING pets, items WHERE pets.item_obj_id=items.object_id AND items.owner_id=?");
            statement.setInt(1, objid);
            statement.execute();
            statement.close();
            statement = con.prepareStatement("DELETE FROM items WHERE owner_id=?");
            statement.setInt(1, objid);
            statement.execute();
            statement.close();
            statement = con.prepareStatement("DELETE FROM character_skills WHERE char_obj_Id=?");
            statement.setInt(1, objid);
            statement.execute();
            statement.close();
            statement = con.prepareStatement("DELETE FROM character_quests WHERE char_id=?");
            statement.setInt(1, objid);
            statement.execute();
            statement.close();
            statement = con.prepareStatement("DELETE FROM character_recipebook WHERE char_id=?");
            statement.setInt(1, objid);
            statement.execute();
            statement.close();
            statement = con.prepareStatement("DELETE FROM merchant_lease WHERE player_id=?");
            statement.setInt(1, objid);
            statement.execute();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "data error on delete char:", e);
        }
        finally {
            try {
                con.close();
            }
            catch (Exception e) {}
        }
    }

    public L2PcInstance loadCharFromDisk(int charslot) {
        L2PcInstance character = L2PcInstance.load(this.getObjectIdForSlot(charslot));
        if (Config.DEVELOPER && "test".equals(this.getLoginName())) {
            devCharId = character.getObjectId();
        }
        if (character != null) {
            ClientThread.restoreRecipeBook(character);
            L2MerchantInstance.playerEnter(character);
            character.setRunning();
            character.standUp();
            character.updateStats();
            character.updateKarma(1);
            character.setOnlineStatus(true);
        } else {
            _log.warning("could not restore in slot:" + charslot);
        }
        return character;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void storeRecipeBook(L2PcInstance cha) {
        java.sql.Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("DELETE FROM character_recipebook WHERE char_id=?");
            statement.setInt(1, cha.getObjectId());
            statement.execute();
            statement.close();
            L2RecipeList[] recipes = cha.getRecipeBook();
            for (int count = 0; count < recipes.length; ++count) {
                statement = con.prepareStatement("INSERT INTO character_recipebook (char_id, id) values(?,?)");
                statement.setInt(1, cha.getObjectId());
                statement.setInt(2, recipes[count].getId());
                statement.execute();
                statement.close();
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "could not store skills:", e);
        }
        finally {
            try {
                con.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void restoreRecipeBook(L2PcInstance cha) {
        java.sql.Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT id FROM character_recipebook WHERE char_id=?");
            statement.setInt(1, cha.getObjectId());
            ResultSet rset = statement.executeQuery();
            while (rset.next()) {
                int id = rset.getInt(1);
                L2RecipeList recipe = RecipeController.getInstance().getRecipeList(id - 1);
                cha.registerRecipeList(recipe);
            }
            rset.close();
            statement.close();
        }
        catch (Exception e) {
            _log.warning("count not restore skills:" + e);
        }
        finally {
            try {
                con.close();
            }
            catch (Exception exception) {}
        }
    }

    private int getObjectIdForSlot(int charslot) {
        Integer objectId = this._charSlotMapping.get(charslot);
        return objectId;
    }

    public Connection getConnection() {
        return this._connection;
    }

    public L2PcInstance getActiveChar() {
        return this._activeChar;
    }

    public int getSessionId() {
        return this._sessionId;
    }

    public String getLoginName() {
        return this._loginName;
    }

    public void setLoginName(String loginName) {
        this._loginName = loginName;
    }

    public void setActiveChar(L2PcInstance cha) {
        this._activeChar = cha;
        if (cha != null) {
            this._activeChar.setNetConnection(this._connection);
            L2World.getInstance().storeObject(this._activeChar);
        }
    }

    public void setSessionId(int sessionKey) {
        this._sessionId = sessionKey;
    }

    public void setCharSelection(CharSelectInfoPackage[] chars) {
        this._charSlotMapping.clear();
        for (int i = 0; i < chars.length; ++i) {
            int objectId = chars[i].getObjectId();
            this._charSlotMapping.add(new Integer(objectId));
        }
    }

    public int getRevision() {
        return this.revision;
    }

    public void setRevision(int revision) {
        this.revision = revision;
    }

    class AutoSaveTask
    implements Runnable {
        AutoSaveTask() {
        }

        public void run() {
            try {
                L2PcInstance player = ClientThread.this.getActiveChar();
                if (player != null) {
                    ClientThread.saveCharToDisk(player);
                } else if (ClientThread.this.getConnection() == null || !ClientThread.this.getConnection().getChannel().isOpen()) {
                    ClientThread.this._autoSaveInDB.cancel(false);
                }
            }
            catch (Throwable e) {
                _log.severe(e.toString());
            }
        }
    }
}

