/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver;

import java.nio.ByteBuffer;
import net.sf.l2j.Config;

public class Crypt {
    private final byte[] _key = new byte[8];
    private boolean enabled;

    public void setKey(byte[] key) {
        if (Config.ASSERT) assert (key != null && key.length == 8);
        System.arraycopy(key, 0, this._key, 0, 8);
        this.enabled = true;
    }

    public void decrypt(ByteBuffer buf) {
        if (!this.enabled) {
            return;
        }
        if (Config.ASSERT) assert (buf.position() == 0);
        int sz = buf.remaining();
        int temp = 0;
        for (int i = 0; i < sz; ++i) {
            byte temp2 = buf.get(i);
            buf.put(i, (byte)(temp2 ^ this._key[i & 7] ^ temp));
            temp = temp2;
        }
        int old = this._key[0] & 0xFF;
        old |= this._key[1] << 8 & 0xFF00;
        old |= this._key[2] << 16 & 0xFF0000;
        old |= this._key[3] << 24 & 0xFF000000;
        this._key[0] = (byte)((old += sz) & 0xFF);
        this._key[1] = (byte)(old >> 8 & 0xFF);
        this._key[2] = (byte)(old >> 16 & 0xFF);
        this._key[3] = (byte)(old >> 24 & 0xFF);
    }

    public void encrypt(ByteBuffer buf) {
        if (!this.enabled) {
            return;
        }
        int temp = 0;
        int sz = buf.remaining();
        for (int i = 0; i < sz; ++i) {
            byte temp2 = buf.get(i);
            temp = temp2 ^ this._key[i & 7] ^ temp;
            buf.put(i, (byte)temp);
        }
        int old = this._key[0] & 0xFF;
        old |= this._key[1] << 8 & 0xFF00;
        old |= this._key[2] << 16 & 0xFF0000;
        old |= this._key[3] << 24 & 0xFF000000;
        this._key[0] = (byte)((old += sz) & 0xFF);
        this._key[1] = (byte)(old >> 8 & 0xFF);
        this._key[2] = (byte)(old >> 16 & 0xFF);
        this._key[3] = (byte)(old >> 24 & 0xFF);
    }

    public void decrypt(byte[] raw) {
        if (!this.enabled) {
            return;
        }
        int temp = 0;
        for (int i = 0; i < raw.length; ++i) {
            int temp2 = raw[i] & 0xFF;
            raw[i] = (byte)(temp2 ^ this._key[i & 7] & 0xFF ^ temp);
            temp = temp2;
        }
        int old = this._key[0] & 0xFF;
        old |= this._key[1] << 8 & 0xFF00;
        old |= this._key[2] << 16 & 0xFF0000;
        old |= this._key[3] << 24 & 0xFF000000;
        this._key[0] = (byte)((old += raw.length) & 0xFF);
        this._key[1] = (byte)(old >> 8 & 0xFF);
        this._key[2] = (byte)(old >> 16 & 0xFF);
        this._key[3] = (byte)(old >> 24 & 0xFF);
    }

    public void encrypt(byte[] raw) {
        if (!this.enabled) {
            return;
        }
        int temp = 0;
        for (int i = 0; i < raw.length; ++i) {
            int temp2 = raw[i] & 0xFF;
            raw[i] = (byte)(temp2 ^ this._key[i & 7] & 0xFF ^ temp);
            temp = raw[i];
        }
        int old = this._key[0] & 0xFF;
        old |= this._key[1] << 8 & 0xFF00;
        old |= this._key[2] << 16 & 0xFF0000;
        old |= this._key[3] << 24 & 0xFF000000;
        this._key[0] = (byte)((old += raw.length) & 0xFF);
        this._key[1] = (byte)(old >> 8 & 0xFF);
        this._key[2] = (byte)(old >> 16 & 0xFF);
        this._key[3] = (byte)(old >> 24 & 0xFF);
    }
}

