/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver;

import java.util.ArrayList;
import java.util.Date;
import java.util.logging.Logger;
import net.sf.l2j.gameserver.script.DateRange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventDroplist {
    private static Logger _log = Logger.getLogger(EventDroplist.class.getName());
    private static EventDroplist _instance;
    private ArrayList<DateDrop> allNpcDateDrops = new ArrayList();

    public static EventDroplist getInstance() {
        if (_instance == null) {
            _instance = new EventDroplist();
        }
        return _instance;
    }

    private EventDroplist() {
    }

    public void addGlobalDrop(int[] items, int[] count, int chance, DateRange range) {
        DateDrop date = new DateDrop();
        date.dateRange = range;
        date.items = items;
        date.min = count[0];
        date.max = count[1];
        date.chance = chance;
        this.allNpcDateDrops.add(date);
    }

    public ArrayList<DateDrop> getAllDrops() {
        ArrayList<DateDrop> list = new ArrayList<DateDrop>();
        for (DateDrop drop2 : this.allNpcDateDrops) {
            Date currentDate = new Date();
            if (!drop2.dateRange.isWithinRange(currentDate)) continue;
            list.add(drop2);
        }
        return list;
    }

    public class DateDrop {
        DateRange dateRange;
        public int[] items;
        public int min;
        public int max;
        public int chance;
    }
}

