/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver;

import java.io.File;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Logger;
import net.sf.l2j.Config;
import net.sf.l2j.Server;
import net.sf.l2j.gameserver.Announcements;
import net.sf.l2j.gameserver.CastleGuardsSpawner;
import net.sf.l2j.gameserver.CharNameTable;
import net.sf.l2j.gameserver.CharTemplateTable;
import net.sf.l2j.gameserver.ClanTable;
import net.sf.l2j.gameserver.ClientScheduler;
import net.sf.l2j.gameserver.DoorTable;
import net.sf.l2j.gameserver.EventDroplist;
import net.sf.l2j.gameserver.GameTimeController;
import net.sf.l2j.gameserver.GmListTable;
import net.sf.l2j.gameserver.HennaTable;
import net.sf.l2j.gameserver.HennaTreeTable;
import net.sf.l2j.gameserver.IdFactory;
import net.sf.l2j.gameserver.ItemTable;
import net.sf.l2j.gameserver.LevelUpData;
import net.sf.l2j.gameserver.MapRegionTable;
import net.sf.l2j.gameserver.MonsterRace;
import net.sf.l2j.gameserver.NpcTable;
import net.sf.l2j.gameserver.RecipeController;
import net.sf.l2j.gameserver.SelectorThread;
import net.sf.l2j.gameserver.Shutdown;
import net.sf.l2j.gameserver.SkillSpellbookTable;
import net.sf.l2j.gameserver.SkillTable;
import net.sf.l2j.gameserver.SkillTreeTable;
import net.sf.l2j.gameserver.SpawnTable;
import net.sf.l2j.gameserver.TeleportLocationTable;
import net.sf.l2j.gameserver.TradeController;
import net.sf.l2j.gameserver.Universe;
import net.sf.l2j.gameserver.handler.AdminCommandHandler;
import net.sf.l2j.gameserver.handler.ItemHandler;
import net.sf.l2j.gameserver.handler.SkillHandler;
import net.sf.l2j.gameserver.handler.UserCommandHandler;
import net.sf.l2j.gameserver.handler.VoicedCommandHandler;
import net.sf.l2j.gameserver.handler.admincommandhandlers.AdminAdmin;
import net.sf.l2j.gameserver.handler.admincommandhandlers.AdminAnnouncements;
import net.sf.l2j.gameserver.handler.admincommandhandlers.AdminBan;
import net.sf.l2j.gameserver.handler.admincommandhandlers.AdminBanChat;
import net.sf.l2j.gameserver.handler.admincommandhandlers.AdminChangeAccessLevel;
import net.sf.l2j.gameserver.handler.admincommandhandlers.AdminCreateItem;
import net.sf.l2j.gameserver.handler.admincommandhandlers.AdminDelete;
import net.sf.l2j.gameserver.handler.admincommandhandlers.AdminDoorControl;
import net.sf.l2j.gameserver.handler.admincommandhandlers.AdminEditChar;
import net.sf.l2j.gameserver.handler.admincommandhandlers.AdminEditNpc;
import net.sf.l2j.gameserver.handler.admincommandhandlers.AdminEffects;
import net.sf.l2j.gameserver.handler.admincommandhandlers.AdminExpSp;
import net.sf.l2j.gameserver.handler.admincommandhandlers.AdminFightCalculator;
import net.sf.l2j.gameserver.handler.admincommandhandlers.AdminForth;
import net.sf.l2j.gameserver.handler.admincommandhandlers.AdminGm;
import net.sf.l2j.gameserver.handler.admincommandhandlers.AdminGmChat;
import net.sf.l2j.gameserver.handler.admincommandhandlers.AdminHelpPage;
import net.sf.l2j.gameserver.handler.admincommandhandlers.AdminInvul;
import net.sf.l2j.gameserver.handler.admincommandhandlers.AdminKick;
import net.sf.l2j.gameserver.handler.admincommandhandlers.AdminKill;
import net.sf.l2j.gameserver.handler.admincommandhandlers.AdminMenu;
import net.sf.l2j.gameserver.handler.admincommandhandlers.AdminMobGroup;
import net.sf.l2j.gameserver.handler.admincommandhandlers.AdminMonsterRace;
import net.sf.l2j.gameserver.handler.admincommandhandlers.AdminPathNode;
import net.sf.l2j.gameserver.handler.admincommandhandlers.AdminPolymorph;
import net.sf.l2j.gameserver.handler.admincommandhandlers.AdminRepairChar;
import net.sf.l2j.gameserver.handler.admincommandhandlers.AdminRideWyvern;
import net.sf.l2j.gameserver.handler.admincommandhandlers.AdminSeige;
import net.sf.l2j.gameserver.handler.admincommandhandlers.AdminShop;
import net.sf.l2j.gameserver.handler.admincommandhandlers.AdminShutdown;
import net.sf.l2j.gameserver.handler.admincommandhandlers.AdminSkill;
import net.sf.l2j.gameserver.handler.admincommandhandlers.AdminSpawn;
import net.sf.l2j.gameserver.handler.admincommandhandlers.AdminTarget;
import net.sf.l2j.gameserver.handler.admincommandhandlers.AdminTeleport;
import net.sf.l2j.gameserver.handler.admincommandhandlers.AdminTest;
import net.sf.l2j.gameserver.handler.itemhandlers.BlessedSpiritShot;
import net.sf.l2j.gameserver.handler.itemhandlers.CompBlessedSpiritShotPacks;
import net.sf.l2j.gameserver.handler.itemhandlers.CompSoulShotPacks;
import net.sf.l2j.gameserver.handler.itemhandlers.CompSpiritShotPacks;
import net.sf.l2j.gameserver.handler.itemhandlers.CrystalCarol;
import net.sf.l2j.gameserver.handler.itemhandlers.EnchantScrolls;
import net.sf.l2j.gameserver.handler.itemhandlers.Guide;
import net.sf.l2j.gameserver.handler.itemhandlers.MysteryPotion;
import net.sf.l2j.gameserver.handler.itemhandlers.PetSummon;
import net.sf.l2j.gameserver.handler.itemhandlers.Potions;
import net.sf.l2j.gameserver.handler.itemhandlers.Recipes;
import net.sf.l2j.gameserver.handler.itemhandlers.Remedy;
import net.sf.l2j.gameserver.handler.itemhandlers.RollingDice;
import net.sf.l2j.gameserver.handler.itemhandlers.ScrollOfEscape;
import net.sf.l2j.gameserver.handler.itemhandlers.ScrollOfResurrection;
import net.sf.l2j.gameserver.handler.itemhandlers.Scrolls;
import net.sf.l2j.gameserver.handler.itemhandlers.SoulShots;
import net.sf.l2j.gameserver.handler.itemhandlers.SpiritShot;
import net.sf.l2j.gameserver.handler.itemhandlers.WorldMap;
import net.sf.l2j.gameserver.handler.skillhandlers.Charge;
import net.sf.l2j.gameserver.handler.skillhandlers.Continuous;
import net.sf.l2j.gameserver.handler.skillhandlers.Disablers;
import net.sf.l2j.gameserver.handler.skillhandlers.Drain;
import net.sf.l2j.gameserver.handler.skillhandlers.Heal;
import net.sf.l2j.gameserver.handler.skillhandlers.ManaHeal;
import net.sf.l2j.gameserver.handler.skillhandlers.Mdam;
import net.sf.l2j.gameserver.handler.skillhandlers.Pdam;
import net.sf.l2j.gameserver.handler.skillhandlers.Recall;
import net.sf.l2j.gameserver.handler.skillhandlers.Resurrect;
import net.sf.l2j.gameserver.handler.skillhandlers.SiegeFlag;
import net.sf.l2j.gameserver.handler.skillhandlers.Spoil;
import net.sf.l2j.gameserver.handler.skillhandlers.Sweep;
import net.sf.l2j.gameserver.handler.skillhandlers.TakeCastle;
import net.sf.l2j.gameserver.handler.skillhandlers.Unlock;
import net.sf.l2j.gameserver.handler.usercommandhandlers.Escape;
import net.sf.l2j.gameserver.handler.usercommandhandlers.Loc;
import net.sf.l2j.gameserver.handler.usercommandhandlers.Time;
import net.sf.l2j.gameserver.handler.voicedcommandhandlers.kill;
import net.sf.l2j.gameserver.lib.JBForth;
import net.sf.l2j.gameserver.model.L2Siege;
import net.sf.l2j.gameserver.model.L2World;
import net.sf.l2j.gameserver.model.quest.Quest;
import net.sf.l2j.gameserver.script.ScriptEngine;
import net.sf.l2j.gameserver.script.faenor.FaenorScriptEngine;
import net.sf.l2j.loginserver.LoginController;

public class GameServer {
    static Logger _log = Logger.getLogger(GameServer.class.getName());
    private final SelectorThread _selectorThread;
    private final TradeController _tradeController;
    private final SkillTable _skillTable;
    private final SkillTreeTable _skillTreeTable;
    private final SkillSpellbookTable _skillSpellbookTable;
    private final ClanTable _clanTable;
    private final ItemTable _itemTable;
    private final NpcTable _npcTable;
    private final CastleGuardsSpawner _cgspawner;
    private final HennaTable _hennaTable;
    private final HennaTreeTable _hennaTreeTable;
    private final TeleportLocationTable _teleTable;
    private final LevelUpData _levelUpData;
    private final Universe _universe;
    private final L2World _world;
    private final CharTemplateTable _charTemplates;
    private final IdFactory _idFactory;
    private final LoginController _loginController;
    private final SpawnTable _spawnTable;
    private final CharNameTable _charNametable;
    private final GameTimeController _gameTimeController;
    private final Announcements _announcements;
    private final MapRegionTable _mapRegions;
    private final ItemHandler _itemHandler;
    private final SkillHandler _skillHandler;
    private final GmListTable _gmList;
    private final AdminCommandHandler _adminCommandHandler;
    private final Shutdown _shutdownHandler;
    private final RecipeController _recipeController;
    private final UserCommandHandler _userCommandHandler;
    private final VoicedCommandHandler _voicedCommandHandler;
    private final EventDroplist _eventDroplist;
    private final DoorTable _doorTable;
    private final ScriptEngine _scriptEngine;
    private static JBForth _jbf;
    private static boolean autoloot;
    private MonsterRace _monsterRace;

    public long getUsedMemoryMB() {
        return (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024L / 1024L;
    }

    public static boolean autoLootEnabled() {
        return autoloot;
    }

    public LoginController getLoginController() {
        return this._loginController;
    }

    public SelectorThread getSelectorThread() {
        return this._selectorThread;
    }

    public GameServer() throws Exception {
        Server.gameServer = this;
        _log.finest("used mem:" + this.getUsedMemoryMB() + "MB");
        if (Config.SERVER_VERSION != null) {
            _log.info("L2J Server Version:    " + Config.SERVER_VERSION);
            _log.info("L2J Server Build Date: " + Config.SERVER_BUILD_DATE);
        }
        Properties serverSettings = new Properties();
        InputStream is = this.getClass().getResourceAsStream("/config/server.properties");
        serverSettings.load(is);
        is.close();
        this._idFactory = IdFactory.getInstance();
        if (!this._idFactory.isInitialized()) {
            _log.severe("Could not read object IDs from DB. Please Check Your Data.");
            throw new Exception("Could not initialize the ID factory");
        }
        autoloot = "true".equalsIgnoreCase(serverSettings.getProperty("AutoLoot"));
        String hostname = serverSettings.getProperty("GameserverHostname");
        int port = Integer.parseInt(serverSettings.getProperty("GameserverPort", "7777"));
        ClientScheduler.getInstance();
        this._selectorThread = new SelectorThread(hostname, port);
        this._selectorThread.start();
        String maxPlayerStr = serverSettings.getProperty("MaximumOnlineUsers");
        int maxPlayers = Integer.parseInt(maxPlayerStr);
        _log.config("Maximum Numbers of Connected Players: " + maxPlayers);
        new File(Config.DATAPACK_ROOT, "data/clans").mkdirs();
        new File(Config.DATAPACK_ROOT, "data/crests").mkdirs();
        new File("pathnode").mkdirs();
        this._gameTimeController = GameTimeController.getInstance();
        this._loginController = LoginController.getInstance();
        this._loginController.setMaxAllowedOnlinePlayers(maxPlayers);
        this._charNametable = CharNameTable.getInstance();
        _jbf = new JBForth();
        this._itemTable = ItemTable.getInstance();
        if (!this._itemTable.isInitialized()) {
            _log.severe("Could not find the extraced files. Please Check Your Data.");
            throw new Exception("Could not initialize the item table");
        }
        this._tradeController = TradeController.getInstance();
        this._skillTable = SkillTable.getInstance();
        if (!this._skillTable.isInitialized()) {
            _log.severe("Could not find the extraced files. Please Check Your Data.");
            throw new Exception("Could not initialize the skill table");
        }
        this._recipeController = RecipeController.getInstance();
        this._skillTreeTable = SkillTreeTable.getInstance();
        this._skillSpellbookTable = SkillSpellbookTable.getInstance();
        this._charTemplates = CharTemplateTable.getInstance();
        this._clanTable = ClanTable.getInstance();
        this._cgspawner = CastleGuardsSpawner.getInstance();
        this._npcTable = NpcTable.getInstance();
        if (!this._npcTable.isInitialized()) {
            _log.severe("Could not find the extraced files. Please Check Your Data.");
            throw new Exception("Could not initialize the npc table");
        }
        this._hennaTable = HennaTable.getInstance();
        if (!this._hennaTable.isInitialized()) {
            throw new Exception("Could not initialize the Henna Table");
        }
        this._hennaTreeTable = HennaTreeTable.getInstance();
        if (!this._hennaTable.isInitialized()) {
            throw new Exception("Could not initialize the Henna Tree Table");
        }
        this._teleTable = TeleportLocationTable.getInstance();
        this._levelUpData = LevelUpData.getInstance();
        this._world = L2World.getInstance();
        this._spawnTable = SpawnTable.getInstance();
        this._announcements = Announcements.getInstance();
        this._mapRegions = MapRegionTable.getInstance();
        this._eventDroplist = EventDroplist.getInstance();
        this._monsterRace = MonsterRace.getInstance();
        this._doorTable = DoorTable.getInstance();
        this._itemHandler = ItemHandler.getInstance();
        this._itemHandler.registerItemHandler(new PetSummon());
        this._itemHandler.registerItemHandler(new ScrollOfEscape());
        this._itemHandler.registerItemHandler(new ScrollOfResurrection());
        this._itemHandler.registerItemHandler(new SoulShots());
        this._itemHandler.registerItemHandler(new SpiritShot());
        this._itemHandler.registerItemHandler(new BlessedSpiritShot());
        this._itemHandler.registerItemHandler(new WorldMap());
        this._itemHandler.registerItemHandler(new Potions());
        this._itemHandler.registerItemHandler(new Recipes());
        this._itemHandler.registerItemHandler(new CompSoulShotPacks());
        this._itemHandler.registerItemHandler(new CompSpiritShotPacks());
        this._itemHandler.registerItemHandler(new CompBlessedSpiritShotPacks());
        this._itemHandler.registerItemHandler(new RollingDice());
        this._itemHandler.registerItemHandler(new MysteryPotion());
        this._itemHandler.registerItemHandler(new EnchantScrolls());
        this._itemHandler.registerItemHandler(new Remedy());
        this._itemHandler.registerItemHandler(new Guide());
        this._itemHandler.registerItemHandler(new Scrolls());
        this._itemHandler.registerItemHandler(new CrystalCarol());
        _log.config("ItemHandler: Loaded " + this._itemHandler.size() + " handlers.");
        this._skillHandler = SkillHandler.getInstance();
        this._skillHandler.registerSkillHandler(new Pdam());
        this._skillHandler.registerSkillHandler(new Mdam());
        this._skillHandler.registerSkillHandler(new Heal());
        this._skillHandler.registerSkillHandler(new ManaHeal());
        this._skillHandler.registerSkillHandler(new Charge());
        this._skillHandler.registerSkillHandler(new Continuous());
        this._skillHandler.registerSkillHandler(new Drain());
        this._skillHandler.registerSkillHandler(new Resurrect());
        this._skillHandler.registerSkillHandler(new Spoil());
        this._skillHandler.registerSkillHandler(new Sweep());
        this._skillHandler.registerSkillHandler(new Disablers());
        this._skillHandler.registerSkillHandler(new Recall());
        this._skillHandler.registerSkillHandler(new SiegeFlag());
        this._skillHandler.registerSkillHandler(new TakeCastle());
        this._skillHandler.registerSkillHandler(new Unlock());
        _log.config("SkillHandler: Loaded " + this._skillHandler.size() + " handlers.");
        this._adminCommandHandler = AdminCommandHandler.getInstance();
        this._adminCommandHandler.registerAdminCommandHandler(new AdminAdmin());
        this._adminCommandHandler.registerAdminCommandHandler(new AdminInvul());
        this._adminCommandHandler.registerAdminCommandHandler(new AdminDelete());
        this._adminCommandHandler.registerAdminCommandHandler(new AdminKill());
        this._adminCommandHandler.registerAdminCommandHandler(new AdminTarget());
        this._adminCommandHandler.registerAdminCommandHandler(new AdminShop());
        this._adminCommandHandler.registerAdminCommandHandler(new AdminAnnouncements());
        this._adminCommandHandler.registerAdminCommandHandler(new AdminCreateItem());
        this._adminCommandHandler.registerAdminCommandHandler(new AdminHelpPage());
        this._adminCommandHandler.registerAdminCommandHandler(new AdminShutdown());
        this._adminCommandHandler.registerAdminCommandHandler(new AdminSpawn());
        this._adminCommandHandler.registerAdminCommandHandler(new AdminSkill());
        this._adminCommandHandler.registerAdminCommandHandler(new AdminExpSp());
        this._adminCommandHandler.registerAdminCommandHandler(new AdminGmChat());
        this._adminCommandHandler.registerAdminCommandHandler(new AdminEditChar());
        this._adminCommandHandler.registerAdminCommandHandler(new AdminGm());
        this._adminCommandHandler.registerAdminCommandHandler(new AdminTeleport());
        this._adminCommandHandler.registerAdminCommandHandler(new AdminRepairChar());
        this._adminCommandHandler.registerAdminCommandHandler(new AdminChangeAccessLevel());
        this._adminCommandHandler.registerAdminCommandHandler(new AdminRideWyvern());
        this._adminCommandHandler.registerAdminCommandHandler(new AdminBan());
        this._adminCommandHandler.registerAdminCommandHandler(new AdminPolymorph());
        this._adminCommandHandler.registerAdminCommandHandler(new AdminBanChat());
        this._adminCommandHandler.registerAdminCommandHandler(new AdminKick());
        this._adminCommandHandler.registerAdminCommandHandler(new AdminMonsterRace());
        this._adminCommandHandler.registerAdminCommandHandler(new AdminEditNpc());
        this._adminCommandHandler.registerAdminCommandHandler(new AdminFightCalculator());
        this._adminCommandHandler.registerAdminCommandHandler(new AdminForth());
        this._adminCommandHandler.registerAdminCommandHandler(new AdminMenu());
        this._adminCommandHandler.registerAdminCommandHandler(new AdminSeige());
        this._adminCommandHandler.registerAdminCommandHandler(new AdminPathNode());
        this._adminCommandHandler.registerAdminCommandHandler(new AdminEffects());
        this._adminCommandHandler.registerAdminCommandHandler(new AdminDoorControl());
        this._adminCommandHandler.registerAdminCommandHandler(new AdminTest());
        this._adminCommandHandler.registerAdminCommandHandler(new AdminMobGroup());
        _log.config("AdminCommandHandler: Loaded " + this._adminCommandHandler.size() + " handlers.");
        this._userCommandHandler = UserCommandHandler.getInstance();
        this._userCommandHandler.registerUserCommandHandler(new Loc());
        this._userCommandHandler.registerUserCommandHandler(new Escape());
        this._userCommandHandler.registerUserCommandHandler(new Time());
        _log.config("UserCommandHandler: Loaded " + this._userCommandHandler.size() + " handlers.");
        this._voicedCommandHandler = VoicedCommandHandler.getInstance();
        this._voicedCommandHandler.registerVoicedCommandHandler(new kill());
        _log.config("VoicedCommandHandler: Loaded " + this._voicedCommandHandler.size() + " handlers.");
        this._gmList = GmListTable.getInstance();
        this._scriptEngine = new FaenorScriptEngine();
        this._universe = Universe.getInstance();
        Quest.init();
        this._clanTable.initClans();
        L2Siege.loadSiegeData();
        this._shutdownHandler = Shutdown.getInstance();
        Runtime.getRuntime().addShutdownHook(this._shutdownHandler);
        try {
            this._doorTable.getDoor(24190001).openMe();
            this._doorTable.getDoor(24190002).openMe();
            this._doorTable.getDoor(24190003).openMe();
            this._doorTable.getDoor(24190004).openMe();
            this._doorTable.getDoor(23180001).openMe();
            this._doorTable.getDoor(23180002).openMe();
            this._doorTable.getDoor(23180003).openMe();
            this._doorTable.getDoor(23180004).openMe();
            this._doorTable.getDoor(23180005).openMe();
            this._doorTable.getDoor(23180006).openMe();
        }
        catch (NullPointerException e) {
            _log.warning("Door.csv does not contain the right door info. Update door.csv");
            e.printStackTrace();
        }
        _log.config("IdFactory: Free ObjctId's remaining: " + IdFactory.getInstance().size());
        _jbf.exec("on-server-start");
        System.gc();
        long freeMem = (Runtime.getRuntime().maxMemory() - Runtime.getRuntime().totalMemory() + Runtime.getRuntime().freeMemory()) / 1024L / 1024L;
        long totalMem = Runtime.getRuntime().maxMemory() / 1024L / 1024L;
        _log.info("GameServer Started, free memory " + freeMem + " Mb of " + totalMem + " Mb");
    }

    static {
        autoloot = false;
    }
}

