/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver;

import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.serverpackets.ServerBasePacket;
import net.sf.l2j.gameserver.serverpackets.SystemMessage;

public class GmListTable {
    private static Logger _log = Logger.getLogger(GmListTable.class.getName());
    private static GmListTable _instance;
    private Set<L2PcInstance> _gmList = new HashSet<L2PcInstance>();

    public static GmListTable getInstance() {
        if (_instance == null) {
            _instance = new GmListTable();
        }
        return _instance;
    }

    public L2PcInstance[] getAllGms() {
        return this._gmList.toArray(new L2PcInstance[this._gmList.size()]);
    }

    private GmListTable() {
    }

    public void addGm(L2PcInstance player) {
        if (Config.DEBUG) {
            _log.fine("added gm: " + player.getName());
        }
        this._gmList.add(player);
    }

    public void deleteGm(L2PcInstance player) {
        if (Config.DEBUG) {
            _log.fine("deleted gm: " + player.getName());
        }
        this._gmList.remove(player);
    }

    public void sendListToPlayer(L2PcInstance player) {
        if (this._gmList.isEmpty()) {
            SystemMessage sm = new SystemMessage(702);
            player.sendPacket(sm);
        } else {
            SystemMessage sm = new SystemMessage(703);
            player.sendPacket(sm);
            for (L2PcInstance gm : this._gmList) {
                sm = new SystemMessage(704);
                sm.addString(gm.getName());
                player.sendPacket(sm);
            }
        }
    }

    public void broadcastToGMs(ServerBasePacket packet) {
        for (L2PcInstance gm : this._gmList) {
            gm.sendPacket(packet);
        }
    }
}

