/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;
import net.sf.l2j.L2DatabaseFactory;
import net.sf.l2j.gameserver.HennaTable;
import net.sf.l2j.gameserver.model.ClassId;
import net.sf.l2j.gameserver.model.L2HennaInstance;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.templates.L2Henna;

public class HennaTreeTable {
    private static Logger _log = Logger.getLogger(HennaTreeTable.class.getName());
    private static final HennaTreeTable _instance = new HennaTreeTable();
    private HashMap<ClassId, ArrayList<L2HennaInstance>> _hennaTrees = new HashMap();
    private boolean _initialized = true;

    public static HennaTreeTable getInstance() {
        return _instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HennaTreeTable() {
        int classId = 0;
        int count = 0;
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT class_name, id, parent_id FROM class_list ORDER BY id");
            ResultSet classlist = statement.executeQuery();
            ArrayList<L2HennaInstance> list = new ArrayList<L2HennaInstance>();
            while (classlist.next()) {
                list = new ArrayList();
                classId = classlist.getInt("id");
                PreparedStatement statement2 = con.prepareStatement("SELECT class_id, symbol_id FROM henna_trees where class_id=? ORDER BY symbol_id");
                statement2.setInt(1, classId);
                ResultSet hennatree = statement2.executeQuery();
                while (hennatree.next()) {
                    int id = hennatree.getInt("symbol_id");
                    L2Henna template = HennaTable.getInstance().getTemplate(id);
                    L2HennaInstance temp = new L2HennaInstance(template);
                    temp.setSymbolId(id);
                    temp.setItemIdDye(template.getDyeId());
                    temp.setAmountDyeRequire(template.getAmountDyeRequire());
                    temp.setPrice(template.getPrice());
                    temp.setStatINT(template.getStatINT());
                    temp.setStatSTR(template.getStatSTR());
                    temp.setStatCON(template.getStatCON());
                    temp.setStatMEM(template.getStatMEM());
                    temp.setStatDEX(template.getStatDEX());
                    temp.setStatWIT(template.getStatWIT());
                    list.add(temp);
                }
                this._hennaTrees.put(ClassId.values()[classId], list);
                hennatree.close();
                statement2.close();
                count += list.size();
                _log.fine("Henna Tree for Class: " + classId + " has " + list.size() + " Henna Templates.");
            }
            classlist.close();
            statement.close();
        }
        catch (Exception e) {
            _log.warning("error while creating henna tree for classId " + classId + "  " + e);
            e.printStackTrace();
        }
        finally {
            try {
                con.close();
            }
            catch (Exception e) {}
        }
        _log.config("HennaTreeTable: Loaded " + count + " Henna Tree Templates.");
    }

    public L2HennaInstance[] getAvailableHenna(L2PcInstance cha, ClassId classId) {
        ArrayList<L2HennaInstance> result = new ArrayList<L2HennaInstance>();
        ArrayList<L2HennaInstance> henna = this._hennaTrees.get((Object)classId);
        if (henna == null) {
            _log.warning("Hennatree for class " + (Object)((Object)classId) + " is not defined !");
            return new L2HennaInstance[0];
        }
        for (int i = 0; i < henna.size(); ++i) {
            L2HennaInstance temp = henna.get(i);
            result.add(temp);
        }
        return result.toArray(new L2HennaInstance[result.size()]);
    }

    public boolean isInitialized() {
        return this._initialized;
    }
}

