/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.l2j.Config;
import net.sf.l2j.L2DatabaseFactory;
import net.sf.l2j.gameserver.IdFactory;
import net.sf.l2j.gameserver.Item;
import net.sf.l2j.gameserver.model.L2ItemInstance;
import net.sf.l2j.gameserver.model.L2World;
import net.sf.l2j.gameserver.skills.SkillsEngine;
import net.sf.l2j.gameserver.templates.L2Armor;
import net.sf.l2j.gameserver.templates.L2ArmorType;
import net.sf.l2j.gameserver.templates.L2EtcItem;
import net.sf.l2j.gameserver.templates.L2EtcItemType;
import net.sf.l2j.gameserver.templates.L2Item;
import net.sf.l2j.gameserver.templates.L2Weapon;
import net.sf.l2j.gameserver.templates.L2WeaponType;
import net.sf.l2j.gameserver.templates.StatsSet;

public class ItemTable {
    private static Logger _log = Logger.getLogger(ItemTable.class.getName());
    private static final HashMap<String, Integer> _materials = new HashMap();
    private static final HashMap<String, Integer> _crystalTypes = new HashMap();
    private static final HashMap<String, L2WeaponType> _weaponTypes = new HashMap();
    private static final HashMap<String, L2ArmorType> _armorTypes = new HashMap();
    private static final HashMap<String, Integer> _slots = new HashMap();
    private L2Item[] _allTemplates;
    private HashMap<Integer, L2EtcItem> _etcItems = new HashMap();
    private HashMap<Integer, L2Armor> _armors = new HashMap();
    private HashMap<Integer, L2Weapon> _weapons = new HashMap();
    private HashMap _crystalList;
    private boolean _initialized = true;
    private static ItemTable _instance;
    private static final String[] SQL_ITEM_SELECTS;
    private static final HashMap<Integer, Item> itemData;
    private static final HashMap<Integer, Item> weaponData;
    private static final HashMap<Integer, Item> armorData;

    public static ItemTable getInstance() {
        if (_instance == null) {
            _instance = new ItemTable();
        }
        return _instance;
    }

    public Item newItem() {
        return new Item();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemTable() {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            for (String selectQuery : SQL_ITEM_SELECTS) {
                PreparedStatement statement = con.prepareStatement(selectQuery);
                ResultSet rset = statement.executeQuery();
                while (rset.next()) {
                    Item newItem;
                    if (selectQuery.endsWith("etcitem")) {
                        newItem = this.readItem(rset);
                        itemData.put(newItem.id, newItem);
                        continue;
                    }
                    if (selectQuery.endsWith("armor")) {
                        newItem = this.readArmor(rset);
                        armorData.put(newItem.id, newItem);
                        continue;
                    }
                    if (!selectQuery.endsWith("weapon")) continue;
                    newItem = this.readWeapon(rset);
                    weaponData.put(newItem.id, newItem);
                }
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "data error on item: ", e);
        }
        finally {
            try {
                con.close();
            }
            catch (Exception e) {}
        }
        for (L2Armor armor : SkillsEngine.getInstance().loadArmors(armorData)) {
            this._armors.put(armor.getItemId(), armor);
        }
        _log.config("ItemTable: Loaded " + this._armors.size() + " Armors.");
        for (L2EtcItem item : SkillsEngine.getInstance().loadItems(itemData)) {
            this._etcItems.put(item.getItemId(), item);
        }
        _log.config("ItemTable: Loaded " + this._etcItems.size() + " Items.");
        for (L2Weapon weapon : SkillsEngine.getInstance().loadWeapons(weaponData)) {
            this._weapons.put(weapon.getItemId(), weapon);
        }
        _log.config("ItemTable: Loaded " + this._weapons.size() + " Weapons.");
        this.buildFastLookupTable();
        this._crystalList = null;
    }

    private Item readWeapon(ResultSet rset) throws SQLException {
        Item item = new Item();
        item.set = new StatsSet();
        item.type = _weaponTypes.get(rset.getString("weaponType"));
        item.id = rset.getInt("item_id");
        item.name = rset.getString("name");
        item.set.set("item_id", item.id);
        item.set.set("name", item.name);
        if (item.type == L2WeaponType.NONE) {
            item.set.set("type1", 1);
            item.set.set("type2", 1);
        } else {
            item.set.set("type1", 0);
            item.set.set("type2", 0);
        }
        item.set.set("bodypart", _slots.get(rset.getString("bodypart")));
        item.set.set("material", _materials.get(rset.getString("material")));
        item.set.set("crystal_type", _crystalTypes.get(rset.getString("crystal_type")));
        item.set.set("crystallizable", Boolean.valueOf(rset.getString("crystallizable")));
        item.set.set("weight", rset.getInt("weight"));
        item.set.set("soulshots", rset.getInt("soulshots"));
        item.set.set("spiritshots", rset.getInt("spiritshots"));
        item.set.set("p_dam", rset.getInt("p_dam"));
        item.set.set("rnd_dam", rset.getInt("rnd_dam"));
        item.set.set("critical", rset.getInt("critical"));
        item.set.set("hit_modify", rset.getDouble("hit_modify"));
        item.set.set("avoid_modify", rset.getInt("avoid_modify"));
        item.set.set("shield_def", rset.getInt("shield_def"));
        item.set.set("shield_def_rate", rset.getInt("shield_def_rate"));
        item.set.set("atk_speed", rset.getInt("atk_speed"));
        item.set.set("mp_consume", rset.getInt("mp_consume"));
        item.set.set("m_dam", rset.getInt("m_dam"));
        item.set.set("durability", rset.getInt("durability"));
        item.set.set("price", rset.getInt("price"));
        item.set.set("crystal_count", rset.getInt("crystal_count"));
        item.set.set("sellable", Boolean.valueOf(rset.getString("sellable")));
        return item;
    }

    private Item readArmor(ResultSet rset) throws SQLException {
        Item item = new Item();
        item.set = new StatsSet();
        item.type = _armorTypes.get(rset.getString("armor_type"));
        item.id = rset.getInt("item_id");
        item.name = rset.getString("name");
        item.set.set("item_id", item.id);
        item.set.set("name", item.name);
        int bodypart = _slots.get(rset.getString("bodypart"));
        item.set.set("bodypart", bodypart);
        item.set.set("crystallizable", Boolean.valueOf(rset.getString("crystallizable")));
        item.set.set("crystal_count", rset.getInt("crystal_count"));
        item.set.set("sellable", Boolean.valueOf(rset.getString("sellable")));
        if (bodypart == 8 || bodypart == 65536 || (bodypart & 4) != 0 || (bodypart & 0x20) != 0) {
            item.set.set("type1", 0);
            item.set.set("type2", 2);
        } else {
            item.set.set("type1", 1);
            item.set.set("type2", 1);
        }
        item.set.set("weight", rset.getInt("weight"));
        item.set.set("material", _materials.get(rset.getString("material")));
        item.set.set("crystal_type", _crystalTypes.get(rset.getString("crystal_type")));
        item.set.set("avoid_modify", rset.getInt("avoid_modify"));
        item.set.set("durability", rset.getInt("durability"));
        item.set.set("p_def", rset.getInt("p_def"));
        item.set.set("m_def", rset.getInt("m_def"));
        item.set.set("mp_bonus", rset.getInt("mp_bonus"));
        item.set.set("price", rset.getInt("price"));
        return item;
    }

    private Item readItem(ResultSet rset) throws SQLException {
        Item item = new Item();
        item.set = new StatsSet();
        item.id = rset.getInt("item_id");
        item.set.set("item_id", item.id);
        item.set.set("crystallizable", Boolean.valueOf(rset.getString("crystallizable")));
        item.set.set("type1", 4);
        item.set.set("type2", 5);
        item.set.set("bodypart", 0);
        item.set.set("crystal_count", rset.getInt("crystal_count"));
        item.set.set("sellable", Boolean.valueOf(rset.getString("sellable")));
        String itemType = rset.getString("item_type");
        if (itemType.equals("none")) {
            item.type = L2EtcItemType.OTHER;
        } else if (itemType.equals("castle_guard")) {
            item.type = L2EtcItemType.SCROLL;
        } else if (itemType.equals("material")) {
            item.type = L2EtcItemType.MATERIAL;
        } else if (itemType.equals("pet_collar")) {
            item.type = L2EtcItemType.PET_COLLAR;
        } else if (itemType.equals("potion")) {
            item.type = L2EtcItemType.POTION;
        } else if (itemType.equals("recipe")) {
            item.type = L2EtcItemType.RECEIPE;
        } else if (itemType.equals("scroll")) {
            item.type = L2EtcItemType.SCROLL;
        } else if (itemType.equals("seed")) {
            item.type = L2EtcItemType.SEED;
        } else if (itemType.equals("arrow")) {
            item.type = L2EtcItemType.ARROW;
            item.set.set("bodypart", 256);
        } else {
            _log.fine("unknown etcitem type:" + itemType);
            item.type = L2EtcItemType.OTHER;
        }
        String consume = rset.getString("consume_type");
        if (consume.equals("asset")) {
            item.type = L2EtcItemType.MONEY;
            item.set.set("stackable", true);
            item.set.set("type2", 4);
        } else if (consume.equals("stackable")) {
            item.set.set("stackable", true);
        } else {
            item.set.set("stackable", false);
        }
        int material = _materials.get(rset.getString("material"));
        item.set.set("material", material);
        int crystal = _crystalTypes.get(rset.getString("crystal_type"));
        item.set.set("crystal_type", crystal);
        int weight = rset.getInt("weight");
        item.set.set("weight", weight);
        item.name = rset.getString("name");
        item.set.set("name", item.name);
        item.set.set("durability", rset.getInt("durability"));
        item.set.set("price", rset.getInt("price"));
        if (!(weight != 0 || item.type == L2EtcItemType.MONEY || item.name.startsWith("world_map") || item.name.startsWith("crystal_") || item.name.startsWith("blue_seal_stone") || item.name.startsWith("green_seal_stone") || item.name.startsWith("red_seal_stone") || item.name.equals("adena_of_ancient"))) {
            item.type = L2EtcItemType.QUEST;
            item.set.set("type2", 3);
        } else if (item.name.startsWith("sb_")) {
            item.type = L2EtcItemType.SPELLBOOK;
            item.set.set("type2", 5);
        } else if (item.name.startsWith("rp_")) {
            item.type = L2EtcItemType.RECEIPE;
            item.set.set("type2", 5);
        } else if (item.name.startsWith("q_")) {
            item.type = L2EtcItemType.QUEST;
            item.set.set("type2", 3);
        }
        return item;
    }

    public boolean isInitialized() {
        return this._initialized;
    }

    private void buildFastLookupTable() {
        L2Item item;
        int highestId = 0;
        for (Integer id : this._armors.keySet()) {
            item = this._armors.get(id);
            if (item.getItemId() <= highestId) continue;
            highestId = item.getItemId();
        }
        for (Integer id : this._weapons.keySet()) {
            item = this._weapons.get(id);
            if (item.getItemId() <= highestId) continue;
            highestId = item.getItemId();
        }
        for (Integer id : this._etcItems.keySet()) {
            item = this._etcItems.get(id);
            if (item.getItemId() <= highestId) continue;
            highestId = item.getItemId();
        }
        if (Config.DEBUG) {
            _log.fine("highest item id used:" + highestId);
        }
        this._allTemplates = new L2Item[highestId + 1];
        for (Integer id : this._armors.keySet()) {
            item = this._armors.get(id);
            assert (this._allTemplates[id] == null);
            this._allTemplates[id.intValue()] = item;
        }
        for (Integer id : this._weapons.keySet()) {
            item = this._weapons.get(id);
            assert (this._allTemplates[id] == null);
            this._allTemplates[id.intValue()] = item;
        }
        for (Integer id : this._etcItems.keySet()) {
            item = this._etcItems.get(id);
            assert (this._allTemplates[id] == null);
            this._allTemplates[id.intValue()] = item;
        }
    }

    public L2Item getTemplate(int id) {
        return this._allTemplates[id];
    }

    public L2ItemInstance createItem(int itemId) {
        L2ItemInstance temp = new L2ItemInstance(IdFactory.getInstance().getNextId(), itemId);
        if (Config.DEBUG) {
            _log.fine("ItemTable: Item created  oid:" + temp.getObjectId() + " itemid:" + itemId);
        }
        L2World.getInstance().storeObject(temp);
        return temp;
    }

    public L2ItemInstance createDummyItem(int itemId) {
        L2Item item = this.getTemplate(itemId);
        if (item == null) {
            return null;
        }
        L2ItemInstance temp = new L2ItemInstance(0, item);
        try {
            temp = new L2ItemInstance(0, itemId);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        if (temp.getItem() == null) {
            _log.warning("ItemTable: Item Template missing for Id: " + itemId);
        }
        return temp;
    }

    static {
        _materials.put("paper", 8);
        _materials.put("wood", 9);
        _materials.put("liquid", 18);
        _materials.put("cloth", 10);
        _materials.put("leather", 11);
        _materials.put("horn", 13);
        _materials.put("bone", 12);
        _materials.put("bronze", 3);
        _materials.put("fine_steel", 1);
        _materials.put("cotton", 1);
        _materials.put("mithril", 6);
        _materials.put("silver", 4);
        _materials.put("gold", 5);
        _materials.put("adamantaite", 15);
        _materials.put("steel", 0);
        _materials.put("oriharukon", 7);
        _materials.put("blood_steel", 2);
        _materials.put("crystal", 17);
        _materials.put("damascus", 14);
        _materials.put("chrysolite", 16);
        _materials.put("scale_of_dragon", 19);
        _materials.put("dyestuff", 20);
        _materials.put("cobweb", 21);
        _materials.put("seed", 21);
        _crystalTypes.put("s", 5);
        _crystalTypes.put("a", 4);
        _crystalTypes.put("b", 3);
        _crystalTypes.put("c", 2);
        _crystalTypes.put("d", 1);
        _crystalTypes.put("none", 0);
        _weaponTypes.put("blunt", L2WeaponType.BLUNT);
        _weaponTypes.put("bow", L2WeaponType.BOW);
        _weaponTypes.put("dagger", L2WeaponType.DAGGER);
        _weaponTypes.put("dual", L2WeaponType.DUAL);
        _weaponTypes.put("dualfist", L2WeaponType.DUALFIST);
        _weaponTypes.put("etc", L2WeaponType.ETC);
        _weaponTypes.put("fist", L2WeaponType.FIST);
        _weaponTypes.put("none", L2WeaponType.NONE);
        _weaponTypes.put("pole", L2WeaponType.POLE);
        _weaponTypes.put("sword", L2WeaponType.SWORD);
        _armorTypes.put("none", L2ArmorType.NONE);
        _armorTypes.put("light", L2ArmorType.LIGHT);
        _armorTypes.put("heavy", L2ArmorType.HEAVY);
        _armorTypes.put("magic", L2ArmorType.MAGIC);
        _slots.put("chest", 1024);
        _slots.put("CHEST", 32768);
        _slots.put("head", 64);
        _slots.put("hair", 65536);
        _slots.put("underwear", 1);
        _slots.put("back", 8192);
        _slots.put("neck", 8);
        _slots.put("legs", 2048);
        _slots.put("feet", 4096);
        _slots.put("gloves", 512);
        _slots.put("chest,legs", 3072);
        _slots.put("rhand", 128);
        _slots.put("lhand", 256);
        _slots.put("lrhand", 16384);
        _slots.put("rear,lear", 6);
        _slots.put("rfinger,lfinger", 48);
        _slots.put("none", 0);
        SQL_ITEM_SELECTS = new String[]{"SELECT item_id, name, crystallizable, item_type, weight, consume_type, material, crystal_type, durability, price, crystal_count, sellable FROM etcitem", "SELECT item_id, name, bodypart, crystallizable, armor_type, weight, material, crystal_type, avoid_modify, durability, p_def, m_def, mp_bonus, price, crystal_count, sellable FROM armor", "SELECT item_id, name, bodypart, crystallizable, weight, soulshots, spiritshots, material, crystal_type, p_dam, rnd_dam, weaponType, critical, hit_modify, avoid_modify, shield_def, shield_def_rate, atk_speed, mp_consume, m_dam, durability, price, crystal_count, sellable FROM weapon"};
        itemData = new HashMap();
        weaponData = new HashMap();
        armorData = new HashMap();
    }
}

