/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.logging.Logger;
import net.sf.l2j.L2DatabaseFactory;
import net.sf.l2j.gameserver.model.ClassId;
import net.sf.l2j.gameserver.model.L2LvlupData;

public class LevelUpData {
    private static final String SELECT_ALL = "SELECT classid, defaulthpbase, defaulthpadd, defaulthpmod, defaultmpbase, defaultmpadd, defaultmpmod, class_lvl FROM lvlupgain";
    private static final String CLASS_LVL = "class_lvl";
    private static final String MP_MOD = "defaultmpmod";
    private static final String MP_ADD = "defaultmpadd";
    private static final String MP_BASE = "defaultmpbase";
    private static final String HP_MOD = "defaulthpmod";
    private static final String HP_ADD = "defaulthpadd";
    private static final String HP_BASE = "defaulthpbase";
    private static final String CLASS_ID = "classid";
    private static Logger _log = Logger.getLogger(LevelUpData.class.getName());
    private static LevelUpData _instance;
    private HashMap<Integer, L2LvlupData> _lvltable = new HashMap();

    public static LevelUpData getInstance() {
        if (_instance == null) {
            _instance = new LevelUpData();
        }
        return _instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LevelUpData() {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement(SELECT_ALL);
            ResultSet rset = statement.executeQuery();
            while (rset.next()) {
                L2LvlupData lvlDat = new L2LvlupData();
                lvlDat.set_classid(rset.getInt(CLASS_ID));
                lvlDat.set_classLvl(rset.getInt(CLASS_LVL));
                lvlDat.set_classHpBase(rset.getFloat(HP_BASE));
                lvlDat.set_classHpAdd(rset.getFloat(HP_ADD));
                lvlDat.set_classHpModifier(rset.getFloat(HP_MOD));
                lvlDat.set_classMpBase(rset.getFloat(MP_BASE));
                lvlDat.set_classMpAdd(rset.getFloat(MP_ADD));
                lvlDat.set_classMpModifier(rset.getFloat(MP_MOD));
                this._lvltable.put(new Integer(lvlDat.get_classid()), lvlDat);
            }
            rset.close();
            statement.close();
            _log.config("LevelUpData: Loaded " + this._lvltable.size() + " Character Level Up Templates.");
        }
        catch (Exception e) {
            _log.warning("error while creating Lvl up data table " + e);
        }
        finally {
            try {
                con.close();
            }
            catch (Exception exception) {}
        }
    }

    public L2LvlupData getTemplate(int classId) {
        return this._lvltable.get(classId);
    }

    public L2LvlupData getTemplate(ClassId classId) {
        return this._lvltable.get(classId.getId());
    }
}

