/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver;

import java.lang.reflect.Constructor;
import java.util.Random;
import net.sf.l2j.gameserver.IdFactory;
import net.sf.l2j.gameserver.NpcTable;
import net.sf.l2j.gameserver.model.L2NpcInstance;
import net.sf.l2j.gameserver.templates.L2NpcTemplate;

public class MonsterRace {
    private L2NpcInstance[] monsters = new L2NpcInstance[8];
    private static MonsterRace _instance;
    private Constructor _constructor;
    private int[][] speeds = new int[8][20];
    private int[] first = new int[2];
    private int[] second = new int[2];

    private MonsterRace() {
    }

    public static MonsterRace getInstance() {
        if (_instance == null) {
            _instance = new MonsterRace();
        }
        return _instance;
    }

    public void newRace() {
        Random r = new Random();
        int random = 0;
        for (int i = 0; i < 8; ++i) {
            int id = 8003;
            random = r.nextInt(25);
            for (int j = i - 1; j >= 0; --j) {
                if (this.monsters[j].getTemplate().npcId != id + random) continue;
                random = r.nextInt(25);
            }
            try {
                L2NpcTemplate template = NpcTable.getInstance().getTemplate(id + random);
                this._constructor = Class.forName("net.sf.l2j.gameserver.model." + template.type + "Instance").getConstructors()[0];
                int objectId = IdFactory.getInstance().getNextId();
                this.monsters[i] = (L2NpcInstance)this._constructor.newInstance(objectId, template);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.newSpeeds();
    }

    public void newSpeeds() {
        Random generator = new Random();
        this.speeds = new int[8][20];
        int total = 0;
        for (int i = 0; i < 8; ++i) {
            total = 0;
            for (int j = 0; j < 20; ++j) {
                this.speeds[i][j] = j == 19 ? 100 : generator.nextInt(60) + 65;
                total += this.speeds[i][j];
            }
            if (total > this.first[1]) {
                this.second[0] = this.first[0];
                this.second[1] = this.first[1];
                this.first[0] = 8 - i;
                this.first[1] = total;
                continue;
            }
            if (total <= this.second[1]) continue;
            this.second[0] = 8 - i;
            this.second[1] = total;
        }
    }

    public L2NpcInstance[] getMonsters() {
        return this.monsters;
    }

    public int[][] getSpeeds() {
        return this.speeds;
    }

    public int getFirstPlace() {
        return this.first[0];
    }

    public int getSecondPlace() {
        return this.second[0];
    }
}

