/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver;

import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import net.sf.l2j.gameserver.Connection;
import net.sf.l2j.gameserver.model.L2ItemInstance;
import net.sf.l2j.gameserver.model.Transaction;
import net.sf.l2j.gameserver.model.Transactor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionManager {
    private static TransactionManager singleton;
    private static Connection connection;
    private static int transactionCounter;
    private Hashtable<Integer, Transaction> transactionTable = new Hashtable();
    private Set<Transactor> negotiatingTradeRequest;
    private Hashtable<Object, Transactor> transactorTable = new Hashtable();

    private TransactionManager() {
        this.negotiatingTradeRequest = new HashSet<Transactor>();
    }

    public static TransactionManager getInstance() {
        if (singleton == null) {
            singleton = new TransactionManager();
        }
        return singleton;
    }

    public Transaction getTransaction(int transactionID) {
        return this.transactionTable.get(transactionID);
    }

    private boolean validTransactor(Object transactor, int transactionID) {
        Transaction transaction = this.getTransaction(transactionID);
        return transaction.getState(this.retreiveTransactor(transactor)) != null;
    }

    private boolean isInTradeRequest(Object transactor) {
        return this.negotiatingTradeRequest.contains(this.retreiveTransactor(transactor));
    }

    public Object getTradeRequestor(Object requestee) {
        Transactor transactee = this.retreiveTransactor(requestee);
        return transactee.getTradeRequestor().getObject();
    }

    public void requestTrade(Object objectTransactor, Object objectTransactee) {
        Transactor transactor = this.retreiveTransactor(objectTransactor);
        Transactor transactee = this.retreiveTransactor(objectTransactee);
        if (this.isInTradeRequest(transactor) || this.isInTradeRequest(transactee)) {
            return;
        }
        Transaction newTransaction = new Transaction(transactor, transactee);
        int transactionID = newTransaction.getTransactionID();
        this.negotiatingTradeRequest.addAll(newTransaction.getParticipants());
        this.transactionTable.put(transactionID, newTransaction);
    }

    public void acceptTradeRequest(Object objectTransactee, int transactionID) {
        Transactor transactee = this.retreiveTransactor(objectTransactee);
        Transaction transaction = this.getTransaction(transactionID);
        if (transaction.getState(transactee) == Transaction.TransactorState.DECIDING) {
            transaction.acceptedRequest(transactee);
        }
        this.negotiatingTradeRequest.removeAll(transaction.getParticipants());
    }

    public void cancelTrade(Object objectTransactor, int transactionID) {
        Transactor transactor = this.retreiveTransactor(objectTransactor);
        if (this.validTransactor(transactor, transactionID)) {
            Transaction transaction = this.transactionTable.remove(transactionID);
            transaction.cancel();
            this.negotiatingTradeRequest.removeAll(transaction.getParticipants());
        }
    }

    public void rejectTradeRequest(Object transactor1, Object transactor2) {
        Transactor transactee;
        Transactor transactor = this.retreiveTransactor(transactor1);
        int transactionID = transactor.getTransactionID(transactee = this.retreiveTransactor(transactor2));
        if (transactionID >= 0) {
            Transaction transaction = this.transactionTable.remove(transactionID);
            transaction.cancel();
            this.negotiatingTradeRequest.removeAll(transaction.getParticipants());
        }
        transactor.clearTradeRequestor();
        transactee.clearTradeRequestor();
    }

    public void removeTransactor(Object objectTransactor) {
    }

    public void addItemToTrade(Object objectTransactor, L2ItemInstance item, int transactionID) {
        Transactor transactor = this.retreiveTransactor(objectTransactor);
        this.getTransaction(transactionID).addItemListToTrade(transactor, Collections.nCopies(1, item));
    }

    public void addItemListToTrade(Object objectTransactor, List<L2ItemInstance> itemList, int transactionID) {
        Transactor transactor = this.retreiveTransactor(objectTransactor);
        this.getTransaction(transactionID).addItemListToTrade(transactor, itemList);
    }

    public void confirmTrade(Object objectTransactor, int transactionID) {
        Transactor transactor = this.retreiveTransactor(objectTransactor);
        Transaction transaction = this.getTransaction(transactionID);
        transaction.confirmTrade(transactor);
        if (transaction.transactionConfirmed()) {
            this.doTransfer(transaction);
        }
    }

    public List<L2ItemInstance> retreiveTradeList(Object objectTransactor, int transactionID) {
        Transactor transactor = this.retreiveTransactor(objectTransactor);
        Transaction transaction = this.getTransaction(transactionID);
        if (transaction.transactionConfirmed()) {
            if (transaction.isTransactionFinished()) {
                this.transactionTable.remove(transactionID);
            }
            return transaction.getTradeList(transactor);
        }
        return null;
    }

    private void doTransfer(Transaction transaction) {
        Transactor transactor = transaction.getTransactor();
        Transactor transactee = transaction.getTransactee();
        List<L2ItemInstance> temporaryList = transaction.getTradeList(transactor);
        transactor.setTradeList(transaction.getTradeList(transactee));
        transactee.setTradeList(temporaryList);
    }

    public static int getNewTransactionID() {
        int transactionID = transactionCounter;
        transactionCounter = transactionCounter == Integer.MAX_VALUE ? 1 : ++transactionCounter;
        return transactionID;
    }

    public int getTransactionsInProgress(Object objectTransactor) {
        Transactor transactor = this.retreiveTransactor(objectTransactor);
        return transactor == null ? 0 : transactor.getTransactionsInProgress();
    }

    public Transactor retreiveTransactor(Object object) {
        Transactor transactor = this.transactorTable.get(object);
        if (transactor == null) {
            transactor = new Transactor(object);
            this.transactorTable.put(object, transactor);
        }
        return transactor;
    }
}

