/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import javax.imageio.ImageIO;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.ClientScheduler;
import net.sf.l2j.gameserver.TaskPriority;
import net.sf.l2j.gameserver.model.L2CharPosition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Universe
implements Serializable {
    private static final long serialVersionUID = -2040223695811104704L;
    public static final int MIN_X = -127900;
    public static final int MAX_X = 194327;
    public static final int MIN_Y = -30000;
    public static final int MAX_Y = 259536;
    public static final int MIN_Z = -17000;
    public static final int MAX_Z = 17000;
    public static final int MIN_X_GRID = 60;
    public static final int MIN_Y_GRID = 60;
    public static final int MIN_Z_GRID = 60;
    public static final int MIN_GRID = 360;
    private static Universe _instance;
    protected static Logger _log;
    private float standardDeviation = 0.0f;
    private float mean = 0.0f;
    protected List<Coord> coordList = new LinkedList<Coord>();
    private HashSet<Integer> _logPlayers = new HashSet();
    private boolean _logAll = true;

    public static void main(String[] args) {
        Universe u = new Universe();
        u.load();
        u.implode(false);
    }

    private void removeDoubles() {
        if (this.coordList != null) {
            System.out.println("Old map size: " + this.coordList.size());
            HashSet<Coord> s = new HashSet<Coord>();
            for (Coord p : this.coordList) {
                s.add(p);
            }
            this.coordList = new LinkedList<Coord>();
            for (Coord p : s) {
                this.coordList.add(p);
            }
            System.out.println("New map size: " + this.coordList.size());
        }
    }

    public static Universe getInstance() {
        if (_instance == null && Config.ACTIVATE_POSITION_RECORDER) {
            _instance = new Universe();
        }
        return _instance;
    }

    private Universe() {
        ClientScheduler.getInstance().scheduleAtFixedRate(new UniverseDump(), TaskPriority.PR_LOW, 30000L, 30000L);
    }

    public void registerHeight(int x, int y, int z) {
        this.coordList.add(new Coord(x, y, z));
    }

    public void registerObstacle(int x, int y, int z) {
        this.coordList.add(new Coord(x, y, z));
    }

    public boolean shouldLog(Integer id) {
        return this._logPlayers.contains(id) || this._logAll;
    }

    public void setLogAll(boolean flag) {
        this._logAll = flag;
    }

    public void addLogPlayer(Integer id) {
        this._logPlayers.add(id);
        this._logAll = false;
    }

    public void removeLogPlayer(Integer id) {
        this._logPlayers.remove(id);
    }

    public void loadAscii() {
        int initialSize = this.coordList.size();
        try {
            String line;
            BufferedReader r = new BufferedReader(new FileReader("data/universe.txt"));
            while ((line = r.readLine()) != null) {
                StringTokenizer st = new StringTokenizer(line);
                String x1 = st.nextToken();
                String y1 = st.nextToken();
                String z1 = st.nextToken();
                int x = Integer.parseInt(x1);
                int y = Integer.parseInt(y1);
                int z = Integer.parseInt(z1);
                this.coordList.add(new Coord(x, y, z));
            }
            r.close();
            _log.info(this.coordList.size() - initialSize + " additional nodes loaded from text file.");
        }
        catch (Exception e) {
            _log.info("could not read text file universe.txt");
        }
    }

    public void createMap() {
        int zoom = 100;
        int w = 322227 / zoom;
        int h = 289536 / zoom;
        BufferedImage bi = new BufferedImage(w, h, 11);
        Graphics2D gr = bi.createGraphics();
        int min_z = 0;
        int max_z = 0;
        for (Coord pos : this.coordList) {
            if (pos._z < min_z) {
                min_z = pos._z;
            }
            if (pos._z <= max_z) continue;
            max_z = pos._z;
        }
        for (Coord pos : this.coordList) {
            int x = (pos._x - -127900) / zoom;
            int y = (pos._y - -30000) / zoom;
            int color = (int)(((long)pos._z - -17000L) * 0xFFFFFFL / 34000L);
            gr.setColor(new Color(color));
            gr.drawLine(x, y, x, y);
        }
        try {
            ImageIO.write((RenderedImage)bi, "png", new File("universe.png"));
        }
        catch (Exception e) {
            _log.warning("cannot create universe.png: " + e);
        }
    }

    public void load() {
        int total = 0;
        if (this.coordList == null) {
            this.coordList = new LinkedList<Coord>();
        }
        try {
            this.loadBinFiles();
            this.loadHexFiles();
            this.loadFinFiles();
            _log.info(this.coordList.size() + " map vertices loaded in total.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("Total: " + total);
    }

    private void loadFinFiles() throws FileNotFoundException, IOException {
        File[] files;
        UniverseFilter filter = new UniverseFilter("fin");
        File directory = new File("data");
        for (File file : files = directory.listFiles(filter)) {
            FileInputStream fos = new FileInputStream(file);
            DataInputStream data = new DataInputStream(fos);
            int count = data.readInt();
            LinkedList<Coord> newMap = new LinkedList<Coord>();
            for (int i = 0; i < count; ++i) {
                newMap.add(new Coord(data.readInt(), data.readInt(), data.readInt()));
            }
            data.close();
            _log.info(newMap.size() + " map vertices loaded from file " + file.getName());
            this.coordList.addAll(newMap);
        }
    }

    private void loadHexFiles() throws FileNotFoundException, IOException {
        File[] files;
        UniverseFilter filter = new UniverseFilter("hex");
        File directory = new File("data");
        for (File file : files = directory.listFiles(filter)) {
            FileInputStream fos = new FileInputStream(file);
            GZIPInputStream gzos = new GZIPInputStream(fos);
            DataInputStream data = new DataInputStream(gzos);
            int count = data.readInt();
            LinkedList<Coord> newMap = new LinkedList<Coord>();
            for (int i = 0; i < count; ++i) {
                newMap.add(new Coord(data.readInt(), data.readInt(), data.readInt()));
                data.readInt();
            }
            data.close();
            _log.info(newMap.size() + " map vertices loaded from file " + file.getName());
            this.coordList.addAll(newMap);
        }
    }

    private void loadBinFiles() throws FileNotFoundException, IOException, ClassNotFoundException {
        File[] files;
        UniverseFilter filter = new UniverseFilter("bin");
        File directory = new File("data");
        for (File file : files = directory.listFiles(filter)) {
            FileInputStream fis = new FileInputStream(file);
            GZIPInputStream gzis = new GZIPInputStream(fis);
            ObjectInputStream in = new ObjectInputStream(gzis);
            TreeSet temp = (TreeSet)in.readObject();
            _log.info(temp.size() + " map vertices loaded from file " + file.getName());
            in.close();
            for (Position p : temp) {
                this.coordList.add(new Coord(p._x, p._y, p._z));
            }
        }
    }

    public void flush() {
        List<Coord> oldMap = this.coordList;
        this.coordList = new LinkedList<Coord>();
        int size = oldMap.size();
        this.dump(oldMap, true);
        _log.info("Universe Map : Dumped " + size + " vertices.");
    }

    public int size() {
        int size = 0;
        if (this.coordList != null) {
            size = this.coordList.size();
        }
        return size;
    }

    public void dump(List<Coord> _map, boolean b) {
        try {
            String pad = "";
            if (b) {
                pad = "" + System.currentTimeMillis();
            }
            FileOutputStream fos = new FileOutputStream("data/universe" + pad + ".fin");
            DataOutputStream data = new DataOutputStream(fos);
            int count = _map.size();
            data.writeInt(count);
            for (Coord p : _map) {
                data.writeInt(p._x);
                data.writeInt(p._y);
                data.writeInt(p._z);
            }
            data.flush();
            data.close();
            _log.info("Universe Map saved to: data/universe" + pad + ".fin");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void implode(boolean b) {
        this.createMap();
        this.dump(this.coordList, b);
    }

    static {
        _log = Logger.getLogger(Universe.class.getName());
    }

    public class UniverseDump
    implements Runnable {
        public void run() {
            int size = Universe.this.coordList.size();
            if (size > 100000) {
                Universe.this.flush();
            }
        }
    }

    public class UniverseFilter
    implements FilenameFilter {
        String ext = "";

        public UniverseFilter(String ext) {
            this.ext = ext;
        }

        public boolean accept(File arg0, String name) {
            return name.startsWith("universe") && name.endsWith("." + this.ext);
        }
    }

    private class Coord
    implements Comparable,
    Serializable {
        private static final long serialVersionUID = -558060332886829552L;
        int _x;
        int _y;
        int _z;

        public Coord(int x, int y, int z) {
            this._x = x;
            this._y = y;
            this._z = z;
        }

        public Coord(L2CharPosition pos) {
            this._x = pos.x;
            this._y = pos.y;
            this._z = pos.z;
        }

        public int compareTo(Object obj) {
            Position o = (Position)obj;
            int res = Integer.valueOf(this._x).compareTo(o._x);
            if (res != 0) {
                return res;
            }
            res = Integer.valueOf(this._y).compareTo(o._y);
            if (res != 0) {
                return res;
            }
            res = Integer.valueOf(this._z).compareTo(o._z);
            return res;
        }

        public String toString() {
            return String.valueOf(this._x) + " " + this._y + " " + this._z;
        }
    }

    private class Position
    implements Comparable,
    Serializable {
        private static final long serialVersionUID = -8798746764450022287L;
        int _x;
        int _flag;
        int _y;
        int _z;

        public Position(int x, int y, int z, int flag) {
            this._x = x;
            this._y = y;
            this._z = z;
            this._flag = flag;
        }

        public Position(L2CharPosition pos) {
            this._x = pos.x;
            this._y = pos.y;
            this._z = pos.z;
            this._flag = 0;
        }

        public L2CharPosition L2CP() {
            return new L2CharPosition(this._x, this._y, this._z, 0);
        }

        public int compareTo(Object obj) {
            Position o = (Position)obj;
            int res = Integer.valueOf(this._x).compareTo(o._x);
            if (res != 0) {
                return res;
            }
            res = Integer.valueOf(this._y).compareTo(o._y);
            if (res != 0) {
                return res;
            }
            res = Integer.valueOf(this._z).compareTo(o._z);
            return res;
        }

        public String toString() {
            return String.valueOf(this._x) + " " + this._y + " " + this._z + " " + this._flag;
        }
    }
}

