/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.ai;

import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.l2j.gameserver.ClientScheduler;
import net.sf.l2j.gameserver.GameTimeController;
import net.sf.l2j.gameserver.ai.Ctrl;
import net.sf.l2j.gameserver.ai.CtrlEvent;
import net.sf.l2j.gameserver.ai.CtrlIntention;
import net.sf.l2j.gameserver.model.L2CharPosition;
import net.sf.l2j.gameserver.model.L2Character;
import net.sf.l2j.gameserver.model.L2Object;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.L2Skill;
import net.sf.l2j.gameserver.serverpackets.ActionFailed;
import net.sf.l2j.gameserver.serverpackets.AutoAttackStart;
import net.sf.l2j.gameserver.serverpackets.AutoAttackStop;
import net.sf.l2j.gameserver.serverpackets.CharMoveToLocation;
import net.sf.l2j.gameserver.serverpackets.Die;
import net.sf.l2j.gameserver.serverpackets.MoveToPawn;
import net.sf.l2j.gameserver.serverpackets.ServerBasePacket;
import net.sf.l2j.gameserver.serverpackets.StopMove;
import net.sf.l2j.gameserver.serverpackets.StopRotation;

abstract class AbstractAI
implements Ctrl {
    protected static final Logger _log = Logger.getLogger(AbstractAI.class.getName());
    final L2Character _actor;
    final L2Character.AIAccessor _accessor;
    protected CtrlIntention _intention = CtrlIntention.AI_INTENTION_IDLE;
    protected Object _intention_arg0 = null;
    protected Object _intention_arg1 = null;
    private boolean _client_moving;
    private boolean _client_auto_attacking;
    private int _client_moving_to_pawn_offset;
    L2Object _target;
    L2Character _cast_target;
    L2Character _attack_target;
    L2Character _follow_target;
    L2Skill _skill;
    private int _move_to_pawn_timeout;
    protected Future _follow_task = null;
    private static final int FOLLOW_INTERVAL = 1000;
    private static final int ATTACK_FOLLOW_INTERVAL = 500;

    protected AbstractAI(L2Character.AIAccessor accessor) {
        this._accessor = accessor;
        this._actor = accessor.getActor();
    }

    public L2Character getActor() {
        return this._actor;
    }

    public CtrlIntention getIntention() {
        return this._intention;
    }

    public L2Character getAttackTarget() {
        return this._attack_target;
    }

    void changeIntention(CtrlIntention intention, Object arg0, Object arg1) {
        this._intention = intention;
        this._intention_arg0 = arg0;
        this._intention_arg1 = arg1;
    }

    public final void setIntention(CtrlIntention intention) {
        this.setIntention(intention, null, null);
    }

    public final void setIntention(CtrlIntention intention, Object arg0) {
        this.setIntention(intention, arg0, null);
    }

    public final void setIntention(CtrlIntention intention, Object arg0, Object arg1) {
        if (!this._actor.isVisible() || !this._actor.hasAI()) {
            return;
        }
        if (intention != CtrlIntention.AI_INTENTION_FOLLOW && intention != CtrlIntention.AI_INTENTION_ATTACK) {
            this.stopFollow();
        }
        switch (intention) {
            case AI_INTENTION_IDLE: {
                this.onIntentionIdle();
                break;
            }
            case AI_INTENTION_ACTIVE: {
                this.onIntentionActive();
                break;
            }
            case AI_INTENTION_REST: {
                this.onIntentionRest();
                break;
            }
            case AI_INTENTION_ATTACK: {
                this.onIntentionAttack((L2Character)arg0);
                break;
            }
            case AI_INTENTION_CAST: {
                this.onIntentionCast((L2Skill)arg0, (L2Object)arg1);
                break;
            }
            case AI_INTENTION_MOVE_TO: {
                this.onIntentionMoveTo((L2CharPosition)arg0);
                break;
            }
            case AI_INTENTION_FOLLOW: {
                this.onIntentionFollow((L2Character)arg0);
                break;
            }
            case AI_INTENTION_PICK_UP: {
                this.onIntentionPickUp((L2Object)arg0);
                break;
            }
            case AI_INTENTION_INTERACT: {
                this.onIntentionInteract((L2Object)arg0);
            }
        }
    }

    public final void notifyEvent(CtrlEvent evt) {
        this.notifyEvent(evt, null, null);
    }

    public final void notifyEvent(CtrlEvent evt, Object arg0) {
        this.notifyEvent(evt, arg0, null);
    }

    public final void notifyEvent(CtrlEvent evt, Object arg0, Object arg1) {
        if (!this._actor.isVisible() || !this._actor.hasAI()) {
            return;
        }
        switch (evt) {
            case EVT_THINK: {
                this.onEvtThink();
                break;
            }
            case EVT_ATTACKED: {
                this.onEvtAttacked((L2Character)arg0);
                break;
            }
            case EVT_AGGRESSION: {
                this.onEvtAggression((L2Character)arg0, ((Number)arg1).intValue());
                break;
            }
            case EVT_STUNNED: {
                this.onEvtStunned((L2Character)arg0);
                break;
            }
            case EVT_SLEEPING: {
                this.onEvtSleeping((L2Character)arg0);
                break;
            }
            case EVT_ROOTED: {
                this.onEvtRooted((L2Character)arg0);
                break;
            }
            case EVT_CONFUSED: {
                this.onEvtConfused((L2Character)arg0);
                break;
            }
            case EVT_MUTED: {
                this.onEvtMuted((L2Character)arg0);
                break;
            }
            case EVT_READY_TO_ACT: {
                this.onEvtReadyToAct();
                break;
            }
            case EVT_USER_CMD: {
                this.onEvtUserCmd(arg0, arg1);
                break;
            }
            case EVT_ARRIVED: {
                this.onEvtArrived();
                break;
            }
            case EVT_ARRIVED_REVALIDATE: {
                this.onEvtArrivedRevalidate();
                break;
            }
            case EVT_ARRIVED_BLOCKED: {
                this.onEvtArrivedBlocked((L2CharPosition)arg0);
                break;
            }
            case EVT_FORGET_OBJECT: {
                this.onEvtForgetObject((L2Object)arg0);
                break;
            }
            case EVT_CANCEL: {
                this.onEvtCancel();
                break;
            }
            case EVT_DEAD: {
                this.onEvtDead();
                break;
            }
            case EVT_FINISH_CASTING: {
                this.onEvtFinishCasting();
            }
        }
    }

    protected abstract void onIntentionIdle();

    protected abstract void onIntentionActive();

    protected abstract void onIntentionRest();

    protected abstract void onIntentionAttack(L2Character var1);

    protected abstract void onIntentionCast(L2Skill var1, L2Object var2);

    protected abstract void onIntentionMoveTo(L2CharPosition var1);

    protected abstract void onIntentionFollow(L2Character var1);

    protected abstract void onIntentionPickUp(L2Object var1);

    protected abstract void onIntentionInteract(L2Object var1);

    protected abstract void onEvtThink();

    protected abstract void onEvtAttacked(L2Character var1);

    protected abstract void onEvtAggression(L2Character var1, int var2);

    protected abstract void onEvtStunned(L2Character var1);

    protected abstract void onEvtSleeping(L2Character var1);

    protected abstract void onEvtRooted(L2Character var1);

    protected abstract void onEvtConfused(L2Character var1);

    protected abstract void onEvtMuted(L2Character var1);

    protected abstract void onEvtReadyToAct();

    protected abstract void onEvtUserCmd(Object var1, Object var2);

    protected abstract void onEvtArrived();

    protected abstract void onEvtArrivedRevalidate();

    protected abstract void onEvtArrivedBlocked(L2CharPosition var1);

    protected abstract void onEvtForgetObject(L2Object var1);

    protected abstract void onEvtCancel();

    protected abstract void onEvtDead();

    protected abstract void onEvtFinishCasting();

    protected void clientActionFailed() {
        if (this._actor instanceof L2PcInstance) {
            this._actor.sendPacket(new ActionFailed());
        }
    }

    protected void clientSitDown() {
        if (this._actor instanceof L2PcInstance) {
            L2PcInstance player = (L2PcInstance)this._actor;
            player.sitDown();
        }
    }

    protected void clientStandUp() {
        if (this._actor instanceof L2PcInstance) {
            L2PcInstance player = (L2PcInstance)this._actor;
            player.standUp();
        }
    }

    protected void moveToPawn(L2Object pawn, int offset) {
        if (!this._actor.isMovementDisabled()) {
            if (offset < 10) {
                offset = 10;
            }
            if (this._client_moving && this._target == pawn && this._client_moving_to_pawn_offset == offset && GameTimeController.getGameTicks() < this._move_to_pawn_timeout) {
                return;
            }
            this._client_moving = true;
            this._client_moving_to_pawn_offset = offset;
            this._target = pawn;
            this._move_to_pawn_timeout = GameTimeController.getGameTicks();
            this._move_to_pawn_timeout += 10;
            if (pawn == null || this._accessor == null) {
                return;
            }
            this._accessor.moveTo(pawn.getX(), pawn.getY(), pawn.getZ(), offset);
            ServerBasePacket msg = pawn instanceof L2Character ? new MoveToPawn(this._actor, (L2Character)pawn, offset) : new CharMoveToLocation(this._actor);
            this._actor.broadcastPacket(msg);
        } else {
            this._actor.sendPacket(new ActionFailed());
        }
    }

    protected void moveTo(int x, int y, int z) {
        if (!this._actor.isMovementDisabled()) {
            this._client_moving = true;
            this._client_moving_to_pawn_offset = 0;
            this._accessor.moveTo(x, y, z);
            CharMoveToLocation msg = new CharMoveToLocation(this._actor);
            this._actor.broadcastPacket(msg);
        } else {
            this._actor.sendPacket(new ActionFailed());
        }
    }

    protected void clientStopMoving(L2CharPosition pos) {
        if (this._actor.isMoving()) {
            this._accessor.stopMove(pos);
        }
        this._client_moving_to_pawn_offset = 0;
        if (this._client_moving || pos != null) {
            this._client_moving = false;
            StopMove msg = new StopMove(this._actor);
            this._actor.broadcastPacket(msg);
            if (pos != null) {
                StopRotation sr = new StopRotation(this._actor, pos.heading);
                this._actor.sendPacket(sr);
                this._actor.broadcastPacket(sr);
            }
        }
    }

    protected void clientStartAutoAttack() {
        if (!this._client_auto_attacking) {
            this._client_auto_attacking = true;
            AutoAttackStart msg = new AutoAttackStart(this._actor.getObjectId());
            this._actor.broadcastPacket(msg);
        }
    }

    protected void clientStopAutoAttack() {
        if (this._client_auto_attacking) {
            this._client_auto_attacking = false;
            AutoAttackStop msg = new AutoAttackStop(this._actor.getObjectId());
            this._actor.broadcastPacket(msg);
        }
    }

    protected void clientNotifyDead() {
        this.clientStopAutoAttack();
        this.clientStopMoving(null);
        Die msg = new Die(this._actor);
        this._actor.broadcastPacket(msg);
        this._intention = CtrlIntention.AI_INTENTION_IDLE;
        this._target = null;
        this._cast_target = null;
        this._attack_target = null;
        this.stopFollow();
    }

    public void describeStateToPlayer(L2PcInstance player) {
        ServerBasePacket msg;
        if (this._client_moving) {
            if (this._client_moving_to_pawn_offset != 0 && this._follow_target != null) {
                msg = new MoveToPawn(this._actor, this._follow_target, this._client_moving_to_pawn_offset);
                player.sendPacket(msg);
            } else {
                msg = new CharMoveToLocation(this._actor);
                player.sendPacket(msg);
            }
        }
        if (this._client_auto_attacking) {
            msg = new AutoAttackStart(this._actor.getObjectId());
            player.sendPacket(msg);
        }
    }

    public void startFollow(L2Character target) {
        this._follow_target = target;
        this._follow_task = ClientScheduler.getInstance().scheduleMedAtFixedRate(new FollowTask(), 5L, 1000L);
    }

    public void startFollow(L2Character target, int range) {
        if (this._follow_task != null) {
            this._follow_task.cancel(false);
            this._follow_task = null;
        }
        this._follow_target = target;
        this._follow_task = ClientScheduler.getInstance().scheduleMedAtFixedRate(new FollowTask(range), 5L, 500L);
    }

    public void stopFollow() {
        if (this._follow_task != null) {
            this._follow_task.cancel(false);
            this._follow_task = null;
        }
        this._follow_target = null;
    }

    class FollowTask
    implements Runnable {
        int _range = 60;

        public FollowTask() {
        }

        public FollowTask(int range) {
            this._range = range;
        }

        public void run() {
            try {
                if (AbstractAI.this._follow_task == null) {
                    return;
                }
                if (AbstractAI.this._follow_target == null) {
                    AbstractAI.this.stopFollow();
                    return;
                }
                AbstractAI.this.moveToPawn(AbstractAI.this._follow_target, this._range);
            }
            catch (Throwable t) {
                _log.log(Level.WARNING, "", t);
            }
        }
    }
}

