/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.ai;

import java.util.Random;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import net.sf.l2j.gameserver.ClientScheduler;
import net.sf.l2j.gameserver.GameTimeController;
import net.sf.l2j.gameserver.ai.CtrlIntention;
import net.sf.l2j.gameserver.ai.L2AttackableAI;
import net.sf.l2j.gameserver.ai.L2CharacterAI;
import net.sf.l2j.gameserver.model.L2Attackable;
import net.sf.l2j.gameserver.model.L2CastleGuardInstance;
import net.sf.l2j.gameserver.model.L2Character;
import net.sf.l2j.gameserver.model.L2NpcInstance;
import net.sf.l2j.gameserver.model.L2Object;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.L2Skill;
import net.sf.l2j.gameserver.model.L2World;

public class L2CastleGuardAI
extends L2CharacterAI
implements Runnable {
    protected static final Logger _log = Logger.getLogger(L2AttackableAI.class.getName());
    private static final int RANDOM_WALK_RATE = 100;
    private static final int MAX_ATTACK_TIMEOUT = 300;
    private static final Random _rnd = new Random();
    private Future aiTask;
    private int _attack_timeout = Integer.MAX_VALUE;
    private int _globalAggro = -10;
    private boolean thinking;

    public L2CastleGuardAI(L2Character.AIAccessor accessor) {
        super(accessor);
    }

    public void run() {
        this.onEvtThink();
    }

    private boolean autoAttackCondition(L2Character target) {
        L2PcInstance player;
        L2CastleGuardInstance me = (L2CastleGuardInstance)this._actor;
        return target instanceof L2PcInstance && (player = (L2PcInstance)target).getClan().isAtWarWith(me.getClanId());
    }

    synchronized void changeIntention(CtrlIntention intention, Object arg0, Object arg1) {
        if (intention == CtrlIntention.AI_INTENTION_IDLE || intention == CtrlIntention.AI_INTENTION_ACTIVE) {
            L2Attackable npc;
            if (!this._actor.isAlikeDead() && (npc = (L2Attackable)this._actor).getKnownPlayers() != null && !npc.getKnownPlayers().isEmpty()) {
                intention = CtrlIntention.AI_INTENTION_ACTIVE;
            }
            if (intention == CtrlIntention.AI_INTENTION_IDLE) {
                super.changeIntention(CtrlIntention.AI_INTENTION_IDLE, null, null);
                if (this.aiTask != null) {
                    this.aiTask.cancel(true);
                    this.aiTask = null;
                }
                this._accessor.detachAI();
                return;
            }
        }
        super.changeIntention(intention, arg0, arg1);
        if (this.aiTask == null) {
            this.aiTask = ClientScheduler.getInstance().scheduleLowAtFixedRate(this, 1000L, 1000L);
        }
    }

    protected void onIntentionAttack(L2Character target) {
        this._attack_timeout = 300 + GameTimeController.getGameTicks();
        super.onIntentionAttack(target);
    }

    private void thinkActive() {
        L2Object[] objects;
        for (L2Object obj : objects = L2World.getInstance().getVisibleObjects(this._actor, ((L2NpcInstance)this._actor).getAggroRange())) {
            L2Character target;
            if (!(obj instanceof L2Character) || !this.autoAttackCondition(target = (L2Character)obj)) continue;
            if (!this._actor.isRunning()) {
                this._actor.setRunning();
            }
            this.setIntention(CtrlIntention.AI_INTENTION_ATTACK, target);
        }
    }

    private void thinkAttack() {
        if (this._attack_timeout < GameTimeController.getGameTicks() && this._actor.isRunning()) {
            this._actor.setWalking();
            this._attack_timeout = 300 + GameTimeController.getGameTicks();
        }
        if (this._attack_target == null || this._attack_target.isAlikeDead() || this._attack_timeout < GameTimeController.getGameTicks()) {
            this._attack_timeout = Integer.MAX_VALUE;
            this._attack_target = null;
            this.clientStopMoving(null);
            this.setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
        } else {
            L2Skill[] skills = null;
            double dist = 0.0;
            int range = 0;
            int max_range = 0;
            try {
                this._actor.setTarget(this._attack_target);
                skills = this._actor.getAllSkills();
                dist = this._actor.getDistance(this._attack_target.getX(), this._attack_target.getY());
                max_range = range = this._actor.getPhysicalAttackRange();
            }
            catch (NullPointerException e) {
                _log.warning("Encountered Null Value.");
                e.printStackTrace();
            }
            if (!this._actor.isMuted() && dist > (double)(range + 20)) {
                for (L2Skill sk : skills) {
                    if ((double)sk.getCastRange() >= dist && !this._actor.isSkillDisabled(sk.getId()) && this._actor.getCurrentMp() > (double)sk.getMpConsume()) {
                        this._accessor.doCast(sk);
                        return;
                    }
                    max_range = Math.max(max_range, sk.getCastRange());
                }
                this.moveToPawn(this._attack_target, range);
                return;
            }
            L2CastleGuardInstance guard = (L2CastleGuardInstance)this._actor;
            if (!this._actor.isMuted() && skills.length > 0) {
                for (L2Skill sk : skills) {
                    if (!((double)sk.getCastRange() >= dist) || this._actor.isSkillDisabled(sk.getId()) || !(this._actor.getCurrentMp() < (double)sk.getMpConsume()) || _rnd.nextInt(skills.length * 1000 / guard.getMagery() - 1) != 0) continue;
                    this._accessor.doCast(sk);
                    return;
                }
            }
            this._accessor.doAttack(this._attack_target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onEvtThink() {
        if (this.thinking || this._actor.isAllSkillsDisabled()) {
            return;
        }
        this.thinking = true;
        try {
            if (this.getIntention() == CtrlIntention.AI_INTENTION_ACTIVE) {
                this.thinkActive();
            } else if (this.getIntention() == CtrlIntention.AI_INTENTION_ATTACK) {
                this.thinkAttack();
            }
        }
        finally {
            this.thinking = false;
        }
    }

    protected void onEvtAttacked(L2Character attacker) {
        this._attack_timeout = 300 + GameTimeController.getGameTicks();
        if (this._globalAggro < 0) {
            this._globalAggro = 0;
        }
        ((L2Attackable)this._actor).addDamageHate(attacker, 0, 1);
        if (!this._actor.isRunning()) {
            this._actor.setRunning();
        }
        if (this.getIntention() != CtrlIntention.AI_INTENTION_ATTACK) {
            this.setIntention(CtrlIntention.AI_INTENTION_ATTACK, attacker);
        }
    }

    protected void onEvtAggression(L2Character target, int aggro) {
        if (target != null) {
            L2Attackable me = (L2Attackable)this._actor;
            me.addDamageHate(target, 0, aggro);
            aggro = me.getHating(target);
            if (aggro <= 0) {
                return;
            }
            if (this.getIntention() != CtrlIntention.AI_INTENTION_ATTACK) {
                if (!this._actor.isRunning()) {
                    this._actor.setRunning();
                }
                this.setIntention(CtrlIntention.AI_INTENTION_ATTACK, target);
            }
        } else {
            this._globalAggro += aggro;
        }
    }
}

