/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.ai;

import net.sf.l2j.Config;
import net.sf.l2j.gameserver.Universe;
import net.sf.l2j.gameserver.ai.AbstractAI;
import net.sf.l2j.gameserver.ai.CtrlEvent;
import net.sf.l2j.gameserver.ai.CtrlIntention;
import net.sf.l2j.gameserver.model.L2CharPosition;
import net.sf.l2j.gameserver.model.L2Character;
import net.sf.l2j.gameserver.model.L2DoorInstance;
import net.sf.l2j.gameserver.model.L2Object;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.L2Skill;
import net.sf.l2j.gameserver.serverpackets.CharMoveToLocation;

public class L2CharacterAI
extends AbstractAI {
    public L2CharacterAI(L2Character.AIAccessor accessor) {
        super(accessor);
    }

    protected void onIntentionIdle() {
        this.changeIntention(CtrlIntention.AI_INTENTION_IDLE, null, null);
        this._cast_target = null;
        this._attack_target = null;
        this.clientStopAutoAttack();
        this.clientStopMoving(null);
        this.clientStandUp();
    }

    protected void onIntentionActive() {
        if (this.getIntention() != CtrlIntention.AI_INTENTION_ACTIVE) {
            this.changeIntention(CtrlIntention.AI_INTENTION_ACTIVE, null, null);
            this._cast_target = null;
            this._attack_target = null;
            this.clientStopAutoAttack();
            this.clientStopMoving(null);
            this.onEvtThink();
        }
    }

    protected void onIntentionRest() {
        this.setIntention(CtrlIntention.AI_INTENTION_IDLE);
    }

    protected void onIntentionAttack(L2Character target) {
        if (this.getIntention() == CtrlIntention.AI_INTENTION_REST) {
            this.clientActionFailed();
            return;
        }
        if (this._actor.isAllSkillsDisabled() || this._actor.isAffraid()) {
            this.clientActionFailed();
            return;
        }
        if (this.getIntention() == CtrlIntention.AI_INTENTION_ATTACK) {
            if (this._attack_target != target) {
                this.clientStopAutoAttack();
                this._attack_target = target;
                this.clientStartAutoAttack();
                this.stopFollow();
                this.notifyEvent(CtrlEvent.EVT_THINK, null);
            }
        } else {
            this.clientStopAutoAttack();
            this.changeIntention(CtrlIntention.AI_INTENTION_ATTACK, target, null);
            this._attack_target = target;
            this.clientStartAutoAttack();
            this.notifyEvent(CtrlEvent.EVT_THINK, null);
        }
    }

    protected void onIntentionCast(L2Skill skill, L2Object target) {
        if (this.getIntention() == CtrlIntention.AI_INTENTION_REST) {
            this.clientActionFailed();
            return;
        }
        if (this._actor.isAllSkillsDisabled()) {
            this.clientActionFailed();
            return;
        }
        if (this._actor.isMuted() && skill.isMagic()) {
            this.clientActionFailed();
            return;
        }
        this._cast_target = (L2Character)target;
        this.clientStopAutoAttack();
        this._actor.abortAttack();
        this.clientActionFailed();
        this._skill = skill;
        this.changeIntention(CtrlIntention.AI_INTENTION_CAST, skill, target);
        this.notifyEvent(CtrlEvent.EVT_THINK, null);
    }

    protected void onIntentionMoveTo(L2CharPosition pos) {
        if (this.getIntention() == CtrlIntention.AI_INTENTION_REST) {
            this.clientActionFailed();
            return;
        }
        if (this._actor.isAllSkillsDisabled()) {
            this.clientActionFailed();
            return;
        }
        this.changeIntention(CtrlIntention.AI_INTENTION_MOVE_TO, pos, null);
        this.clientStopAutoAttack();
        this._actor.abortAttack();
        this.moveTo(pos.x, pos.y, pos.z);
    }

    protected void onIntentionFollow(L2Character target) {
        if (this.getIntention() == CtrlIntention.AI_INTENTION_REST) {
            this.clientActionFailed();
            return;
        }
        if (this._actor.isAllSkillsDisabled()) {
            this.clientActionFailed();
            return;
        }
        this.changeIntention(CtrlIntention.AI_INTENTION_FOLLOW, target, null);
        this.clientStopAutoAttack();
        this.startFollow(target);
    }

    protected void onIntentionPickUp(L2Object object) {
        if (this.getIntention() == CtrlIntention.AI_INTENTION_REST) {
            this.clientActionFailed();
            return;
        }
        if (this._actor.isAllSkillsDisabled()) {
            this.clientActionFailed();
            return;
        }
        this.changeIntention(CtrlIntention.AI_INTENTION_PICK_UP, object, null);
        this._target = object;
        this.moveToPawn(object, 20);
    }

    protected void onIntentionInteract(L2Object object) {
        if (this.getIntention() == CtrlIntention.AI_INTENTION_REST) {
            this.clientActionFailed();
            return;
        }
        if (this._actor.isAllSkillsDisabled()) {
            this.clientActionFailed();
            return;
        }
        if (this.getIntention() != CtrlIntention.AI_INTENTION_INTERACT) {
            this.clientStopAutoAttack();
            this.changeIntention(CtrlIntention.AI_INTENTION_INTERACT, object, null);
            this._target = object;
            this.moveToPawn(object, 60);
        }
    }

    protected void onEvtThink() {
    }

    protected void onEvtAttacked(L2Character attacker) {
    }

    protected void onEvtAggression(L2Character target, int aggro) {
    }

    protected void onEvtStunned(L2Character attacker) {
        this.clientStopAutoAttack();
        this.clientStopMoving(null);
        this._actor.breakAttack();
        this._actor.breakCast();
        this.onEvtAttacked(attacker);
    }

    protected void onEvtSleeping(L2Character attacker) {
        this.clientStopAutoAttack();
        this.clientStopMoving(null);
        this._actor.breakAttack();
        this._actor.breakCast();
    }

    protected void onEvtRooted(L2Character attacker) {
        this.clientStopMoving(null);
        this.onEvtAttacked(attacker);
    }

    protected void onEvtConfused(L2Character attacker) {
        this.clientStopMoving(null);
        this.onEvtAttacked(attacker);
    }

    protected void onEvtMuted(L2Character attacker) {
        this._actor.breakCast();
        this.onEvtAttacked(attacker);
    }

    protected void onEvtReadyToAct() {
        this.onEvtThink();
    }

    protected void onEvtUserCmd(Object arg0, Object arg1) {
    }

    protected void onEvtArrived() {
        if (this.getIntention() == CtrlIntention.AI_INTENTION_MOVE_TO) {
            this.setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
        }
        if (this._accessor.getActor() instanceof L2PcInstance && Config.ACTIVATE_POSITION_RECORDER) {
            ((L2PcInstance)this._accessor.getActor()).explore();
        }
        this.onEvtThink();
        if (this._actor instanceof L2PcInstance && !this._actor.isAttackingNow() && !this._actor.isCastingNow() && !((L2PcInstance)this._actor).isSitting()) {
            this._actor.broadcastPacket(new CharMoveToLocation(this._actor));
        }
    }

    protected void onEvtArrivedRevalidate() {
        this.onEvtThink();
    }

    protected void onEvtArrivedBlocked(L2CharPosition blocked_at_pos) {
        this.clientStopMoving(blocked_at_pos);
        if (Config.ACTIVATE_POSITION_RECORDER && Universe.getInstance().shouldLog(this._accessor.getActor().getObjectId())) {
            Universe.getInstance().registerObstacle(blocked_at_pos.x, blocked_at_pos.y, blocked_at_pos.z);
            if (this._accessor.getActor() instanceof L2PcInstance) {
                ((L2PcInstance)this._accessor.getActor()).explore();
            }
        }
        if (this.getIntention() == CtrlIntention.AI_INTENTION_MOVE_TO) {
            this.setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
        }
        this.onEvtThink();
    }

    protected void onEvtForgetObject(L2Object object) {
        if (this._target == object) {
            this._target = null;
            if (this.getIntention() == CtrlIntention.AI_INTENTION_INTERACT) {
                this.setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
            } else if (this.getIntention() == CtrlIntention.AI_INTENTION_PICK_UP) {
                this.setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
            }
        }
        if (this._attack_target == object) {
            this.clientStopAutoAttack();
            this._attack_target = null;
            this.setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
        }
        if (this._cast_target == object) {
            this._cast_target = null;
            this.setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
        }
        if (this._follow_target == object) {
            this.clientStopMoving(null);
            this.stopFollow();
            this.setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
        }
        if (this._actor == object) {
            this._target = null;
            this._attack_target = null;
            this._cast_target = null;
            this.stopFollow();
            this.clientStopMoving(null);
            this.changeIntention(CtrlIntention.AI_INTENTION_IDLE, null, null);
        }
    }

    protected void onEvtCancel() {
        this.stopFollow();
        this.onEvtThink();
    }

    protected void onEvtDead() {
        this.stopFollow();
        this.clientNotifyDead();
    }

    protected void onEvtFinishCasting() {
    }

    protected boolean maybeMoveToPawn(L2Object target, int offset) {
        double dist = this._actor.getDistance(target.getX(), target.getY());
        if (dist > (double)(offset + 35)) {
            if (this._follow_target != null) {
                return true;
            }
            if (!this._actor.isRunning()) {
                this._actor.setRunning();
            }
            if (this._actor.isMovementDisabled()) {
                return true;
            }
            this.stopFollow();
            if (target instanceof L2Character && !(target instanceof L2DoorInstance)) {
                this.startFollow((L2Character)target, offset);
            } else {
                this.moveToPawn(target, offset);
            }
            return true;
        }
        if (this._follow_target != null) {
            this.stopFollow();
        }
        this.clientStopMoving(null);
        return false;
    }

    protected boolean checkTargetLostOrDead(L2Character target) {
        if (target == null || target.isAlikeDead()) {
            this.clientStopAutoAttack();
            this.clientStopMoving(null);
            this.setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
            return true;
        }
        return false;
    }

    protected boolean checkTargetLost(L2Object target) {
        if (target == null) {
            this.clientStopAutoAttack();
            this.clientStopMoving(null);
            this.setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
            return true;
        }
        return false;
    }
}

