/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.ai;

import java.util.Random;
import java.util.Vector;
import net.sf.l2j.gameserver.ai.CtrlEvent;
import net.sf.l2j.gameserver.ai.CtrlIntention;
import net.sf.l2j.gameserver.ai.L2AttackableAI;
import net.sf.l2j.gameserver.model.L2Attackable;
import net.sf.l2j.gameserver.model.L2Character;
import net.sf.l2j.gameserver.model.L2ControllableMobInstance;
import net.sf.l2j.gameserver.model.L2DoorInstance;
import net.sf.l2j.gameserver.model.L2FolkInstance;
import net.sf.l2j.gameserver.model.L2NpcInstance;
import net.sf.l2j.gameserver.model.L2Object;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.L2Skill;
import net.sf.l2j.gameserver.model.L2World;
import net.sf.l2j.gameserver.model.MobGroup;

public class L2ControllableMobAI
extends L2AttackableAI {
    public static int AI_IDLE = 1;
    public static int AI_NORMAL = 2;
    public static int AI_FORCEATTACK = 3;
    public static int AI_FOLLOW = 4;
    public static int AI_CAST = 5;
    public static int AI_ATTACK_GROUP = 6;
    public static int FOLLOW_RANGE = 300;
    private int _alternateAI = AI_IDLE;
    private boolean thinking;
    private L2Character forcedTarget;
    private boolean no_move;
    private MobGroup _groupTarget;
    private static final Random _rnd = new Random();

    protected void thinkFollow() {
        L2Attackable me = (L2Attackable)this._actor;
        if (me.getDistance(this.forcedTarget.getX(), this.forcedTarget.getY()) > (double)FOLLOW_RANGE) {
            Random rnd = new Random();
            int signX = rnd.nextInt(2) == 0 ? -1 : 1;
            int signY = rnd.nextInt(2) == 0 ? -1 : 1;
            int randX = rnd.nextInt(FOLLOW_RANGE);
            int randY = rnd.nextInt(FOLLOW_RANGE);
            this.moveTo(this.forcedTarget.getX() + signX * randX, this.forcedTarget.getY() + signY * randY, this.forcedTarget.getZ());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onEvtThink() {
        if (this.thinking || this._actor.isAllSkillsDisabled()) {
            return;
        }
        this.thinking = true;
        try {
            if (this._alternateAI == AI_IDLE) {
                if (this.getIntention() != CtrlIntention.AI_INTENTION_ACTIVE) {
                    this.setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
                }
            } else if (this._alternateAI == AI_FOLLOW) {
                this.thinkFollow();
            } else if (this._alternateAI == AI_CAST) {
                this.thinkCast();
            } else if (this._alternateAI == AI_FORCEATTACK) {
                this.thinkForceAttack();
            } else if (this._alternateAI == AI_ATTACK_GROUP) {
                this.thinkAttackGroup();
            } else if (this.getIntention() == CtrlIntention.AI_INTENTION_ACTIVE) {
                this.thinkActive();
            } else if (this.getIntention() == CtrlIntention.AI_INTENTION_ATTACK) {
                this.thinkAttack();
            }
        }
        finally {
            this.thinking = false;
        }
    }

    protected void thinkCast() {
        L2Attackable npc = (L2Attackable)this._actor;
        if (this._attack_target == null || this._attack_target.isAlikeDead()) {
            this._attack_target = this.findNextRndTarget();
            this.clientStopMoving(null);
        }
        if (this._attack_target == null) {
            return;
        }
        npc.setTarget(this._attack_target);
        L2Skill[] skills = null;
        double dist = 0.0;
        try {
            skills = this._actor.getAllSkills();
            dist = this._actor.getDistance(this._attack_target.getX(), this._attack_target.getY());
        }
        catch (NullPointerException e) {
            _log.warning("Encountered Null Value.");
            e.printStackTrace();
        }
        if (!this._actor.isMuted()) {
            int max_range = 0;
            for (L2Skill sk : skills) {
                if ((double)sk.getCastRange() >= dist && !this._actor.isSkillDisabled(sk.getId()) && this._actor.getCurrentMp() > (double)sk.getMpConsume()) {
                    this._accessor.doCast(sk);
                    return;
                }
                max_range = Math.max(max_range, sk.getCastRange());
            }
            if (!this.no_move) {
                this.moveToPawn(this._attack_target, max_range);
            }
            return;
        }
    }

    protected void thinkAttackGroup() {
        if (this.forcedTarget == null || this.forcedTarget.isAlikeDead()) {
            this.forcedTarget = this.findNextGroupTarget();
            this.clientStopMoving(null);
        }
        if (this.forcedTarget == null) {
            return;
        }
        L2Skill[] skills = null;
        double dist = 0.0;
        int range = 0;
        int max_range = 0;
        this._actor.setTarget(this.forcedTarget);
        L2ControllableMobInstance theTarget = (L2ControllableMobInstance)this.forcedTarget;
        L2ControllableMobAI ctrlAi = (L2ControllableMobAI)theTarget.getAI();
        ctrlAi.forceAttack(this._actor);
        try {
            skills = this._actor.getAllSkills();
            dist = this._actor.getDistance(this.forcedTarget.getX(), this.forcedTarget.getY());
            max_range = range = this._actor.getPhysicalAttackRange();
        }
        catch (NullPointerException e) {
            _log.warning("Encountered Null Value.");
            e.printStackTrace();
        }
        if (!this._actor.isMuted() && dist > (double)(range + 20)) {
            for (L2Skill sk : skills) {
                if ((double)sk.getCastRange() >= dist && !this._actor.isSkillDisabled(sk.getId()) && this._actor.getCurrentMp() > (double)sk.getMpConsume()) {
                    this._accessor.doCast(sk);
                    return;
                }
                max_range = Math.max(max_range, sk.getCastRange());
            }
            if (!this.no_move) {
                this.moveToPawn(this.forcedTarget, range);
            }
            return;
        }
        this._accessor.doAttack(this.forcedTarget);
    }

    protected void thinkForceAttack() {
        if (this.forcedTarget == null || this.forcedTarget.isAlikeDead()) {
            this.clientStopMoving(null);
            this.setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
            this.setAlternateAI(AI_IDLE);
        }
        L2Skill[] skills = null;
        double dist = 0.0;
        int range = 0;
        int max_range = 0;
        try {
            this._actor.setTarget(this.forcedTarget);
            skills = this._actor.getAllSkills();
            dist = this._actor.getDistance(this.forcedTarget.getX(), this.forcedTarget.getY());
            max_range = range = this._actor.getPhysicalAttackRange();
        }
        catch (NullPointerException e) {
            _log.warning("Encountered Null Value.");
            e.printStackTrace();
        }
        if (!this._actor.isMuted() && dist > (double)(range + 20)) {
            for (L2Skill sk : skills) {
                if ((double)sk.getCastRange() >= dist && !this._actor.isSkillDisabled(sk.getId()) && this._actor.getCurrentMp() > (double)sk.getMpConsume()) {
                    this._accessor.doCast(sk);
                    return;
                }
                max_range = Math.max(max_range, sk.getCastRange());
            }
            if (!this.no_move) {
                this.moveToPawn(this.forcedTarget, this._actor.getPhysicalAttackRange());
            }
            return;
        }
        this._accessor.doAttack(this.forcedTarget);
    }

    protected void thinkAttack() {
        if (this._attack_target == null || this._attack_target.isAlikeDead()) {
            L2Attackable npc;
            int hate;
            if (this._attack_target != null && (hate = (npc = (L2Attackable)this._actor).getHating(this._attack_target)) > 0) {
                npc.addDamageHate(this._attack_target, 0, -hate);
            }
            this._attack_target = null;
            this.clientStopMoving(null);
            this.setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
        } else {
            if (((L2NpcInstance)this._actor).getFactionId() != null) {
                String faction_id = ((L2NpcInstance)this._actor).getFactionId();
                for (L2Object obj : this._actor.getKnownObjects()) {
                    L2NpcInstance npc;
                    if (!(obj instanceof L2NpcInstance) || faction_id != (npc = (L2NpcInstance)obj).getFactionId() || !(this._actor.getDistance(npc.getX(), npc.getY()) < (double)npc.getFactionRange()) || Math.abs(this._attack_target.getZ() - npc.getZ()) >= 200) continue;
                    npc.getAI().notifyEvent(CtrlEvent.EVT_AGGRESSION, this._attack_target, 1);
                }
            }
            L2Skill[] skills = null;
            double dist = 0.0;
            int range = 0;
            int max_range = 0;
            try {
                this._actor.setTarget(this._attack_target);
                skills = this._actor.getAllSkills();
                dist = this._actor.getDistance(this._attack_target.getX(), this._attack_target.getY());
                max_range = range = this._actor.getPhysicalAttackRange();
            }
            catch (NullPointerException e) {
                _log.warning("Encountered Null Value.");
                e.printStackTrace();
            }
            if (!this._actor.isMuted() && dist > (double)(range + 20)) {
                for (L2Skill sk : skills) {
                    if ((double)sk.getCastRange() >= dist && !this._actor.isSkillDisabled(sk.getId()) && this._actor.getCurrentMp() > (double)sk.getMpConsume()) {
                        this._accessor.doCast(sk);
                        return;
                    }
                    max_range = Math.max(max_range, sk.getCastRange());
                }
                this.moveToPawn(this._attack_target, range);
                return;
            }
            L2Character hated = this._actor.isConfused() ? this._attack_target : this.findNextRndTarget();
            if (hated == null) {
                this.setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
                return;
            }
            if (hated != this._attack_target) {
                this._attack_target = hated;
            }
            if (!this._actor.isMuted() && skills.length > 0 && _rnd.nextInt(5) == 3) {
                for (L2Skill sk : skills) {
                    if (!((double)sk.getCastRange() >= dist) || this._actor.isSkillDisabled(sk.getId()) || !(this._actor.getCurrentMp() < (double)sk.getMpConsume())) continue;
                    this._accessor.doCast(sk);
                    return;
                }
            }
            this._accessor.doAttack(this._attack_target);
        }
    }

    private void thinkActive() {
        this._attack_target = this.findNextRndTarget();
        L2Character hated = this._actor.isConfused() ? this._attack_target : this._attack_target;
        if (hated != null) {
            this._actor.setRunning();
            this.setIntention(CtrlIntention.AI_INTENTION_ATTACK, hated);
        }
    }

    private boolean autoAttackCondition(L2Character target) {
        L2Attackable me = (L2Attackable)this._actor;
        if (target instanceof L2FolkInstance || target instanceof L2DoorInstance) {
            return false;
        }
        if (target.isAlikeDead() || me.getDistance(target.getX(), target.getY()) > (double)me.getAggroRange() || Math.abs(this._actor.getZ() - target.getZ()) > 100) {
            return false;
        }
        if (target instanceof L2PcInstance && (((L2PcInstance)target).isInvul() || ((L2PcInstance)target).isSilentMoving())) {
            return false;
        }
        if (target instanceof L2NpcInstance) {
            return false;
        }
        return me.isAggressive();
    }

    private L2Character findNextRndTarget() {
        L2Object[] objects;
        Vector<L2Character> potentialTarget = new Vector<L2Character>();
        for (L2Object obj : objects = L2World.getInstance().getVisibleObjects(this._actor, ((L2NpcInstance)this._actor).getAggroRange())) {
            L2Character target;
            if (!(obj instanceof L2Character) || !this.autoAttackCondition(target = (L2Character)obj)) continue;
            potentialTarget.add(target);
        }
        if (potentialTarget.size() == 0) {
            return null;
        }
        Random rnd = new Random();
        int choice = rnd.nextInt(potentialTarget.size());
        L2Character target = (L2Character)potentialTarget.get(choice);
        return target;
    }

    private L2ControllableMobInstance findNextGroupTarget() {
        return this._groupTarget.getAMob();
    }

    public L2ControllableMobAI(L2Character.AIAccessor accessor) {
        super(accessor);
    }

    public int getAlternateAI() {
        return this._alternateAI;
    }

    public void setAlternateAI(int _alternateai) {
        this._alternateAI = _alternateai;
    }

    public void forceAttack(L2Character target) {
        this.setAlternateAI(AI_FORCEATTACK);
        this.forcedTarget = target;
    }

    public void forceAttackGroup(MobGroup group) {
        this.forcedTarget = null;
        this._groupTarget = group;
        this.setAlternateAI(AI_ATTACK_GROUP);
    }

    public void stop() {
        this.setAlternateAI(AI_IDLE);
        this.clientStopMoving(null);
    }

    public void move(int x, int y, int z) {
        this.moveTo(x, y, z);
    }

    public void follow(L2Character target) {
        this.setAlternateAI(AI_FOLLOW);
        this.forcedTarget = target;
    }

    public boolean isNoMove() {
        return this.no_move;
    }

    public void setNoMove(boolean no_move) {
        this.no_move = no_move;
    }
}

