/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.ai;

import java.util.Stack;
import net.sf.l2j.gameserver.ai.CtrlIntention;
import net.sf.l2j.gameserver.ai.L2CharacterAI;
import net.sf.l2j.gameserver.model.L2Character;
import net.sf.l2j.gameserver.model.L2Object;
import net.sf.l2j.gameserver.model.L2PcInstance;

public class L2PlayerAI
extends L2CharacterAI {
    private boolean thinking;
    private Stack<IntentionCommand> _interuptedIntentions = new Stack();

    public L2PlayerAI(L2Character.AIAccessor accessor) {
        super(accessor);
    }

    void changeIntention(CtrlIntention intention, Object arg0, Object arg1) {
        if (intention != CtrlIntention.AI_INTENTION_CAST) {
            super.changeIntention(intention, arg0, arg1);
            return;
        }
        if (intention == this._intention && arg0 == this._intention_arg0 && arg1 == this._intention_arg1) {
            super.changeIntention(intention, arg0, arg1);
            return;
        }
        this._interuptedIntentions.push(new IntentionCommand(this._intention, this._intention_arg0, this._intention_arg1));
        super.changeIntention(intention, arg0, arg1);
    }

    protected void onEvtFinishCasting() {
        if (this._skill.isOffensive()) {
            this._interuptedIntentions.clear();
        }
        if (this.getIntention() == CtrlIntention.AI_INTENTION_CAST) {
            this.setIntention(CtrlIntention.AI_INTENTION_IDLE);
            if (!this._interuptedIntentions.isEmpty()) {
                IntentionCommand cmd = this._interuptedIntentions.pop();
                this.setIntention(cmd._intention, cmd._arg0, cmd._arg1);
            }
        }
    }

    protected void onIntentionRest() {
        if (this.getIntention() != CtrlIntention.AI_INTENTION_REST) {
            this.changeIntention(CtrlIntention.AI_INTENTION_REST, null, null);
            this._target = null;
            this._attack_target = null;
            this.clientStopAutoAttack();
            this.clientStopMoving(null);
            this.clientSitDown();
        }
    }

    protected void onIntentionActive() {
        this.setIntention(CtrlIntention.AI_INTENTION_IDLE);
    }

    private void thinkAttack() {
        if (this.checkTargetLostOrDead(this._attack_target)) {
            this._attack_target = null;
            return;
        }
        if (this.maybeMoveToPawn(this._attack_target, this._actor.getPhysicalAttackRange())) {
            return;
        }
        this.clientStartAutoAttack();
        this._accessor.doAttack(this._attack_target);
    }

    private void thinkCast() {
        if (this.checkTargetLost(this._cast_target)) {
            this._cast_target = null;
            return;
        }
        if (this.maybeMoveToPawn(this._cast_target, this._actor.getMagicalAttackRange(this._skill))) {
            return;
        }
        L2Object oldTarget = this._actor.getTarget();
        this.clientStopMoving(null);
        if (oldTarget != null) {
            this._actor.setTarget(this._cast_target);
            this._accessor.doCast(this._skill);
            this._actor.setTarget(oldTarget);
        } else {
            this._accessor.doCast(this._skill);
        }
    }

    private void thinkPickUp() {
        if (this._actor.isAllSkillsDisabled()) {
            return;
        }
        if (this.checkTargetLost(this._target)) {
            return;
        }
        if (this.maybeMoveToPawn(this._target, 36)) {
            return;
        }
        this.setIntention(CtrlIntention.AI_INTENTION_IDLE);
        ((L2PcInstance.AIAccessor)this._accessor).doPickupItem(this._target);
    }

    private void thinkInteract() {
        if (this._actor.isAllSkillsDisabled()) {
            return;
        }
        if (this.checkTargetLost(this._target)) {
            return;
        }
        if (this.maybeMoveToPawn(this._target, 36)) {
            return;
        }
        ((L2PcInstance.AIAccessor)this._accessor).doInteract((L2Character)this._target);
        this.setIntention(CtrlIntention.AI_INTENTION_IDLE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onEvtThink() {
        if (this.thinking || this._actor.isAllSkillsDisabled()) {
            return;
        }
        this.thinking = true;
        try {
            if (this.getIntention() == CtrlIntention.AI_INTENTION_ATTACK) {
                this.thinkAttack();
            } else if (this.getIntention() == CtrlIntention.AI_INTENTION_CAST) {
                this.thinkCast();
            } else if (this.getIntention() == CtrlIntention.AI_INTENTION_PICK_UP) {
                this.thinkPickUp();
            } else if (this.getIntention() == CtrlIntention.AI_INTENTION_INTERACT) {
                this.thinkInteract();
            }
        }
        finally {
            this.thinking = false;
        }
    }

    class IntentionCommand {
        protected CtrlIntention _intention;
        protected Object _arg0;
        protected Object _arg1;

        protected IntentionCommand(CtrlIntention intention, Object arg0, Object arg1) {
            this._intention = intention;
            this._arg0 = arg0;
            this._arg1 = arg1;
        }
    }
}

