/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.ai;

import java.util.Random;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.ClientScheduler;
import net.sf.l2j.gameserver.GameTimeController;
import net.sf.l2j.gameserver.ai.CtrlEvent;
import net.sf.l2j.gameserver.ai.CtrlIntention;
import net.sf.l2j.gameserver.ai.L2CharacterAI;
import net.sf.l2j.gameserver.model.L2Attackable;
import net.sf.l2j.gameserver.model.L2Character;
import net.sf.l2j.gameserver.model.L2DoorInstance;
import net.sf.l2j.gameserver.model.L2Effect;
import net.sf.l2j.gameserver.model.L2FolkInstance;
import net.sf.l2j.gameserver.model.L2MonsterInstance;
import net.sf.l2j.gameserver.model.L2NpcInstance;
import net.sf.l2j.gameserver.model.L2Object;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.L2SiegeGuardInstance;
import net.sf.l2j.gameserver.model.L2Skill;
import net.sf.l2j.gameserver.model.L2World;

public class L2SiegeGuardAI
extends L2CharacterAI
implements Runnable {
    protected static final Logger _log = Logger.getLogger(L2SiegeGuardAI.class.getName());
    private static final int RANDOM_WALK_RATE = 100;
    private static final int MAX_ATTACK_TIMEOUT = 300;
    private static final Random _rnd = new Random();
    private Future aiTask;
    private int _attack_timeout = Integer.MAX_VALUE;
    private int _globalAggro = -10;
    private boolean thinking;

    public L2SiegeGuardAI(L2Character.AIAccessor accessor) {
        super(accessor);
    }

    public void run() {
        this.onEvtThink();
    }

    private boolean autoAttackCondition(L2Character target) {
        L2Attackable me = (L2Attackable)this._actor;
        if (target instanceof L2FolkInstance || target instanceof L2DoorInstance) {
            return false;
        }
        if (target.isAlikeDead() || me.getDistance(target.getX(), target.getY()) > (double)me.getAggroRange() || Math.abs(this._actor.getZ() - target.getZ()) > 1000) {
            return false;
        }
        if (target instanceof L2PcInstance && (((L2PcInstance)target).isInvul() || ((L2PcInstance)target).isSilentMoving() && me.getDistance(target.getX(), target.getY()) > 100.0)) {
            return false;
        }
        if (target instanceof L2PcInstance) {
            return this._actor.isAutoAttackable((L2PcInstance)target);
        }
        return false;
    }

    synchronized void changeIntention(CtrlIntention intention, Object arg0, Object arg1) {
        if (intention == CtrlIntention.AI_INTENTION_IDLE || intention == CtrlIntention.AI_INTENTION_ACTIVE) {
            L2Attackable npc;
            if (!this._actor.isAlikeDead() && (npc = (L2Attackable)this._actor).getKnownPlayers() != null && !npc.getKnownPlayers().isEmpty()) {
                intention = CtrlIntention.AI_INTENTION_ACTIVE;
            }
            if (intention == CtrlIntention.AI_INTENTION_IDLE) {
                super.changeIntention(CtrlIntention.AI_INTENTION_IDLE, null, null);
                if (this.aiTask != null) {
                    this.aiTask.cancel(true);
                    this.aiTask = null;
                }
                this._accessor.detachAI();
                return;
            }
        }
        super.changeIntention(intention, arg0, arg1);
        if (this.aiTask == null) {
            this.aiTask = ClientScheduler.getInstance().scheduleLowAtFixedRate(this, 1000L, 1000L);
        }
    }

    protected void onIntentionAttack(L2Character target) {
        this._attack_timeout = 300 + GameTimeController.getGameTicks();
        if (this._actor.getTarget() != null) {
            super.onIntentionAttack(target);
        }
    }

    private void thinkActive() {
        L2Attackable npc = (L2Attackable)this._actor;
        if (this._globalAggro != 0) {
            this._globalAggro = this._globalAggro < 0 ? ++this._globalAggro : --this._globalAggro;
        }
        if (this._globalAggro >= 0) {
            L2Object[] objects;
            for (L2Object obj : objects = L2World.getInstance().getVisibleObjects(this._actor, ((L2NpcInstance)this._actor).getAggroRange())) {
                int hating;
                L2Character target;
                if (!(obj instanceof L2Character) || !this.autoAttackCondition(target = (L2Character)obj) || (hating = npc.getHating(target)) != 0) continue;
                npc.addDamageHate(target, 0, 1);
            }
            L2Character hated = this._actor.isConfused() ? this._attack_target : npc.getMostHated();
            if (hated != null) {
                int aggro = npc.getHating(hated);
                if (aggro + this._globalAggro > 0) {
                    if (!this._actor.isRunning()) {
                        this._actor.setRunning();
                    }
                    this.setIntention(CtrlIntention.AI_INTENTION_ATTACK, hated);
                }
                return;
            }
        }
        ((L2SiegeGuardInstance)this._actor).returnHome();
    }

    private void thinkAttack() {
        if (this._attack_timeout < GameTimeController.getGameTicks() && this._actor.isRunning()) {
            this._actor.setWalking();
            this._attack_timeout = 300 + GameTimeController.getGameTicks();
        }
        if (this._attack_target == null || this._attack_target.isAlikeDead() || this._attack_timeout < GameTimeController.getGameTicks()) {
            L2Attackable npc;
            int hate;
            if (this._attack_target != null && (hate = (npc = (L2Attackable)this._actor).getHating(this._attack_target)) > 0) {
                npc.addDamageHate(this._attack_target, 0, -hate);
            }
            this._attack_timeout = Integer.MAX_VALUE;
            this._attack_target = null;
            this.clientStopMoving(null);
            this.setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
        } else {
            if (((L2NpcInstance)this._actor).getFactionId() != null) {
                String faction_id = ((L2NpcInstance)this._actor).getFactionId();
                for (L2Object obj : this._actor.getKnownObjects()) {
                    L2NpcInstance npc;
                    if (!(obj instanceof L2NpcInstance) || faction_id != (npc = (L2NpcInstance)obj).getFactionId() || !(this._actor.getDistance(npc.getX(), npc.getY()) < (double)npc.getFactionRange()) || Math.abs(this._attack_target.getZ() - npc.getZ()) >= 600 || npc.getAI() == null) continue;
                    npc.getAI().notifyEvent(CtrlEvent.EVT_AGGRESSION, this._attack_target, 1);
                }
            }
            L2Skill[] skills = null;
            double dist = 0.0;
            int range = 0;
            try {
                this._actor.setTarget(this._attack_target);
                skills = this._actor.getAllSkills();
                dist = this._actor.getDistance(this._attack_target.getX(), this._attack_target.getY());
                range = this._actor.getPhysicalAttackRange();
            }
            catch (NullPointerException e) {
                _log.warning("AttackableAI: Attack target is NULL.");
            }
            if (!this._actor.isMuted() && dist > (double)(range + 20)) {
                if (!Config.ALT_GAME_MOB_ATTACK_AI || this._actor instanceof L2MonsterInstance && _rnd.nextInt(100) <= 5) {
                    for (L2Skill sk : skills) {
                        if (sk.getSkillType() != L2Skill.SkillType.BUFF && sk.getSkillType() != L2Skill.SkillType.HEAL && (!(dist >= (double)(sk.getCastRange() / 3)) || !(dist <= (double)sk.getCastRange()) || sk.getCastRange() <= 70) || this._actor.isSkillDisabled(sk.getId()) || !(this._actor.getCurrentMp() >= (double)sk.getMpConsume()) || sk.isPassive()) continue;
                        L2Object OldTarget = this._actor.getTarget();
                        if (sk.getSkillType() == L2Skill.SkillType.BUFF || sk.getSkillType() == L2Skill.SkillType.HEAL) {
                            boolean useSkillSelf = true;
                            if (sk.getSkillType() == L2Skill.SkillType.HEAL && this._actor.getCurrentHp() > (double)((int)((double)this._actor.getMaxHp() / 1.5))) {
                                useSkillSelf = false;
                                break;
                            }
                            if (sk.getSkillType() == L2Skill.SkillType.BUFF) {
                                L2Effect[] effects = this._actor.getAllEffects();
                                for (int i = 0; effects != null && i < effects.length; ++i) {
                                    L2Effect effect = effects[i];
                                    if (effect.getSkill() != sk) continue;
                                    useSkillSelf = false;
                                    break;
                                }
                            }
                            if (useSkillSelf) {
                                this._actor.setTarget(this._actor);
                            }
                        }
                        this.clientStopMoving(null);
                        this._accessor.doCast(sk);
                        this._actor.setTarget(OldTarget);
                        return;
                    }
                }
                if (!this._actor.isAttackingNow() && this._actor.getRunSpeed() == 0 && this._actor.knowsObject(this._attack_target)) {
                    this._actor.removeKnownObject(this._attack_target);
                    this._actor.setTarget(null);
                } else {
                    L2SiegeGuardInstance sGuard = (L2SiegeGuardInstance)this._actor;
                    double dx = this._actor.getX() - this._attack_target.getX();
                    double dy = this._actor.getY() - this._attack_target.getY();
                    double homeX = this._attack_target.getX() - sGuard.getHomeX();
                    double homeY = this._attack_target.getY() - sGuard.getHomeY();
                    if (dx * dx + dy * dy > 10000.0 && homeX * homeX + homeY * homeY > 1440000.0 && this._actor.knowsObject(this._attack_target)) {
                        this._actor.removeKnownObject(this._attack_target);
                        this._actor.setTarget(null);
                        this.setIntention(CtrlIntention.AI_INTENTION_IDLE);
                    } else {
                        this.moveToPawn(this._attack_target, range);
                    }
                }
                return;
            }
            if (this._actor.isMuted() && dist > (double)(range + 20)) {
                this.moveToPawn(this._attack_target, range);
                return;
            }
            if (dist <= (double)(range + 20)) {
                L2Character hated = this._actor.isConfused() ? this._attack_target : ((L2Attackable)this._actor).getMostHated();
                if (hated == null) {
                    this.setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
                    return;
                }
                if (hated != this._attack_target) {
                    this._attack_target = hated;
                }
                this._attack_timeout = 300 + GameTimeController.getGameTicks();
                if (!this._actor.isMuted() && _rnd.nextInt(100) <= 5) {
                    for (L2Skill sk : skills) {
                        if (!((double)sk.getCastRange() >= dist) || sk.getCastRange() > 70 || sk.isPassive() || !(this._actor.getCurrentMp() >= (double)sk.getMpConsume()) || this._actor.isSkillDisabled(sk.getId())) continue;
                        L2Object OldTarget = this._actor.getTarget();
                        if (sk.getSkillType() == L2Skill.SkillType.BUFF || sk.getSkillType() == L2Skill.SkillType.HEAL) {
                            boolean useSkillSelf = true;
                            if (sk.getSkillType() == L2Skill.SkillType.HEAL && this._actor.getCurrentHp() > (double)((int)((double)this._actor.getMaxHp() / 1.5))) {
                                useSkillSelf = false;
                                break;
                            }
                            if (sk.getSkillType() == L2Skill.SkillType.BUFF) {
                                L2Effect[] effects = this._actor.getAllEffects();
                                for (int i = 0; effects != null && i < effects.length; ++i) {
                                    L2Effect effect = effects[i];
                                    if (effect.getSkill() != sk) continue;
                                    useSkillSelf = false;
                                    break;
                                }
                            }
                            if (useSkillSelf) {
                                this._actor.setTarget(this._actor);
                            }
                        }
                        this.clientStopMoving(null);
                        this._accessor.doCast(sk);
                        this._actor.setTarget(OldTarget);
                        return;
                    }
                }
                this._accessor.doAttack(this._attack_target);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onEvtThink() {
        if (this.thinking || this._actor.isAllSkillsDisabled()) {
            return;
        }
        this.thinking = true;
        try {
            if (this.getIntention() == CtrlIntention.AI_INTENTION_ACTIVE) {
                this.thinkActive();
            } else if (this.getIntention() == CtrlIntention.AI_INTENTION_ATTACK) {
                this.thinkAttack();
            }
        }
        finally {
            this.thinking = false;
        }
    }

    protected void onEvtAttacked(L2Character attacker) {
        this._attack_timeout = 300 + GameTimeController.getGameTicks();
        if (this._globalAggro < 0) {
            this._globalAggro = 0;
        }
        ((L2Attackable)this._actor).addDamageHate(attacker, 0, 1);
        if (!this._actor.isRunning()) {
            this._actor.setRunning();
        }
        if (this.getIntention() != CtrlIntention.AI_INTENTION_ATTACK) {
            this.setIntention(CtrlIntention.AI_INTENTION_ATTACK, attacker);
        }
    }

    protected void onEvtAggression(L2Character target, int aggro) {
        if (target != null) {
            L2Attackable me = (L2Attackable)this._actor;
            me.addDamageHate(target, 0, aggro);
            aggro = me.getHating(target);
            if (aggro <= 0) {
                return;
            }
            if (this.getIntention() != CtrlIntention.AI_INTENTION_ATTACK) {
                double homeY;
                if (!this._actor.isRunning()) {
                    this._actor.setRunning();
                }
                L2SiegeGuardInstance sGuard = (L2SiegeGuardInstance)this._actor;
                double homeX = target.getX() - sGuard.getHomeX();
                if (homeX * homeX + (homeY = (double)(target.getY() - sGuard.getHomeY())) * homeY < 1440000.0) {
                    this.setIntention(CtrlIntention.AI_INTENTION_ATTACK, target);
                }
            }
        } else {
            this._globalAggro += aggro;
        }
    }
}

