/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.clientpackets;

import java.nio.ByteBuffer;
import java.util.logging.Logger;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.ClientThread;
import net.sf.l2j.gameserver.clientpackets.ClientBasePacket;
import net.sf.l2j.gameserver.model.L2Character;
import net.sf.l2j.gameserver.model.L2Object;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.L2World;
import net.sf.l2j.gameserver.serverpackets.ActionFailed;

public class Action
extends ClientBasePacket {
    private static final String ACTION__C__04 = "[C] 04 Action";
    private static Logger _log = Logger.getLogger(Action.class.getName());
    private final int _objectId = this.readD();
    private final int _originX = this.readD();
    private final int _originY = this.readD();
    private final int _originZ = this.readD();
    private final int _actionId = this.readC();

    public Action(ByteBuffer buf, ClientThread client) {
        super(buf, client);
    }

    void runImpl() {
        L2PcInstance activeChar;
        if (Config.DEBUG) {
            _log.fine("Action:" + this._actionId);
        }
        if (Config.DEBUG) {
            _log.fine("oid:" + this._objectId);
        }
        if ((activeChar = this.getClient().getActiveChar()) == null) {
            return;
        }
        L2Object obj = L2World.getInstance().findObject(this._objectId);
        if (obj != null && !activeChar.isAlikeDead() && activeChar.getPrivateStoreType() == 0 && activeChar.getTransactionRequester() == null) {
            switch (this._actionId) {
                case 0: {
                    obj.onAction(activeChar);
                    break;
                }
                case 1: {
                    if (obj instanceof L2Character && ((L2Character)obj).isAlikeDead()) {
                        obj.onAction(activeChar);
                        break;
                    }
                    obj.onActionShift(this.getClient());
                }
            }
        } else {
            _log.warning("object not found, oid " + this._objectId + " or player is dead");
            activeChar.sendPacket(new ActionFailed());
        }
    }

    public String getType() {
        return ACTION__C__04;
    }
}

