/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.clientpackets;

import java.nio.ByteBuffer;
import net.sf.l2j.gameserver.ClientThread;
import net.sf.l2j.gameserver.clientpackets.ClientBasePacket;
import net.sf.l2j.gameserver.model.L2ItemInstance;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.L2TradeList;
import net.sf.l2j.gameserver.serverpackets.SendTradeDone;
import net.sf.l2j.gameserver.serverpackets.SystemMessage;
import net.sf.l2j.gameserver.serverpackets.TradeOtherAdd;
import net.sf.l2j.gameserver.serverpackets.TradeOwnAdd;

public class AddTradeItem
extends ClientBasePacket {
    private static final String _C__16_ADDTRADEITEM = "[C] 16 AddTradeItem";
    private final int _tradeId = this.readD();
    private final int _objectId = this.readD();
    private final int _amount = this.readD();

    public AddTradeItem(ByteBuffer buf, ClientThread client) {
        super(buf, client);
    }

    void runImpl() {
        L2PcInstance player = this.getClient().getActiveChar();
        L2PcInstance requestor = player.getTransactionRequester();
        if (requestor != null && requestor.getTransactionRequester() != null) {
            L2TradeList playerItemList = player.getTradeList();
            player.getTradeList().setConfirmedTrade(false);
            requestor.getTradeList().setConfirmedTrade(false);
            if (playerItemList.getItems().size() > 0) {
                if (!playerItemList.contains(this._objectId)) {
                    L2ItemInstance inst = player.getInventory().getItemByObjectId(this._objectId);
                    int objectId = inst.getObjectId();
                    L2ItemInstance temp = new L2ItemInstance(objectId, inst.getItem());
                    temp.setCount(this._amount);
                    temp.setEnchantLevel(inst.getEnchantLevel());
                    playerItemList.addItem(temp);
                    player.sendPacket(new TradeOwnAdd(player.getInventory().getItemByObjectId(this._objectId), this._amount));
                    requestor.sendPacket(new TradeOtherAdd(player.getInventory().getItemByObjectId(this._objectId), this._amount));
                } else {
                    L2ItemInstance tempTradeItem;
                    int InvItemCount = player.getInventory().getItemByObjectId(this._objectId).getCount();
                    if (InvItemCount != (tempTradeItem = playerItemList.getItem(this._objectId)).getCount()) {
                        if (this._amount + tempTradeItem.getCount() >= InvItemCount) {
                            tempTradeItem.setCount(InvItemCount);
                            player.sendPacket(new TradeOwnAdd(player.getInventory().getItemByObjectId(this._objectId), this._amount));
                            requestor.sendPacket(new TradeOtherAdd(player.getInventory().getItemByObjectId(this._objectId), this._amount));
                        } else {
                            tempTradeItem.setCount(this._amount + tempTradeItem.getCount());
                            player.sendPacket(new TradeOwnAdd(player.getInventory().getItemByObjectId(this._objectId), this._amount));
                            requestor.sendPacket(new TradeOtherAdd(player.getInventory().getItemByObjectId(this._objectId), this._amount));
                        }
                    }
                }
            } else {
                L2ItemInstance temp2 = player.getInventory().getItemByObjectId(this._objectId);
                L2ItemInstance temp = new L2ItemInstance(this._objectId, temp2.getItem());
                temp.setCount(this._amount);
                temp.setEnchantLevel(temp2.getEnchantLevel());
                playerItemList.addItem(temp);
                player.sendPacket(new TradeOwnAdd(temp2, this._amount));
                requestor.sendPacket(new TradeOtherAdd(temp2, this._amount));
            }
        } else {
            player.sendPacket(new SendTradeDone(0));
            SystemMessage msg = new SystemMessage(145);
            player.sendPacket(msg);
            player.setTransactionRequester(null);
            requestor.getTradeList().getItems().clear();
            player.getTradeList().getItems().clear();
        }
    }

    public String getType() {
        return _C__16_ADDTRADEITEM;
    }
}

