/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.clientpackets;

import java.nio.ByteBuffer;
import java.util.logging.Logger;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.ClientThread;
import net.sf.l2j.gameserver.TaskPriority;
import net.sf.l2j.gameserver.clientpackets.ClientBasePacket;
import net.sf.l2j.gameserver.serverpackets.AuthLoginFail;
import net.sf.l2j.gameserver.serverpackets.CharSelectInfo;
import net.sf.l2j.loginserver.LoginController;

public class AuthLogin
extends ClientBasePacket {
    private static final String _C__08_AUTHLOGIN = "[C] 08 AuthLogin";
    private static Logger _log = Logger.getLogger(AuthLogin.class.getName());
    private final String _loginName = this.readS().toLowerCase();
    private final long _key1 = this.readD();
    private final long _key2 = this.readD();

    public AuthLogin(ByteBuffer buf, ClientThread client) {
        super(buf, client);
        while (buf.hasRemaining()) {
            buf.get();
        }
    }

    public TaskPriority getPriority() {
        return TaskPriority.PR_URGENT;
    }

    void runImpl() {
        if (Config.DEBUG) {
            _log.fine("user:" + this._loginName);
            _log.fine("key:" + Long.toHexString(this._key1) + " " + Long.toHexString(this._key2));
        }
        ClientThread client = this.getClient();
        client.setLoginName(this._loginName);
        int sessionKey = LoginController.getInstance().getKeyForAccount(this._loginName);
        if ((long)sessionKey != this._key2) {
            _log.warning("session key is not correct. closing connection");
            this.sendPacket(new AuthLoginFail(1));
        } else {
            LoginController.getInstance().addGameServerLogin(this._loginName, this.getConnection());
            CharSelectInfo cl = new CharSelectInfo(this._loginName, client.getSessionId());
            this.sendPacket(cl);
            client.setSessionId(sessionKey);
            client.setCharSelection(cl.getCharInfo());
        }
    }

    public String getType() {
        return _C__08_AUTHLOGIN;
    }
}

