/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.clientpackets;

import java.nio.ByteBuffer;
import java.util.logging.Logger;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.CharNameTable;
import net.sf.l2j.gameserver.CharTemplateTable;
import net.sf.l2j.gameserver.ClientThread;
import net.sf.l2j.gameserver.IdFactory;
import net.sf.l2j.gameserver.ItemTable;
import net.sf.l2j.gameserver.SkillTable;
import net.sf.l2j.gameserver.SkillTreeTable;
import net.sf.l2j.gameserver.clientpackets.ClientBasePacket;
import net.sf.l2j.gameserver.model.L2ItemInstance;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.L2SkillLearn;
import net.sf.l2j.gameserver.model.L2World;
import net.sf.l2j.gameserver.serverpackets.CharCreateFail;
import net.sf.l2j.gameserver.serverpackets.CharCreateOk;
import net.sf.l2j.gameserver.serverpackets.CharSelectInfo;
import net.sf.l2j.gameserver.templates.L2Item;
import net.sf.l2j.gameserver.templates.L2PcTemplate;

public class CharacterCreate
extends ClientBasePacket {
    private static final String _C__0B_CHARACTERCREATE = "[C] 0B CharacterCreate";
    private static Logger _log = Logger.getLogger(CharacterCreate.class.getName());
    private final String _name = this.readS();
    private final int _race = this.readD();
    private final int _sex = this.readD();
    private final int _classId = this.readD();
    private final int _int = this.readD();
    private final int _str = this.readD();
    private final int _con = this.readD();
    private final int _men = this.readD();
    private final int _dex = this.readD();
    private final int _wit = this.readD();
    private final int _hairStyle = this.readD();
    private final int _hairColor = this.readD();
    private final int _face = this.readD();

    public CharacterCreate(ByteBuffer buf, ClientThread client) {
        super(buf, client);
    }

    void runImpl() {
        if (CharNameTable.getInstance().doesCharNameExist(this._name)) {
            if (Config.DEBUG) {
                _log.fine("charname: " + this._name + " already exists. creation failed.");
            }
            CharCreateFail ccf = new CharCreateFail(CharCreateFail.REASON_NAME_ALREADY_EXISTS);
            this.sendPacket(ccf);
            return;
        }
        if (this._name.length() > 16 || !this.isAlphaNumeric(this._name)) {
            if (Config.DEBUG) {
                _log.fine("charname: " + this._name + " is invalid. creation failed.");
            }
            CharCreateFail ccf = new CharCreateFail(CharCreateFail.REASON_16_ENG_CHARS);
            this.sendPacket(ccf);
            return;
        }
        if (Config.DEBUG) {
            _log.fine("charname: " + this._name + " classId: " + this._classId);
        }
        L2PcTemplate template = CharTemplateTable.getInstance().getTemplate(this._classId, this._sex != 0);
        int objectId = IdFactory.getInstance().getNextId();
        L2PcInstance newChar = L2PcInstance.create(objectId, template, this.getClient().getLoginName(), this._name, this._hairStyle, this._hairColor, this._face);
        newChar.setCurrentHp(template.baseHpMax);
        newChar.setCurrentMp(template.baseMpMax);
        newChar.setMaxLoad(template.baseLoad);
        CharCreateOk cco = new CharCreateOk();
        this.sendPacket(cco);
        this.initNewChar(this.getClient(), newChar);
    }

    private boolean isAlphaNumeric(String text) {
        boolean result = true;
        char[] chars = text.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (Character.isLetterOrDigit(chars[i])) continue;
            result = false;
            break;
        }
        return result;
    }

    private void initNewChar(ClientThread client, L2PcInstance newChar) {
        if (Config.DEBUG) {
            _log.fine("Character init start");
        }
        L2World.getInstance().storeObject(newChar);
        L2PcTemplate template = newChar.getTemplate();
        newChar.addAdena(55);
        newChar.setXYZInvisible(template.spawnX, template.spawnY, template.spawnZ);
        newChar.setTitle("");
        ItemTable itemTable = ItemTable.getInstance();
        L2Item[] items = template.getItems();
        for (int i = 0; i < items.length; ++i) {
            L2ItemInstance item = itemTable.createItem(items[i].getItemId());
            newChar.getInventory().addItem(item);
        }
        L2SkillLearn[] startSkills = SkillTreeTable.getInstance().getAvailableSkills(newChar, newChar.getClassId());
        for (int i = 0; i < startSkills.length; ++i) {
            newChar.addSkill(SkillTable.getInstance().getInfo(startSkills[i].getId(), startSkills[i].getLevel()));
            if (!Config.DEBUG) continue;
            _log.fine("adding starter skill:" + startSkills[i].getId() + " / " + startSkills[i].getLevel());
        }
        ClientThread.saveCharToDisk(newChar);
        newChar.deleteMe();
        CharSelectInfo cl = new CharSelectInfo(client.getLoginName(), client.getSessionId());
        client.getConnection().sendPacket(cl);
        client.setCharSelection(cl.getCharInfo());
        if (Config.DEBUG) {
            _log.fine("Character init end");
        }
    }

    public String getType() {
        return _C__0B_CHARACTERCREATE;
    }
}

