/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.clientpackets;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.LineNumberReader;
import java.nio.ByteBuffer;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.ClientThread;
import net.sf.l2j.gameserver.Connection;
import net.sf.l2j.gameserver.clientpackets.ClientBasePacket;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.serverpackets.CharSelected;

public class CharacterSelected
extends ClientBasePacket {
    private static final String _C__0D_CHARACTERSELECTED = "[C] 0D CharacterSelected";
    private static Logger _log = Logger.getLogger(CharacterSelected.class.getName());
    private final int _charSlot = this.readD();

    public CharacterSelected(ByteBuffer buf, ClientThread client) {
        super(buf, client);
    }

    void runImpl() {
        this.playLogFile(this.getConnection());
        if (Config.DEBUG) {
            _log.fine("selected slot:" + this._charSlot);
        }
        L2PcInstance cha = this.getClient().loadCharFromDisk(this._charSlot);
        this.getClient().setActiveChar(cha);
        CharSelected cs = new CharSelected(cha, this.getClient().getSessionId());
        this.sendPacket(cs);
    }

    private void playLogFile(Connection connection) {
        long diff = 0L;
        long first = -1L;
        try {
            LineNumberReader lnr = new LineNumberReader(new FileReader("playback.dat"));
            String line = null;
            while ((line = lnr.readLine()) != null) {
                byte[] data;
                String temp;
                if (line.length() <= 0 || !line.substring(0, 1).equals("1")) continue;
                String timestamp = line.substring(0, 13);
                long time = Long.parseLong(timestamp);
                if (first == -1L) {
                    long start = System.currentTimeMillis();
                    first = time;
                    diff = start - first;
                }
                String cs = line.substring(14, 15);
                ByteArrayOutputStream bais = new ByteArrayOutputStream();
                while ((temp = lnr.readLine()).length() >= 53) {
                    String bytes = temp.substring(6, 53);
                    StringTokenizer st = new StringTokenizer(bytes);
                    while (st.hasMoreTokens()) {
                        String b = st.nextToken();
                        int number = Integer.parseInt(b, 16);
                        bais.write(number);
                    }
                }
                if (!cs.equals("S")) continue;
                int wait = (int)(time + diff - System.currentTimeMillis());
                if (wait > 0) {
                    if (Config.DEBUG) {
                        _log.fine("waiting" + wait);
                    }
                    Thread.sleep(wait);
                }
                if (Config.DEBUG) {
                    _log.fine("sending:" + time);
                }
                if ((data = bais.toByteArray()).length != 0 || !Config.DEBUG) continue;
                _log.fine("skipping broken data");
            }
        }
        catch (FileNotFoundException f) {
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Error:", e);
        }
    }

    public String getType() {
        return _C__0D_CHARACTERSELECTED;
    }
}

