/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.clientpackets;

import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.BasePacket;
import net.sf.l2j.gameserver.ClientThread;
import net.sf.l2j.gameserver.TaskPriority;
import net.sf.l2j.gameserver.serverpackets.ServerBasePacket;

public abstract class ClientBasePacket
extends BasePacket
implements Runnable {
    private static Logger _log = Logger.getLogger(ClientBasePacket.class.getName());

    protected ClientBasePacket(ByteBuffer buf, ClientThread client) {
        super(client);
        if (Config.DEBUG) {
            _log.fine(this.getType() + " <<< " + client.getLoginName());
        }
        this._buf = buf;
        if (Config.ASSERT) assert (this._buf.position() == 1);
    }

    public TaskPriority getPriority() {
        return TaskPriority.PR_MEDIUM;
    }

    public final void run() {
        try {
            this.runImpl();
        }
        catch (Throwable e) {
            _log.log(Level.SEVERE, "error handling client message " + this.getType(), e);
        }
    }

    abstract void runImpl();

    protected void sendPacket(ServerBasePacket msg) {
        this.getConnection().sendPacket(msg);
    }

    public final int readD() {
        return this._buf.getInt();
    }

    public final int readC() {
        return this._buf.get() & 0xFF;
    }

    public final int readH() {
        return this._buf.getShort() & 0xFFFF;
    }

    public final double readF() {
        return this._buf.getDouble();
    }

    public final String readS() {
        char ch;
        StringBuffer sb = new StringBuffer();
        while ((ch = this._buf.getChar()) != '\u0000') {
            sb.append(ch);
        }
        return sb.toString();
    }

    public final byte[] readB(int length) {
        byte[] result = new byte[length];
        this._buf.get(result);
        return result;
    }
}

