/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.clientpackets;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.logging.Logger;
import net.sf.l2j.Base64;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.Announcements;
import net.sf.l2j.gameserver.ClientThread;
import net.sf.l2j.gameserver.clientpackets.ClientBasePacket;
import net.sf.l2j.gameserver.model.L2Clan;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.quest.Quest;
import net.sf.l2j.gameserver.serverpackets.Die;
import net.sf.l2j.gameserver.serverpackets.ItemList;
import net.sf.l2j.gameserver.serverpackets.PledgeShowMemberListAll;
import net.sf.l2j.gameserver.serverpackets.PledgeStatusChanged;
import net.sf.l2j.gameserver.serverpackets.ShortCutInit;
import net.sf.l2j.gameserver.serverpackets.SystemMessage;
import net.sf.l2j.gameserver.serverpackets.UserInfo;

public class EnterWorld
extends ClientBasePacket {
    private static final String _C__03_ENTERWORLD = "[C] 03 EnterWorld";
    private static Logger _log = Logger.getLogger(EnterWorld.class.getName());

    public EnterWorld(ByteBuffer buf, ClientThread client) {
        super(buf, client);
    }

    void runImpl() {
        L2PcInstance activeChar = this.getClient().getActiveChar();
        activeChar.spawnMe(activeChar.getX(), activeChar.getY(), activeChar.getZ());
        ItemList il = new ItemList(activeChar, false);
        activeChar.sendPacket(il);
        UserInfo ui = new UserInfo(activeChar);
        this.sendPacket(ui);
        activeChar.getMacroses().sendUpdate();
        ShortCutInit sci = new ShortCutInit();
        this.sendPacket(sci);
        SystemMessage sm = new SystemMessage(34);
        this.sendPacket(sm);
        sm = new SystemMessage(614);
        sm.addString(this.getText("VGhpcyBTZXJ2ZXIgaXMgcnVubmluZyBMMko="));
        sm.addString(this.getText("IHZlcnNpb24gMyBkZXYvdW5zdGFibGU="));
        this.sendPacket(sm);
        sm = new SystemMessage(614);
        sm.addString(this.getText("Y3JlYXRlZCBieSBMMkNoZWYgYW5kIHRoZQ=="));
        sm.addString(this.getText("IEwySiB0ZWFtLg=="));
        this.sendPacket(sm);
        sm = new SystemMessage(614);
        sm.addString(this.getText("dmlzaXQgIGwyai5zb3VyY2Vmb3JnZS5uZXQ="));
        sm.addString(this.getText("ICBmb3Igc3VwcG9ydC4="));
        this.sendPacket(sm);
        if (Config.SERVER_VERSION != null) {
            sm = new SystemMessage(614);
            sm.addString(this.getText("TDJKIFNlcnZlciBWZXJzaW9uOg==") + "   " + Config.SERVER_VERSION);
            this.sendPacket(sm);
            sm = new SystemMessage(614);
            sm.addString(this.getText("TDJKIFNlcnZlciBCdWlsZCBEYXRlOg==") + " " + Config.SERVER_BUILD_DATE);
            this.sendPacket(sm);
        }
        Announcements.getInstance().showAnnouncements(activeChar);
        Quest.playerEnter(activeChar);
        this.sendPacket(ui);
        if (activeChar.getClanId() != 0 && activeChar.getClan() != null) {
            this.sendPacket(new PledgeShowMemberListAll(activeChar.getClan(), activeChar));
            this.sendPacket(new PledgeStatusChanged(activeChar.getClan()));
        }
        if (activeChar.isAlikeDead()) {
            activeChar.sendPacket(new Die(activeChar));
        }
        this.notifyClanMembers(activeChar);
        activeChar.setOnlineStatus(true);
    }

    private void notifyClanMembers(L2PcInstance activeChar) {
        L2Clan clan = activeChar.getClan();
        if (clan != null) {
            clan.getClanMember(activeChar.getName()).setPlayerInstance(activeChar);
            SystemMessage msg = new SystemMessage(304);
            msg.addString(activeChar.getName());
            L2PcInstance[] clanMembers = clan.getOnlineMembers(activeChar.getName());
            for (int i = 0; i < clanMembers.length; ++i) {
                clanMembers[i].sendPacket(msg);
            }
        }
    }

    private String getText(String string) {
        try {
            String result = new String(Base64.decode(string), "UTF-8");
            return result;
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public String getType() {
        return _C__03_ENTERWORLD;
    }
}

