/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.clientpackets;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.logging.Logger;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.ClientThread;
import net.sf.l2j.gameserver.ai.CtrlIntention;
import net.sf.l2j.gameserver.clientpackets.ClientBasePacket;
import net.sf.l2j.gameserver.model.L2CharPosition;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.serverpackets.ActionFailed;
import net.sf.l2j.gameserver.templates.L2WeaponType;

public class MoveBackwardToLocation
extends ClientBasePacket {
    private static Logger _log = Logger.getLogger(MoveBackwardToLocation.class.getName());
    private final int _targetX = this.readD();
    private final int _targetY = this.readD();
    private final int _targetZ = this.readD();
    private final int _originX = this.readD();
    private final int _originY = this.readD();
    private final int _originZ = this.readD();
    private int _moveMovement;
    private static final String _C__01_MOVEBACKWARDTOLOC = "[C] 01 MoveBackwardToLoc";

    public MoveBackwardToLocation(ByteBuffer buf, ClientThread client) {
        super(buf, client);
        if (Config.allowL2Walker(client.getActiveChar()) && client.getRevision() == Config.L2WALKER_REVISION) {
            this._moveMovement = 1;
        } else {
            try {
                this._moveMovement = this.readD();
            }
            catch (BufferUnderflowException e) {
                _log.warning("Incompatible client found: L2Walker? " + client.getActiveChar());
            }
        }
    }

    void runImpl() {
        L2PcInstance activeChar = this.getClient().getActiveChar();
        if (activeChar == null) {
            return;
        }
        if (this._moveMovement == 0) {
            activeChar.sendPacket(new ActionFailed());
        } else if (activeChar.isAttackingNow() && activeChar.getActiveWeaponItem().getItemType() == L2WeaponType.BOW) {
            activeChar.sendPacket(new ActionFailed());
        } else {
            if (activeChar.isOutOfControl()) {
                activeChar.sendPacket(new ActionFailed());
                return;
            }
            activeChar.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO, new L2CharPosition(this._targetX, this._targetY, this._targetZ, 0));
        }
    }

    public String getType() {
        return _C__01_MOVEBACKWARDTOLOC;
    }
}

