/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.clientpackets;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.logging.Logger;
import net.sf.l2j.gameserver.ClientThread;
import net.sf.l2j.gameserver.ItemTable;
import net.sf.l2j.gameserver.TradeController;
import net.sf.l2j.gameserver.clientpackets.ClientBasePacket;
import net.sf.l2j.gameserver.model.L2FolkInstance;
import net.sf.l2j.gameserver.model.L2ItemInstance;
import net.sf.l2j.gameserver.model.L2MerchantInstance;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.L2TradeList;
import net.sf.l2j.gameserver.model.L2World;
import net.sf.l2j.gameserver.model.PcInventory;
import net.sf.l2j.gameserver.serverpackets.ActionFailed;
import net.sf.l2j.gameserver.serverpackets.ItemList;
import net.sf.l2j.gameserver.serverpackets.StatusUpdate;
import net.sf.l2j.gameserver.serverpackets.SystemMessage;

public class RequestBuyItem
extends ClientBasePacket {
    private static final String _C__1F_REQUESTBUYITEM = "[C] 1F RequestBuyItem";
    private static Logger _log = Logger.getLogger(RequestBuyItem.class.getName());
    private final int _listId = this.readD();
    private final int _count = this.readD();
    private final int[] _items = new int[this._count * 2];

    public RequestBuyItem(ByteBuffer buf, ClientThread client) {
        super(buf, client);
        for (int i = 0; i < this._count; ++i) {
            int cnt;
            int itemId;
            this._items[i * 2 + 0] = itemId = this.readD();
            this._items[i * 2 + 1] = cnt = this.readD();
        }
    }

    void runImpl() {
        int price;
        int i;
        L2PcInstance activeChar = this.getClient().getActiveChar();
        L2FolkInstance folk = activeChar.getLastFolkNPC();
        if (!(folk instanceof L2MerchantInstance && !(activeChar.getDistance(folk.getX(), folk.getY()) > 150.0) || activeChar.isGM())) {
            return;
        }
        L2MerchantInstance merchant = null;
        if (folk instanceof L2MerchantInstance) {
            merchant = (L2MerchantInstance)folk;
        }
        if (this._listId > 1000000 && merchant.getTemplate().npcId != this._listId - 1000000) {
            this.sendPacket(new ActionFailed());
            return;
        }
        ArrayList<L2ItemInstance> items = new ArrayList<L2ItemInstance>(this._count);
        for (int i2 = 0; i2 < this._count; ++i2) {
            int itemId = this._items[i2 * 2 + 0];
            int cnt = this._items[i2 * 2 + 1];
            L2ItemInstance inst = ItemTable.getInstance().createItem(itemId);
            inst.setCount(cnt);
            items.add(inst);
        }
        double neededMoney = 0.0;
        int finalLoad = activeChar.getCurrentLoad();
        int finalCount = activeChar.getInventory().getSize();
        int needsSpace = 2;
        int weight = 0;
        long currentMoney = activeChar.getAdena();
        for (i = 0; i < items.size(); ++i) {
            int itemId = ((L2ItemInstance)items.get(i)).getItemId();
            int cnt = ((L2ItemInstance)items.get(i)).getCount();
            if (((L2ItemInstance)items.get(i)).getItem().isStackable()) {
                needsSpace = 1;
                if (activeChar.getInventory().getItemByItemId(itemId) != null) {
                    needsSpace = 0;
                }
            }
            if (this._listId < 1000000) {
                L2TradeList list = TradeController.getInstance().getBuyList(this._listId);
                price = list.getPriceForItemId(itemId);
                weight = ((L2ItemInstance)items.get(i)).getItem().getWeight();
                if (price < 0) {
                    _log.warning("ERROR, no price found .. wrong buylist ??");
                    items.remove(i);
                    continue;
                }
            } else {
                L2ItemInstance li = merchant.findLeaseItem(itemId, 0);
                if (li == null || li.getCount() < cnt) {
                    cnt = li.getCount();
                    if (cnt <= 0) {
                        items.remove(i);
                        continue;
                    }
                    ((L2ItemInstance)items.get(i)).setCount(cnt);
                }
                price = li.getPriceToSell();
                weight = li.getItem().getWeight();
            }
            neededMoney += (double)(cnt * price);
            finalLoad += cnt * weight;
            if (needsSpace == 2) {
                finalCount += cnt;
                continue;
            }
            if (needsSpace != 1) continue;
            ++finalCount;
        }
        if (neededMoney > (double)currentMoney || neededMoney < 0.0 || currentMoney <= 0L) {
            SystemMessage sm = new SystemMessage(279);
            this.sendPacket(sm);
            for (L2ItemInstance i3 : items) {
                L2World.getInstance().removeObject(i3);
            }
            return;
        }
        if (finalLoad > activeChar.getMaxLoad()) {
            SystemMessage sm = new SystemMessage(422);
            this.sendPacket(sm);
            for (L2ItemInstance i4 : items) {
                L2World.getInstance().removeObject(i4);
            }
            return;
        }
        if (!activeChar.isGM() && finalCount > PcInventory.MAX_ITEMS || activeChar.isGM() && finalCount > PcInventory.MAX_ITEMS_GM) {
            SystemMessage sm = SystemMessage.sendString("Maximum item count reached in inventory.");
            this.sendPacket(sm);
            for (L2ItemInstance i5 : items) {
                L2World.getInstance().removeObject(i5);
            }
            return;
        }
        activeChar.reduceAdena((int)neededMoney);
        for (i = 0; i < items.size(); ++i) {
            L2ItemInstance item = (L2ItemInstance)items.get(i);
            if (this._listId < 1000000) {
                activeChar.getInventory().addItem(item);
                continue;
            }
            L2ItemInstance li = merchant.findLeaseItem(item.getItemId(), 0);
            if (li == null) continue;
            if (li.getCount() < item.getCount()) {
                item.setCount(li.getCount());
            }
            li.setCount(li.getCount() - item.getCount());
            li.updateDatabase();
            price = item.getCount() + li.getPriceToSell();
            L2ItemInstance la = merchant.getLeaseAdena();
            la.setCount(la.getCount() + price);
            la.updateDatabase();
            activeChar.getInventory().addItem(item);
            item.updateDatabase();
        }
        ItemList il = new ItemList(activeChar, false);
        this.sendPacket(il);
        StatusUpdate su = new StatusUpdate(activeChar.getObjectId());
        su.addAttribute(StatusUpdate.CUR_LOAD, activeChar.getCurrentLoad());
        activeChar.sendPacket(su);
    }

    public String getType() {
        return _C__1F_REQUESTBUYITEM;
    }
}

