/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.clientpackets;

import java.nio.ByteBuffer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.l2j.L2DatabaseFactory;
import net.sf.l2j.gameserver.ClientThread;
import net.sf.l2j.gameserver.clientpackets.ClientBasePacket;
import net.sf.l2j.gameserver.model.L2ItemInstance;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.L2World;
import net.sf.l2j.gameserver.serverpackets.InventoryUpdate;
import net.sf.l2j.gameserver.serverpackets.ItemList;
import net.sf.l2j.gameserver.serverpackets.StatusUpdate;
import net.sf.l2j.gameserver.serverpackets.SystemMessage;

public class RequestDestroyItem
extends ClientBasePacket {
    private static final String _C__59_REQUESTDESTROYITEM = "[C] 59 RequestDestroyItem";
    private static Logger _log = Logger.getLogger(RequestDestroyItem.class.getName());
    private final int _objectId = this.readD();
    private final int _count = this.readD();

    public RequestDestroyItem(ByteBuffer buf, ClientThread client) {
        super(buf, client);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runImpl() {
        int itemId;
        L2PcInstance activeChar = this.getClient().getActiveChar();
        int count = this._count;
        if (this._count == 0) {
            return;
        }
        if (activeChar.getPrivateStoreType() != 0) {
            activeChar.sendPacket(new SystemMessage(1065));
            return;
        }
        L2ItemInstance itemToRemove = activeChar.getInventory().getItemByObjectId(this._objectId);
        if (itemToRemove == null) {
            return;
        }
        if (this._count > itemToRemove.getCount()) {
            count = itemToRemove.getCount();
        }
        if (itemToRemove.isEquipped()) {
            L2ItemInstance[] unequiped = activeChar.getInventory().unEquipItemInSlotAndRecord(itemToRemove.getEquipSlot());
            InventoryUpdate iu = new InventoryUpdate();
            for (int i = 0; i < unequiped.length; ++i) {
                iu.addModifiedItem(unequiped[i]);
            }
            activeChar.sendPacket(iu);
        }
        if ((itemId = itemToRemove.getItemId()) == 2375 || itemId == 3500 || itemId == 3501 || itemId == 3502 || itemId == 4422 || itemId == 4423 || itemId == 4424) {
            int petObjectId = 0;
            Connection con = null;
            try {
                con = L2DatabaseFactory.getInstance().getConnection();
                PreparedStatement statement = con.prepareStatement("SELECT objId FROM pets WHERE item_obj_id=?");
                statement.setInt(1, this._objectId);
                ResultSet rset = statement.executeQuery();
                while (rset.next()) {
                    petObjectId = rset.getInt("objId");
                }
                rset.close();
                statement.close();
                if (activeChar.getPet() != null && activeChar.getPet().getObjectId() == petObjectId) {
                    activeChar.getPet().unSummon(activeChar);
                }
                statement = con.prepareStatement("DELETE FROM pets WHERE item_obj_id=?");
                statement.setInt(1, this._objectId);
                statement.execute();
                statement.close();
            }
            catch (Exception e) {
                _log.log(Level.WARNING, "could not restore pet objectid: ", e);
            }
            finally {
                try {
                    con.close();
                }
                catch (Exception e) {}
            }
        }
        L2ItemInstance removedItem = activeChar.getInventory().destroyItem(this._objectId, count);
        InventoryUpdate iu = new InventoryUpdate();
        if (removedItem.getCount() == 0) {
            iu.addRemovedItem(removedItem);
        } else {
            iu.addModifiedItem(removedItem);
        }
        activeChar.sendPacket(iu);
        ItemList il = new ItemList(activeChar, true);
        this.sendPacket(il);
        StatusUpdate su = new StatusUpdate(activeChar.getObjectId());
        su.addAttribute(StatusUpdate.CUR_LOAD, activeChar.getCurrentLoad());
        activeChar.sendPacket(su);
        activeChar.broadcastUserInfo();
        L2World world = L2World.getInstance();
        world.removeObject(removedItem);
    }

    public String getType() {
        return _C__59_REQUESTDESTROYITEM;
    }
}

