/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.clientpackets;

import java.nio.ByteBuffer;
import java.util.logging.Logger;
import net.sf.l2j.gameserver.ClientThread;
import net.sf.l2j.gameserver.clientpackets.ClientBasePacket;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.L2World;
import net.sf.l2j.gameserver.serverpackets.GMViewCharacterInfo;
import net.sf.l2j.gameserver.serverpackets.GMViewItemList;
import net.sf.l2j.gameserver.serverpackets.GMViewPledgeInfo;
import net.sf.l2j.gameserver.serverpackets.GMViewWarehouseWithdrawList;

public class RequestGMCommand
extends ClientBasePacket {
    private static final String _C__6E_REQUESTGMCOMMAND = "[C] 6e RequestGMCommand";
    static Logger _log = Logger.getLogger(RequestGMCommand.class.getName());
    private final String _targetName = this.readS();
    private final int _command = this.readD();
    private final int _unknown = this.readD();

    public RequestGMCommand(ByteBuffer buf, ClientThread client) {
        super(buf, client);
    }

    void runImpl() {
        L2PcInstance player = L2World.getInstance().getPlayer(this._targetName);
        if (player == null) {
            return;
        }
        switch (this._command) {
            case 1: {
                this.sendPacket(new GMViewCharacterInfo(player));
                break;
            }
            case 2: {
                if (player.getClan() == null) break;
                this.sendPacket(new GMViewPledgeInfo(player.getClan(), player));
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                this.sendPacket(new GMViewItemList(player));
                break;
            }
            case 6: {
                this.sendPacket(new GMViewWarehouseWithdrawList(player));
            }
        }
    }

    public String getType() {
        return _C__6E_REQUESTGMCOMMAND;
    }
}

