/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.clientpackets;

import java.nio.ByteBuffer;
import java.util.logging.Logger;
import net.sf.l2j.gameserver.ClientThread;
import net.sf.l2j.gameserver.clientpackets.ClientBasePacket;
import net.sf.l2j.gameserver.model.L2ItemInstance;
import net.sf.l2j.gameserver.model.PcInventory;
import net.sf.l2j.gameserver.model.PetInventory;
import net.sf.l2j.gameserver.serverpackets.ItemList;
import net.sf.l2j.gameserver.serverpackets.PetInventoryUpdate;

public class RequestGetItemFromPet
extends ClientBasePacket {
    private static final String REQUESTGETITEMFROMPET__C__8C = "[C] 8C RequestGetItemFromPet";
    private static Logger _log = Logger.getLogger(RequestGetItemFromPet.class.getName());
    private final int _objectId = this.readD();
    private final int _amount = this.readD();
    private final int _unknown = this.readD();

    public RequestGetItemFromPet(ByteBuffer buf, ClientThread client) {
        super(buf, client);
    }

    void runImpl() {
        PetInventory petInventory = this.getClient().getActiveChar().getPet().getInventory();
        PcInventory playerInventory = this.getClient().getActiveChar().getInventory();
        L2ItemInstance petItem = petInventory.getItemByObjectId(this._objectId);
        if (petItem == null) {
            _log.warning("item requested from pet, but its not there.");
            return;
        }
        if (petItem.isEquipped()) {
            return;
        }
        if (this._amount >= petItem.getCount()) {
            playerInventory.addItem(petItem);
            petInventory.destroyItem(this._objectId, petItem.getCount());
            PetInventoryUpdate petiu = new PetInventoryUpdate();
            petiu.addRemovedItem(petItem);
            this.sendPacket(petiu);
            ItemList playerUI = new ItemList(this.getClient().getActiveChar(), false);
            this.sendPacket(playerUI);
        } else {
            int total = petItem.getCount();
            L2ItemInstance newPlayerItem = petInventory.dropItem(this._objectId, total);
            PetInventoryUpdate petiu = new PetInventoryUpdate();
            petiu.addModifiedItem(petItem);
            playerInventory.addItem(newPlayerItem);
            ItemList playerUI = new ItemList(this.getClient().getActiveChar(), false);
            this.sendPacket(petiu);
            this.sendPacket(playerUI);
        }
    }

    public String getType() {
        return REQUESTGETITEMFROMPET__C__8C;
    }
}

