/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.clientpackets;

import java.nio.ByteBuffer;
import java.util.logging.Logger;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.ClientThread;
import net.sf.l2j.gameserver.clientpackets.ClientBasePacket;
import net.sf.l2j.gameserver.model.L2Party;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.L2World;
import net.sf.l2j.gameserver.serverpackets.AskJoinParty;
import net.sf.l2j.gameserver.serverpackets.SystemMessage;

public class RequestJoinParty
extends ClientBasePacket {
    private static final String _C__29_REQUESTJOINPARTY = "[C] 29 RequestJoinParty";
    private static Logger _log = Logger.getLogger(RequestJoinParty.class.getName());
    private int _id;
    private String _name = null;
    private final int _itemDistribution;
    private final int revision;

    public RequestJoinParty(ByteBuffer buf, ClientThread client) {
        super(buf, client);
        this.revision = client.getRevision();
        if (this.revision >= 551) {
            this._name = this.readS();
        } else {
            this._id = this.readD();
        }
        this._itemDistribution = this.readD();
    }

    void runImpl() {
        L2PcInstance target = null;
        target = this.revision < 551 ? (L2PcInstance)L2World.getInstance().findObject(this._id) : L2World.getInstance().getPlayer(this._name);
        L2PcInstance requestor = this.getClient().getActiveChar();
        if (requestor.isTransactionInProgress()) {
            SystemMessage msg = new SystemMessage(164);
            requestor.sendPacket(msg);
            if (Config.DEBUG) {
                _log.fine("player already invited someone.");
            }
            return;
        }
        if (target.isInParty()) {
            SystemMessage msg = new SystemMessage(160);
            msg.addString(target.getName());
            requestor.sendPacket(msg);
            return;
        }
        if (target == requestor) {
            SystemMessage msg = new SystemMessage(4);
            msg.addString(target.getName());
            requestor.sendPacket(msg);
            return;
        }
        if (!this.getClient().getActiveChar().isInParty()) {
            this.createNewParty(this.getClient(), this._itemDistribution, target, requestor);
        } else {
            this.addTargetToParty(this.getClient(), this._itemDistribution, target, requestor);
        }
    }

    private void addTargetToParty(ClientThread client, int itemDistribution, L2PcInstance target, L2PcInstance requestor) {
        if (requestor.getParty().getMemberCount() >= 9) {
            requestor.sendPacket(new SystemMessage(155));
            return;
        }
        if (!requestor.getParty().isLeader(requestor)) {
            requestor.sendPacket(new SystemMessage(154));
            return;
        }
        if (target.knowsThePlayer(requestor)) {
            if (!target.isTransactionInProgress()) {
                target.setTransactionRequester(requestor);
                requestor.setTransactionRequester(target);
                AskJoinParty ask = new AskJoinParty(requestor.getName(), itemDistribution);
                target.sendPacket(ask);
                if (Config.DEBUG) {
                    _log.fine("sent out a party invitation to:" + target.getName());
                }
                SystemMessage msg = new SystemMessage(105);
                msg.addString(target.getName());
                requestor.sendPacket(msg);
            } else {
                SystemMessage msg = new SystemMessage(153);
                requestor.sendPacket(msg);
                _log.warning(requestor.getName() + " already received a party invitation");
            }
        } else {
            _log.warning(client.getActiveChar().getName() + " invited someone who doesn't know him.");
        }
    }

    private void createNewParty(ClientThread client, int itemDistribution, L2PcInstance target, L2PcInstance requestor) {
        if (target.knowsThePlayer(requestor)) {
            if (!target.isTransactionInProgress()) {
                requestor.setParty(new L2Party(requestor, itemDistribution));
                target.setTransactionRequester(requestor);
                requestor.setTransactionRequester(target);
                AskJoinParty ask = new AskJoinParty(requestor.getName(), itemDistribution);
                target.sendPacket(ask);
                if (Config.DEBUG) {
                    _log.fine("sent out a party invitation to:" + target.getName());
                }
                SystemMessage msg = new SystemMessage(105);
                msg.addString(target.getName());
                requestor.sendPacket(msg);
            } else {
                SystemMessage msg = new SystemMessage(153);
                msg.addString(target.getName());
                requestor.sendPacket(msg);
                _log.warning(requestor.getName() + " already received a party invitation");
            }
        } else if (target.knowsThePlayer(requestor)) {
            _log.warning(client.getActiveChar().getName() + " invited someone who doesn't know him.");
        }
    }

    public String getType() {
        return _C__29_REQUESTJOINPARTY;
    }
}

