/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.clientpackets;

import java.nio.ByteBuffer;
import java.util.logging.Logger;
import net.sf.l2j.gameserver.ClientThread;
import net.sf.l2j.gameserver.clientpackets.ClientBasePacket;
import net.sf.l2j.gameserver.model.L2Clan;
import net.sf.l2j.gameserver.model.L2ClanMember;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.serverpackets.PledgeShowMemberListDelete;
import net.sf.l2j.gameserver.serverpackets.PledgeShowMemberListDeleteAll;
import net.sf.l2j.gameserver.serverpackets.SystemMessage;

public class RequestOustPledgeMember
extends ClientBasePacket {
    private static final String _C__27_REQUESTOUSTPLEDGEMEMBER = "[C] 27 RequestOustPledgeMember";
    static Logger _log = Logger.getLogger(RequestOustPledgeMember.class.getName());
    private final String _target = this.readS();

    public RequestOustPledgeMember(ByteBuffer buf, ClientThread client) {
        super(buf, client);
    }

    void runImpl() {
        L2PcInstance activeChar = this.getClient().getActiveChar();
        if (!activeChar.isClanLeader()) {
            return;
        }
        L2Clan clan = activeChar.getClan();
        L2ClanMember member = clan.getClanMember(this._target);
        if (member == null) {
            _log.warning("target is not member of the clan");
            return;
        }
        clan.removeClanMember(this._target);
        SystemMessage msg = new SystemMessage(191);
        msg.addString(member.getName());
        clan.broadcastToOnlineMembers(msg);
        clan.broadcastToOnlineMembers(new PledgeShowMemberListDelete(this._target));
        if (member.isOnline()) {
            L2PcInstance player = member.getPlayerInstance();
            player.setClan(null);
            player.setTitle("");
            player.sendPacket(new SystemMessage(199));
            player.broadcastUserInfo();
            player.sendPacket(new PledgeShowMemberListDeleteAll());
        }
    }

    public String getType() {
        return _C__27_REQUESTOUSTPLEDGEMEMBER;
    }
}

