/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.clientpackets;

import java.nio.ByteBuffer;
import java.util.logging.Logger;
import net.sf.l2j.gameserver.ClientScheduler;
import net.sf.l2j.gameserver.ClientThread;
import net.sf.l2j.gameserver.MapRegionTable;
import net.sf.l2j.gameserver.clientpackets.ClientBasePacket;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.L2Siege;
import net.sf.l2j.gameserver.model.L2World;
import net.sf.l2j.gameserver.model.Location;
import net.sf.l2j.gameserver.serverpackets.ActionFailed;
import net.sf.l2j.gameserver.serverpackets.Revive;
import net.sf.l2j.gameserver.serverpackets.SocialAction;
import net.sf.l2j.gameserver.serverpackets.StopMove;
import net.sf.l2j.gameserver.serverpackets.SystemMessage;

public class RequestRestartPoint
extends ClientBasePacket {
    private static final String _C__6d_REQUESTRESTARTPOINT = "[C] 6d RequestRestartPoint";
    private static Logger _log = Logger.getLogger(RequestRestartPoint.class.getName());
    protected int requestedPointType = this.readD();
    protected boolean continuation;

    public RequestRestartPoint(ByteBuffer buf, ClientThread client) {
        super(buf, client);
    }

    void runImpl() {
        L2PcInstance activeChar = this.getClient().getActiveChar();
        if (!this.continuation) {
            if (L2Siege.getSiege() > 0) {
                int theCastle = L2Siege.getSiege() - 1;
                int x1 = L2World.castles[theCastle][0];
                int y1 = L2World.castles[theCastle][1];
                int x2 = L2World.castles[theCastle][2];
                int y2 = L2World.castles[theCastle][3];
                if (activeChar.getX() >= Math.min(x1, x2) && activeChar.getX() <= Math.max(x1, x2) && activeChar.getY() >= Math.min(y1, y2) && activeChar.getY() <= Math.max(y1, y2)) {
                    SystemMessage sm = new SystemMessage(614);
                    if (activeChar.getClan() != null && L2Siege.isAttacker(activeChar.getClan().getClanId())) {
                        ClientScheduler.getInstance().scheduleLow(new DeathTask(activeChar), L2Siege.getAttackerSpawnTime());
                        sm.addString("You will be re-spawned in " + L2Siege.getAttackerSpawnTime() / 1000 + " seconds");
                        activeChar.sendPacket(sm);
                    } else {
                        ClientScheduler.getInstance().scheduleLow(new DeathTask(activeChar), L2Siege.getDefenderSpawnTime());
                        sm.addString("You will be re-spawned in " + L2Siege.getDefenderSpawnTime() / 1000 + " seconds");
                        activeChar.sendPacket(sm);
                    }
                    return;
                }
            }
            Location loc = this.requestedPointType == 4 ? new Location(activeChar.getX(), activeChar.getY(), activeChar.getZ()) : MapRegionTable.getInstance().getClosestTownCords(activeChar);
            this.sendPacket(new ActionFailed());
            activeChar.broadcastPacket(new StopMove(activeChar));
            activeChar.teleToLocation(loc.getX(), loc.getY(), loc.getZ());
            activeChar.setCurrentHpMp(0.6 * (double)activeChar.getMaxHp(), 0.6 * (double)activeChar.getMaxMp());
            this.continuation = true;
            ClientScheduler.getInstance().scheduleLow(this, 2000L);
        } else {
            Revive revive = new Revive(activeChar);
            SocialAction sa = new SocialAction(activeChar.getObjectId(), 15);
            activeChar.broadcastPacket(sa);
            activeChar.sendPacket(sa);
            activeChar.sendPacket(revive);
            activeChar.broadcastPacket(revive);
            activeChar.setTarget(activeChar);
        }
    }

    public String getType() {
        return _C__6d_REQUESTRESTARTPOINT;
    }

    class DeathTask
    implements Runnable {
        L2PcInstance activeChar;

        DeathTask(L2PcInstance _activeChar) {
            this.activeChar = _activeChar;
        }

        public void run() {
            try {
                if (!RequestRestartPoint.this.continuation) {
                    Location loc = RequestRestartPoint.this.requestedPointType == 4 ? new Location(this.activeChar.getX(), this.activeChar.getY(), this.activeChar.getZ()) : MapRegionTable.getInstance().getClosestTownCords(this.activeChar);
                    RequestRestartPoint.this.sendPacket(new ActionFailed());
                    this.activeChar.broadcastPacket(new StopMove(this.activeChar));
                    this.activeChar.teleToLocation(loc.getX(), loc.getY(), loc.getZ());
                    this.activeChar.setCurrentHpMp(0.6 * (double)this.activeChar.getMaxHp(), 0.6 * (double)this.activeChar.getMaxMp());
                    RequestRestartPoint.this.continuation = true;
                    ClientScheduler.getInstance().scheduleLow(this, 2000L);
                } else {
                    Revive revive = new Revive(this.activeChar);
                    SocialAction sa = new SocialAction(this.activeChar.getObjectId(), 15);
                    this.activeChar.broadcastPacket(sa);
                    this.activeChar.sendPacket(sa);
                    this.activeChar.sendPacket(revive);
                    this.activeChar.broadcastPacket(revive);
                    this.activeChar.setTarget(this.activeChar);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

