/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.clientpackets;

import java.nio.ByteBuffer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.l2j.L2DatabaseFactory;
import net.sf.l2j.gameserver.ClientThread;
import net.sf.l2j.gameserver.clientpackets.ClientBasePacket;
import net.sf.l2j.gameserver.model.L2FolkInstance;
import net.sf.l2j.gameserver.model.L2ItemInstance;
import net.sf.l2j.gameserver.model.L2MerchantInstance;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.serverpackets.ActionFailed;
import net.sf.l2j.gameserver.serverpackets.StatusUpdate;

public class RequestSellItem
extends ClientBasePacket {
    private static final String _C__1E_REQUESTSELLITEM = "[C] 1E RequestSellItem";
    private static Logger _log = Logger.getLogger(RequestSellItem.class.getName());
    private final int _listId = this.readD();
    private final int _count = this.readD();
    private final int[] _items = new int[this._count * 3];

    public RequestSellItem(ByteBuffer buf, ClientThread client) {
        super(buf, client);
        for (int i = 0; i < this._count; ++i) {
            int cnt;
            int itemId;
            int objectId;
            this._items[i * 3 + 0] = objectId = this.readD();
            this._items[i * 3 + 1] = itemId = this.readD();
            this._items[i * 3 + 2] = cnt = this.readD();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runImpl() {
        L2PcInstance activeChar = this.getClient().getActiveChar();
        L2FolkInstance folk = activeChar.getLastFolkNPC();
        if (!(folk instanceof L2MerchantInstance && !(activeChar.getDistance(folk.getX(), folk.getY()) > 150.0) || activeChar.isGM())) {
            this.sendPacket(new ActionFailed());
            return;
        }
        L2MerchantInstance merchant = (L2MerchantInstance)folk;
        if (this._listId > 1000000 && merchant.getTemplate().npcId != this._listId - 1000000) {
            this.sendPacket(new ActionFailed());
            return;
        }
        for (int i = 0; i < this._count; ++i) {
            int objectId = this._items[i * 3 + 0];
            int itemId = this._items[i * 3 + 1];
            int cnt = this._items[i * 3 + 2];
            L2ItemInstance item = activeChar.getInventory().getItemByObjectId(objectId);
            if (item == null) continue;
            int price = item.getReferencePrice() * cnt / 2;
            L2ItemInstance li = null;
            L2ItemInstance la = null;
            if (this._listId > 1000000) {
                li = merchant.findLeaseItem(item.getItemId(), item.getEnchantLevel());
                la = merchant.getLeaseAdena();
                if (li == null || la == null || (price = li.getPriceToBuy() * cnt) > la.getCount()) continue;
            }
            if (activeChar.getInventory().getItemByObjectId(objectId).getItemId() != itemId || activeChar.getInventory().getItemByObjectId(objectId).getCount() < cnt || !item.getItem().isSellable() && (this._listId <= 1000000 || item.getItemId() != 57 || merchant.getLeaseHolderId() != activeChar.getObjectId())) continue;
            activeChar.addAdena(price);
            if (itemId == 2375 || itemId == 3500 || itemId == 3501 || itemId == 3502 || itemId == 4422 || itemId == 4423 || itemId == 4424) {
                int petObjectId = 0;
                Connection con = null;
                try {
                    con = L2DatabaseFactory.getInstance().getConnection();
                    PreparedStatement statement = con.prepareStatement("SELECT objId FROM pets WHERE item_obj_id=?");
                    statement.setInt(1, objectId);
                    ResultSet rset = statement.executeQuery();
                    while (rset.next()) {
                        petObjectId = rset.getInt("objId");
                    }
                    rset.close();
                    statement.close();
                    if (activeChar.getPet() != null && activeChar.getPet().getObjectId() == petObjectId) {
                        activeChar.getPet().unSummon(activeChar);
                    }
                    statement = con.prepareStatement("DELETE FROM pets WHERE item_obj_id=?");
                    statement.setInt(1, objectId);
                    statement.execute();
                    statement.close();
                }
                catch (Exception e) {
                    _log.log(Level.WARNING, "could not restore pet objectid:", e);
                }
                finally {
                    try {
                        con.close();
                    }
                    catch (Exception e) {}
                }
            }
            if ((item = activeChar.getInventory().destroyItem(objectId, cnt)) == null || this._listId <= 1000000) continue;
            li.setCount(li.getCount() + cnt);
            li.updateDatabase();
            la.setCount(la.getCount() - price);
            la.updateDatabase();
        }
        StatusUpdate su = new StatusUpdate(activeChar.getObjectId());
        su.addAttribute(StatusUpdate.CUR_LOAD, activeChar.getCurrentLoad());
        activeChar.sendPacket(su);
    }

    public String getType() {
        return _C__1E_REQUESTSELLITEM;
    }
}

