/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.clientpackets;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.ClientThread;
import net.sf.l2j.gameserver.clientpackets.ClientBasePacket;
import net.sf.l2j.gameserver.model.L2Clan;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.serverpackets.SystemMessage;

public class RequestSetPledgeCrest
extends ClientBasePacket {
    private static final String _C__53_REQUESTSETPLEDGECREST = "[C] 53 RequestSetPledgeCrest";
    static Logger _log = Logger.getLogger(RequestSetPledgeCrest.class.getName());
    private final int _length = this.readD();
    private final byte[] _data = this.readB(this._length);

    public RequestSetPledgeCrest(ByteBuffer buf, ClientThread client) {
        super(buf, client);
    }

    void runImpl() {
        L2PcInstance activeChar = this.getClient().getActiveChar();
        L2Clan clan = activeChar.getClan();
        if (activeChar.isClanLeader()) {
            if (clan.getLevel() < 3) {
                SystemMessage sm = new SystemMessage(272);
                activeChar.sendPacket(sm);
                return;
            }
            File crestFile = new File(Config.DATAPACK_ROOT, "data/crests/Pledge_" + clan.getClanId() + ".bmp");
            try {
                FileOutputStream out = new FileOutputStream(crestFile);
                out.write(this._data);
                out.close();
                clan.setHasCrest(true);
                activeChar.broadcastUserInfo();
            }
            catch (IOException e) {
                _log.log(Level.INFO, "Error loading " + crestFile + ":", e);
            }
        }
    }

    public String getType() {
        return _C__53_REQUESTSETPLEDGECREST;
    }
}

