/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.clientpackets;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.logging.Logger;
import net.sf.l2j.gameserver.ClientThread;
import net.sf.l2j.gameserver.ItemTable;
import net.sf.l2j.gameserver.clientpackets.ClientBasePacket;
import net.sf.l2j.gameserver.model.L2Character;
import net.sf.l2j.gameserver.model.L2ItemInstance;
import net.sf.l2j.gameserver.model.L2MerchantInstance;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.L2World;
import net.sf.l2j.gameserver.model.TradeItem;
import net.sf.l2j.gameserver.serverpackets.ActionFailed;
import net.sf.l2j.gameserver.serverpackets.ChangeWaitType;
import net.sf.l2j.gameserver.serverpackets.SystemMessage;

public class SendPrivateStoreBuyList
extends ClientBasePacket {
    private static final String _C__79_SENDPRIVATESTOREBUYLIST = "[C] 79 SendPrivateStoreBuyList";
    private static Logger _log = Logger.getLogger(SendPrivateStoreBuyList.class.getName());
    private final int _sellerID = this.readD();
    private final int _count = this.readD();
    private final int[] _items = new int[this._count * 3];

    public SendPrivateStoreBuyList(ByteBuffer buf, ClientThread client) {
        super(buf, client);
        for (int i = 0; i < this._count; ++i) {
            int price;
            int cnt;
            int objectId;
            this._items[i * 3 + 0] = objectId = this.readD();
            this._items[i * 3 + 1] = cnt = this.readD();
            this._items[i * 3 + 2] = price = this.readD();
        }
    }

    void runImpl() {
        L2World world = L2World.getInstance();
        L2PcInstance buyer = this.getClient().getActiveChar();
        ArrayList<TradeItem> buyerlist = new ArrayList<TradeItem>();
        int cost = 0;
        for (int i = 0; i < this._count; ++i) {
            TradeItem temp = new TradeItem();
            int objectId = this._items[i * 3 + 0];
            int cnt = this._items[i * 3 + 1];
            int price = this._items[i * 3 + 2];
            temp.setObjectId(objectId);
            temp.setCount(cnt);
            temp.setOwnersPrice(price);
            cost += temp.getOwnersPrice() * temp.getCount();
            buyerlist.add(temp);
        }
        if (buyer.getAdena() < cost || this._count <= 0) {
            SystemMessage msg = new SystemMessage(279);
            buyer.sendPacket(msg);
            this.sendPacket(new ActionFailed());
            return;
        }
        L2Character _seller = (L2Character)world.findObject(this._sellerID);
        if (_seller instanceof L2PcInstance) {
            L2PcInstance seller = (L2PcInstance)_seller;
            if (seller.getPrivateStoreType() != 1) {
                this.sendPacket(new ActionFailed());
                return;
            }
            for (TradeItem ti : buyerlist) {
                ti.setItemId(seller.getInventory().getItemByObjectId(ti.getObjectId()).getItemId());
            }
            ArrayList<TradeItem> sellerlist = ((L2PcInstance)_seller).getSellList();
            seller.getTradeList().BuySellItems(buyer, buyerlist, seller, sellerlist);
            if (seller.getSellList().size() == 0) {
                seller.setPrivateStoreType(0);
                seller.sendPacket(new ChangeWaitType(seller, true));
                seller.broadcastPacket(new ChangeWaitType(seller, true));
                seller.broadcastUserInfo();
            }
        } else if (_seller != null) {
            L2MerchantInstance seller = (L2MerchantInstance)_seller;
            L2ItemInstance ladena = seller.getLeaseAdena();
            for (TradeItem ti : buyerlist) {
                L2ItemInstance li = seller.getLeaseItemByObjectId(ti.getObjectId());
                if (li == null) {
                    if (ti.getObjectId() != ladena.getObjectId()) continue;
                    buyer.addAdena(ti.getCount());
                    ladena.setCount(ladena.getCount() - ti.getCount());
                    ladena.updateDatabase();
                    continue;
                }
                int cnt = li.getCount();
                if (cnt < ti.getCount()) {
                    ti.setCount(cnt);
                }
                if (ti.getCount() <= 0) continue;
                L2ItemInstance inst = ItemTable.getInstance().createItem(li.getItemId());
                inst.setCount(ti.getCount());
                inst.setEnchantLevel(li.getEnchantLevel());
                buyer.getInventory().addItem(inst);
                li.setCount(li.getCount() - ti.getCount());
                li.updateDatabase();
                ladena.setCount(ladena.getCount() + ti.getCount() * ti.getOwnersPrice());
                ladena.updateDatabase();
            }
        }
    }

    public String getType() {
        return _C__79_SENDPRIVATESTOREBUYLIST;
    }
}

