/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.clientpackets;

import java.nio.ByteBuffer;
import java.util.logging.Logger;
import net.sf.l2j.gameserver.ClientThread;
import net.sf.l2j.gameserver.ItemTable;
import net.sf.l2j.gameserver.clientpackets.ClientBasePacket;
import net.sf.l2j.gameserver.model.L2FolkInstance;
import net.sf.l2j.gameserver.model.L2ItemInstance;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.Warehouse;
import net.sf.l2j.gameserver.serverpackets.ItemList;
import net.sf.l2j.gameserver.serverpackets.StatusUpdate;
import net.sf.l2j.gameserver.serverpackets.SystemMessage;

public class SendWareHouseDepositList
extends ClientBasePacket {
    private static final String _C__31_SENDWAREHOUSEDEPOSITLIST = "[C] 31 SendWareHouseDepositList";
    private static Logger _log = Logger.getLogger(SendWareHouseDepositList.class.getName());
    private final int _count = this.readD();
    private final int[] _items = new int[this._count * 2];

    public SendWareHouseDepositList(ByteBuffer buf, ClientThread client) {
        super(buf, client);
        for (int i = 0; i < this._count; ++i) {
            int cnt;
            int itemId;
            this._items[i * 2 + 0] = itemId = this.readD();
            this._items[i * 2 + 1] = cnt = this.readD();
        }
    }

    void runImpl() {
        L2PcInstance activeChar = this.getClient().getActiveChar();
        L2FolkInstance warehouse = activeChar.getLastFolkNPC();
        if ((warehouse == null || activeChar.getDistance(warehouse.getX(), warehouse.getY()) > 150.0) && !activeChar.isGM()) {
            return;
        }
        int price = 30;
        int neededMoney = this._count * price;
        int currentMoney = activeChar.getAdena();
        if (neededMoney > currentMoney) {
            SystemMessage sm = new SystemMessage(279);
            this.sendPacket(sm);
            return;
        }
        L2ItemInstance[] items = new L2ItemInstance[this._count];
        for (int i = 0; i < this._count; ++i) {
            int itemId = this._items[i * 2 + 0];
            int cnt = this._items[i * 2 + 1];
            L2ItemInstance inst = ItemTable.getInstance().createItem(itemId);
            inst.setCount(cnt);
            items[i] = inst;
        }
        neededMoney = 0;
        Warehouse warehouse2 = activeChar.isUsingClanWarehouse() ? activeChar.getClan().getWarehouse() : activeChar.getWarehouse();
        for (int i = 0; i < items.length; ++i) {
            L2ItemInstance found = activeChar.getInventory().findItemByItemId(items[i].getItemId());
            if (found == null) continue;
            int realCount = items[i].getCount();
            if (realCount > found.getCount()) {
                realCount = found.getCount();
            }
            if (items[i].getItemId() == 57) {
                activeChar.reduceAdena(realCount);
            } else {
                L2ItemInstance old = activeChar.getInventory().destroyItemByItemId(items[i].getItemId(), realCount);
                items[i].setEnchantLevel(old.getEnchantLevel());
                items[i].setPriceToBuy(old.getPriceToBuy());
                items[i].setPriceToSell(old.getPriceToSell());
            }
            items[i].setCount(realCount);
            warehouse2.addItem(items[i]);
            if (items[i].getItemId() == 57) continue;
            neededMoney += price;
        }
        activeChar.reduceAdena(neededMoney);
        ItemList il = new ItemList(activeChar, false);
        this.sendPacket(il);
        StatusUpdate su = new StatusUpdate(activeChar.getObjectId());
        su.addAttribute(StatusUpdate.CUR_LOAD, activeChar.getCurrentLoad());
        activeChar.sendPacket(su);
    }

    public String getType() {
        return _C__31_SENDWAREHOUSEDEPOSITLIST;
    }
}

