/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.clientpackets;

import java.nio.ByteBuffer;
import java.util.logging.Logger;
import net.sf.l2j.gameserver.ClientThread;
import net.sf.l2j.gameserver.ItemTable;
import net.sf.l2j.gameserver.clientpackets.ClientBasePacket;
import net.sf.l2j.gameserver.model.L2FolkInstance;
import net.sf.l2j.gameserver.model.L2ItemInstance;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.L2World;
import net.sf.l2j.gameserver.model.PcInventory;
import net.sf.l2j.gameserver.model.Warehouse;
import net.sf.l2j.gameserver.serverpackets.ItemList;
import net.sf.l2j.gameserver.serverpackets.StatusUpdate;
import net.sf.l2j.gameserver.serverpackets.SystemMessage;

public class SendWareHouseWithDrawList
extends ClientBasePacket {
    private static final String _C__32_SENDWAREHOUSEWITHDRAWLIST = "[C] 32 SendWareHouseWithDrawList";
    private static Logger _log = Logger.getLogger(SendWareHouseWithDrawList.class.getName());
    private final int _count = this.readD();
    private final int[] _items = new int[this._count * 2];

    public SendWareHouseWithDrawList(ByteBuffer buf, ClientThread client) {
        super(buf, client);
        for (int i = 0; i < this._count; ++i) {
            int cnt;
            int itemId;
            this._items[i * 2 + 0] = itemId = this.readD();
            this._items[i * 2 + 1] = cnt = this.readD();
        }
    }

    void runImpl() {
        int i;
        L2PcInstance activeChar = this.getClient().getActiveChar();
        L2FolkInstance warehouse = activeChar.getLastFolkNPC();
        if ((warehouse == null || activeChar.getDistance(warehouse.getX(), warehouse.getY()) > 150.0) && !activeChar.isGM()) {
            return;
        }
        if (activeChar.isUsingClanWarehouse() && !activeChar.isClanLeader()) {
            return;
        }
        int weight = 0;
        boolean needsSpace = true;
        int finalCount = activeChar.getInventory().getSize();
        L2ItemInstance[] items = new L2ItemInstance[this._count];
        for (i = 0; i < this._count; ++i) {
            int itemId = this._items[i * 2 + 0];
            int count = this._items[i * 2 + 1];
            L2ItemInstance inst = ItemTable.getInstance().createItem(itemId);
            inst.setCount(count);
            items[i] = inst;
            weight += items[i].getItem().getWeight() * count;
            if (inst.getItem().isStackable() && activeChar.getInventory().getItemByItemId(itemId) != null) {
                needsSpace = false;
            }
            if (!needsSpace) continue;
            if (inst.getItem().isStackable()) {
                ++finalCount;
                continue;
            }
            finalCount += count;
        }
        if (!activeChar.isGM() && finalCount > PcInventory.MAX_ITEMS || activeChar.isGM() && finalCount > PcInventory.MAX_ITEMS_GM) {
            for (i = 0; i < items.length; ++i) {
                L2World.getInstance().removeObject(items[i]);
            }
            SystemMessage sm = SystemMessage.sendString("Maximum item count reached in inventory.");
            activeChar.sendPacket(sm);
            return;
        }
        if (activeChar.getMaxLoad() - activeChar.getCurrentLoad() >= weight) {
            Warehouse warehouse2 = activeChar.isUsingClanWarehouse() ? activeChar.getClan().getWarehouse() : activeChar.getWarehouse();
            for (int i2 = 0; i2 < items.length; ++i2) {
                L2ItemInstance old = warehouse2.destroyItem(items[i2].getItemId(), items[i2].getCount());
                items[i2].setEnchantLevel(old.getEnchantLevel());
                items[i2].setPriceToBuy(old.getPriceToBuy());
                items[i2].setPriceToSell(old.getPriceToSell());
                activeChar.getInventory().addItem(items[i2]);
            }
            StatusUpdate su = new StatusUpdate(activeChar.getObjectId());
            su.addAttribute(StatusUpdate.CUR_LOAD, activeChar.getCurrentLoad());
            activeChar.sendPacket(su);
            ItemList il = new ItemList(activeChar, false);
            activeChar.sendPacket(il);
        } else {
            for (i = 0; i < items.length; ++i) {
                L2World.getInstance().removeObject(items[i]);
            }
            SystemMessage sm = new SystemMessage(422);
            activeChar.sendPacket(sm);
        }
    }

    public String getType() {
        return _C__32_SENDWAREHOUSEWITHDRAWLIST;
    }
}

