/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.clientpackets;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.logging.Logger;
import net.sf.l2j.gameserver.ClientThread;
import net.sf.l2j.gameserver.clientpackets.ClientBasePacket;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.TradeItem;
import net.sf.l2j.gameserver.serverpackets.ChangeWaitType;
import net.sf.l2j.gameserver.serverpackets.PrivateStoreMsgBuy;
import net.sf.l2j.gameserver.serverpackets.SystemMessage;

public class SetPrivateStoreListBuy
extends ClientBasePacket {
    private static final String _C__91_SETPRIVATESTORELISTBUY = "[C] 91 SetPrivateStoreListSell";
    private static Logger _log = Logger.getLogger(SetPrivateStoreListBuy.class.getName());
    private final int _count = this.readD();
    private final int[] _items = new int[this._count * 3];

    public SetPrivateStoreListBuy(ByteBuffer buf, ClientThread client) {
        super(buf, client);
        for (int x = 0; x < this._count; ++x) {
            int price;
            int cnt;
            int itemId;
            this._items[x * 3 + 0] = itemId = this.readD();
            this.readH();
            this._items[x * 3 + 1] = cnt = this.readD();
            this._items[x * 3 + 2] = price = this.readD();
        }
    }

    void runImpl() {
        if (this._count < 10) {
            L2PcInstance player = this.getClient().getActiveChar();
            player.setBuyList(new ArrayList<TradeItem>());
            ArrayList<TradeItem> listbuy = player.getBuyList();
            int cost = 0;
            for (int x = 0; x < this._count; ++x) {
                TradeItem temp = new TradeItem();
                int itemId = this._items[x * 3 + 0];
                int cnt = this._items[x * 3 + 1];
                int price = this._items[x * 3 + 2];
                temp.setItemId(itemId);
                temp.setCount(cnt);
                temp.setOwnersPrice(price);
                listbuy.add(temp);
                cost += temp.getOwnersPrice() * temp.getCount();
            }
            if (this._count == 0) {
                listbuy = null;
            }
            if (cost > player.getAdena() || cost <= 0) {
                SystemMessage msg = new SystemMessage(720);
                player.sendPacket(msg);
                return;
            }
            if (this._count != 0) {
                player.setPrivateStoreType(3);
                player.sendPacket(new ChangeWaitType(player, false));
                player.broadcastPacket(new ChangeWaitType(player, false));
                player.broadcastUserInfo();
                player.sendPacket(new PrivateStoreMsgBuy(player));
                player.broadcastPacket(new PrivateStoreMsgBuy(player));
                player.isInStoreMode(true);
                player.sitDown();
            } else {
                player.setPrivateStoreType(0);
                player.broadcastUserInfo();
                player.isInStoreMode(false);
                player.standUp();
            }
        } else {
            L2PcInstance player = this.getClient().getActiveChar();
            player.setPrivateStoreType(0);
            player.broadcastUserInfo();
        }
    }

    public String getType() {
        return _C__91_SETPRIVATESTORELISTBUY;
    }
}

