/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.clientpackets;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.logging.Logger;
import net.sf.l2j.gameserver.ClientThread;
import net.sf.l2j.gameserver.clientpackets.ClientBasePacket;
import net.sf.l2j.gameserver.model.L2ItemInstance;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.TradeItem;
import net.sf.l2j.gameserver.serverpackets.ChangeWaitType;
import net.sf.l2j.gameserver.serverpackets.PrivateStoreMsgSell;

public class SetPrivateStoreListSell
extends ClientBasePacket {
    private static final String _C__74_SETPRIVATESTORELISTSELL = "[C] 74 SetPrivateStoreListSell";
    private static Logger _log = Logger.getLogger(SetPrivateStoreListSell.class.getName());
    private final int _count = this.readD();
    private final int[] _items = new int[this._count * 3];

    public SetPrivateStoreListSell(ByteBuffer buf, ClientThread client) {
        super(buf, client);
        for (int x = 0; x < this._count; ++x) {
            int price;
            int cnt;
            int objectId;
            this._items[x * 3 + 0] = objectId = this.readD();
            this._items[x * 3 + 1] = cnt = this.readD();
            this._items[x * 3 + 2] = price = this.readD();
        }
    }

    void runImpl() {
        L2PcInstance player = this.getClient().getActiveChar();
        player.setSellList(new ArrayList<TradeItem>());
        ArrayList<TradeItem> listsell = player.getSellList();
        for (int x = 0; x < this._count; ++x) {
            TradeItem temp = new TradeItem();
            int objectId = this._items[x * 3 + 0];
            int cnt = this._items[x * 3 + 1];
            int price = this._items[x * 3 + 2];
            temp.setObjectId(objectId);
            L2ItemInstance itemToSell = player.getInventory().getItemByObjectId(objectId);
            if (itemToSell == null) continue;
            if (cnt > itemToSell.getCount()) {
                cnt = itemToSell.getCount();
            }
            temp.setCount(cnt);
            temp.setOwnersPrice(price);
            temp.setItemId(itemToSell.getItemId());
            listsell.add(temp);
        }
        if (this._count == 0) {
            listsell = null;
        }
        if (this._count != 0) {
            player.setPrivateStoreType(1);
            player.sendPacket(new ChangeWaitType(player, false));
            player.broadcastPacket(new ChangeWaitType(player, false));
            player.broadcastUserInfo();
            player.sendPacket(new PrivateStoreMsgSell(player));
            player.broadcastPacket(new PrivateStoreMsgSell(player));
            player.isInStoreMode(true);
            player.sitDown();
        } else {
            player.setPrivateStoreType(0);
            player.broadcastUserInfo();
            player.isInStoreMode(false);
            player.standUp();
        }
    }

    public String getType() {
        return _C__74_SETPRIVATESTORELISTSELL;
    }
}

