/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.clientpackets;

import java.nio.ByteBuffer;
import java.util.logging.Logger;
import net.sf.l2j.gameserver.ClientThread;
import net.sf.l2j.gameserver.clientpackets.ClientBasePacket;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.L2World;
import net.sf.l2j.gameserver.serverpackets.SendTradeDone;
import net.sf.l2j.gameserver.serverpackets.SystemMessage;

public class TradeDone
extends ClientBasePacket {
    private static final String _C__17_TRADEDONE = "[C] 17 TradeDone";
    private static Logger _log = Logger.getLogger(TradeDone.class.getName());
    private final int _response = this.readD();

    public TradeDone(ByteBuffer buf, ClientThread client) {
        super(buf, client);
    }

    void runImpl() {
        L2PcInstance player = this.getClient().getActiveChar();
        L2PcInstance requestor = player.getTransactionRequester();
        if (requestor != null && requestor.getTransactionRequester() != null) {
            if (this._response == 1) {
                player.getTradeList().setConfirmedTrade(true);
                if (requestor.getTradeList().hasConfirmed()) {
                    boolean trade1Valid = player.getTradeList().validateTrade(player, requestor);
                    boolean trade2Valid = requestor.getTradeList().validateTrade(requestor, player);
                    if (trade1Valid && trade2Valid) {
                        player.getTradeList().tradeItems(player, requestor);
                        requestor.getTradeList().tradeItems(requestor, player);
                        requestor.getTradeList().getItems().clear();
                        player.getTradeList().getItems().clear();
                    }
                    requestor.sendPacket(new SendTradeDone(1));
                    player.sendPacket(new SendTradeDone(1));
                    SystemMessage msg = new SystemMessage(123);
                    SystemMessage sm = new SystemMessage(298);
                    if (trade1Valid && trade2Valid) {
                        requestor.sendPacket(msg);
                        player.sendPacket(msg);
                    } else if (!trade2Valid) {
                        String msgToSend = " " + requestor.getName() + " tried a trade dupe";
                        _log.warning(msgToSend);
                        L2PcInstance[] list = L2World.getInstance().getAllGMs();
                        sm = new SystemMessage(614);
                        sm.addString(msgToSend);
                        for (int i = 0; i < list.length; ++i) {
                            list[i].sendPacket(sm);
                        }
                        player.sendMessage("Trade failed");
                        requestor.sendMessage("Trade failed, dont try to dupe!");
                    } else if (!trade1Valid) {
                        String msgToSend = " " + player.getName() + " tried a trade dupe";
                        _log.warning(msgToSend);
                        L2PcInstance[] list = L2World.getInstance().getAllGMs();
                        sm = new SystemMessage(614);
                        sm.addString(msgToSend);
                        for (int i = 0; i < list.length; ++i) {
                            list[i].sendPacket(sm);
                        }
                        requestor.sendMessage("Trade failed");
                        player.sendMessage("Trade failed, dont try to dupe!");
                    }
                    requestor.setTransactionRequester(null);
                    player.setTransactionRequester(null);
                } else {
                    SystemMessage msg = new SystemMessage(121);
                    msg.addString(player.getName());
                    requestor.sendPacket(msg);
                }
            } else {
                player.sendPacket(new SendTradeDone(0));
                requestor.sendPacket(new SendTradeDone(0));
                player.setTradeList(null);
                requestor.setTradeList(null);
                SystemMessage msg = new SystemMessage(124);
                msg.addString(player.getName());
                requestor.sendPacket(msg);
                requestor.setTransactionRequester(null);
                player.setTransactionRequester(null);
            }
        } else {
            player.sendPacket(new SendTradeDone(0));
            SystemMessage msg = new SystemMessage(145);
            player.sendPacket(msg);
            player.setTransactionRequester(null);
            if (requestor != null) {
                requestor.setTradeList(null);
            }
            player.setTradeList(null);
        }
    }

    public String getType() {
        return _C__17_TRADEDONE;
    }
}

