/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.clientpackets;

import java.nio.ByteBuffer;
import java.util.logging.Logger;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.ClientThread;
import net.sf.l2j.gameserver.clientpackets.ClientBasePacket;
import net.sf.l2j.gameserver.model.L2Object;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.L2World;
import net.sf.l2j.gameserver.serverpackets.SendTradeRequest;
import net.sf.l2j.gameserver.serverpackets.SystemMessage;

public class TradeRequest
extends ClientBasePacket {
    private static final String TRADEREQUEST__C__15 = "[C] 15 TradeRequest";
    private static Logger _log = Logger.getLogger(TradeRequest.class.getName());
    private final int _objectId = this.readD();

    public TradeRequest(ByteBuffer buf, ClientThread client) {
        super(buf, client);
    }

    void runImpl() {
        L2PcInstance player = this.getClient().getActiveChar();
        L2World world = L2World.getInstance();
        L2Object target = world.findObject(this._objectId);
        if (player.getPrivateStoreType() != 0) {
            player.sendPacket(new SystemMessage(1065));
            return;
        }
        if (target == null || !(target instanceof L2PcInstance) || target.getObjectId() == player.getObjectId()) {
            player.sendPacket(new SystemMessage(144));
            return;
        }
        if (player.isTransactionInProgress()) {
            if (Config.DEBUG) {
                _log.fine("already trading with someone");
            }
            player.sendPacket(new SystemMessage(142));
            return;
        }
        L2PcInstance pcTarget = (L2PcInstance)target;
        if (player.knowsObject(target) && !pcTarget.isTransactionInProgress()) {
            pcTarget.setTransactionRequester(player);
            player.setTransactionRequester(pcTarget);
            pcTarget.sendPacket(new SendTradeRequest(player.getObjectId()));
            SystemMessage sm = new SystemMessage(118);
            sm.addString(pcTarget.getName());
            player.sendPacket(sm);
        } else {
            SystemMessage sm = new SystemMessage(153);
            sm.addString(pcTarget.getName());
            player.sendPacket(sm);
            _log.info("transaction already in progress.");
        }
    }

    public String getType() {
        return TRADEREQUEST__C__15;
    }
}

